/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.handler;

import com.twitter.finagle.stats.BucketAndCount;
import com.twitter.server.handler.HistogramQueryHandler;
import com.twitter.server.util.HtmlUtils$;
import com.twitter.server.util.JsonConverter$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class HistogramQueryHandler$ {
    public static final HistogramQueryHandler$ MODULE$;
    private final String ContentTypeJson;
    private final String ContentTypeHtml;
    private final String render;

    static {
        new HistogramQueryHandler$();
    }

    public String ContentTypeJson() {
        return this.ContentTypeJson;
    }

    public String ContentTypeHtml() {
        return this.ContentTypeHtml;
    }

    public int countPoints(Seq<BucketAndCount> counts) {
        return BoxesRunTime.unboxToInt((Object)counts.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x0$1, BucketAndCount x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
                if (tuple2 != null) {
                    int acc = tuple2._1$mcI$sp();
                    BucketAndCount v = (BucketAndCount)tuple2._2();
                    int n = acc + v.count();
                    return n;
                }
                throw new MatchError((Object)tuple2);
            }
        }));
    }

    public Seq<HistogramQueryHandler.BucketAndPercentage> pdf(Seq<BucketAndCount> counts) {
        int count = this.countPoints(counts);
        return (Seq)counts.map((Function1)new Serializable(count){
            public static final long serialVersionUID = 0L;
            private final int count$1;

            public final HistogramQueryHandler.BucketAndPercentage apply(BucketAndCount v) {
                return new HistogramQueryHandler.BucketAndPercentage(v.lowerLimit(), v.upperLimit(), (float)v.count() / (float)this.count$1);
            }
            {
                this.count$1 = count$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<HistogramQueryHandler.BucketAndPercentage> cdf(Seq<BucketAndCount> counts) {
        int count = this.countPoints(counts);
        IntRef c = IntRef.create((int)0);
        return (Seq)counts.map((Function1)new Serializable(count, c){
            public static final long serialVersionUID = 0L;
            private final int count$2;
            private final IntRef c$1;

            public final HistogramQueryHandler.BucketAndPercentage apply(BucketAndCount v) {
                this.c$1.elem += v.count();
                return new HistogramQueryHandler.BucketAndPercentage(v.lowerLimit(), v.upperLimit(), (float)this.c$1.elem / (float)this.count$2);
            }
            {
                this.count$2 = count$2;
                this.c$1 = c$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String deliverData(Seq<BucketAndCount> counts, Function1<Seq<BucketAndCount>, Object> transform) {
        return JsonConverter$.MODULE$.writeToString(transform.apply(counts));
    }

    public String render() {
        return this.render;
    }

    public String renderFront(Seq<String> keys) {
        String css = "\n      <link type=\"text/css\" href=\"/admin/files/css/metric-query.css\" rel=\"stylesheet\"/>\n      <link type=\"text/css\" href=\"/admin/files/css/histogram-homepage.css\" rel=\"stylesheet\"/>\n      ";
        String histogramListing = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      <div id=\"metrics-grid\" class=\"row\">\n        <div class=\"col-md-4 snuggle-right\">\n          <ul id=\"metrics\" class=\"list-unstyled\">\n            ", "\n          </ul>\n        </div>\n        <div class=\"col-md-8 snuggle-left\">\n          <div style=\"width: 95%; margin: 0 auto;\">\n            <div id=\"metrics-header\">Histograms</div>\n            <ul>\n              <li class=\"metrics-point\">Visualize metric distributions</li>\n              <li class=\"metrics-point\">Download histogram contents</li>\n              <li class=\"metrics-point\">For more, read the\n                <a id=\"doc-link\" href=\"https://twitter.github.io/twitter-server/Features.html#histograms\">docs</a>\n              </li>\n            </ul>\n          </div>\n        </div>\n      </div>\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((TraversableLike)keys.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String key) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<li id=\"", "\"><a id=\"special-", "\">", "</a></li>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.replace("/", "-"), key, HtmlUtils$.MODULE$.escapeHtml(key)}));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n")}));
        String scripts = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      <script>\n        ", "\n      </script>\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((TraversableLike)keys.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String key) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"document.getElementById(\"special-", "\").setAttribute(\"href\", window.location.href + \"?h=", "&fmt=plot_cdf\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, key}));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n")}));
        return new StringBuilder().append((Object)css).append((Object)histogramListing).append((Object)scripts).toString();
    }

    private final String entry$1(String name) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<tr>\n                <td>", ":</td>\n                <td id=", "></td>\n              </tr>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HtmlUtils$.MODULE$.escapeHtml(name), name}));
    }

    private HistogramQueryHandler$() {
        MODULE$ = this;
        this.ContentTypeJson = "application/json;charset=UTF-8";
        this.ContentTypeHtml = "text/html;charset=UTF-8";
        String css = "<link type=\"text/css\" href=\"/admin/files/css/histogram-query.css\" rel=\"stylesheet\"/>";
        String chart = "<div class=\"chart\">\n             <div id=\"curve_chart\" style=\"width: 900px; height: 500px\"></div>\n           </div>";
        String statsTable = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          <div id=\"stats\">\n            <table>\n              <thead>\n                <th colspan=\"2\">Statistics</th>\n              </thead>\n              <tbody>\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n              </tbody>\n            </table>\n          </div>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1("Count"), this.entry$1("Sum"), this.entry$1("Avg"), this.entry$1("Max"), this.entry$1("Min"), this.entry$1("P-50"), this.entry$1("P-90"), this.entry$1("P-95"), this.entry$1("P-99"), this.entry$1("P-999"), this.entry$1("P-9999")}));
        String buttonPanel = "<div id=\"option-panel\">\n          <form action=\"post\">\n            <span class=\"option-description\">Type:\n              <a id=\"PDF\" class=\"button-switch button-light-green left-rounded\" title=\"Probability density function\">PDF</a><a id=\"CDF\" class=\"button-switch button-green right-rounded\" title=\"Cumulative distribution function\">CDF</a>\n            </span>\n\n            <span class=\"option-description\">Scale:\n              <a id=\"reg\" class=\"button-switch button-red left-rounded\" title=\"Linear scale\">Reg</a><a id=\"log\" class=\"button-switch button-light-red right-rounded\" title=\"Log scale\">Log</a>\n            </span>\n\n            <span class=\"option-description\">Refresh:\n              <a id=\"refreshOn\" class=\"button-switch button-gray left-rounded\" title=\"Refresh the plot every minute\">On</a><a id=\"refreshOff\" class=\"button-switch button-black right-rounded\">Off</a>\n            </span>\n\n            <span class=\"option-description-last\"><a id=\"download-link\" class=\"button-download button-blue\" title=\"Download bucket counts in json\">Download</a></span>\n          </form>\n        </div>";
        String scripts = "\n        <script type=\"text/javascript\" src=\"https://www.gstatic.com/charts/loader.js\"></script>\n        <script type=\"text/javascript\" src=\"/admin/files/js/histogram-utils.js\"></script>\n        <script type=\"text/javascript\" src=\"/admin/files/js/histogram-dom.js\"></script>\n        <script type=\"text/javascript\" src=\"/admin/files/js/histogram-main.js\"></script>";
        this.render = new StringBuilder().append((Object)css).append((Object)chart).append((Object)statsTable).append((Object)buttonPanel).append((Object)scripts).toString();
    }
}

