/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.util;

import com.twitter.finagle.Service;
import com.twitter.finagle.Service$;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.MediaType$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Response$;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.http.Version$;
import com.twitter.io.Buf;
import com.twitter.server.util.HttpUtils$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import java.util.List;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class HttpUtils$ {
    public static final HttpUtils$ MODULE$;

    static {
        new HttpUtils$();
    }

    public Service<Request, Response> combine(Seq<Service<Request, Response>> services) {
        return Service$.MODULE$.mk((Function1)new Serializable(services){
            public static final long serialVersionUID = 0L;
            private final Seq services$1;

            public final Future<Response> apply(Request req) {
                return this.com$twitter$server$util$HttpUtils$$anonfun$$loop$1(this.services$1, req);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Future com$twitter$server$util$HttpUtils$$anonfun$$loop$1(Seq services, Request req$1) {
                Option option;
                Seq seq = services;
                Option option2 = package$.MODULE$.$plus$colon().unapply((SeqLike)seq);
                if (!option2.isEmpty()) {
                    Service service = (Service)((Tuple2)option2.get())._1();
                    Seq seq2 = (Seq)((Tuple2)option2.get())._2();
                    if (Nil$.MODULE$.equals(seq2)) {
                        return service.apply((Object)req$1);
                    }
                }
                if ((option = package$.MODULE$.$plus$colon().unapply((SeqLike)seq)).isEmpty()) {
                    if (!Nil$.MODULE$.equals(seq)) throw new MatchError((Object)seq);
                    return Future$.MODULE$.value((Object)Response$.MODULE$.apply(req$1.version(), Status$.MODULE$.NotFound()));
                }
                Service service = (Service)((Tuple2)option.get())._1();
                Seq tail = (Seq)((Tuple2)option.get())._2();
                return service.apply((Object)req$1).flatMap((Function1)new Serializable(this, tail, req$1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.combine.1 $outer;
                    private final Seq tail$1;
                    private final Request req$1;

                    public final Future<Response> apply(Response rep) {
                        Status status = rep.status();
                        Status status2 = Status$.MODULE$.NotFound();
                        return !(status != null ? !status.equals(status2) : status2 != null) ? this.$outer.com$twitter$server$util$HttpUtils$$anonfun$$loop$1(this.tail$1, this.req$1) : Future$.MODULE$.value((Object)rep);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tail$1 = tail$1;
                        this.req$1 = req$1;
                    }
                });
            }
            {
                this.services$1 = services$1;
            }
        });
    }

    public boolean accepts(Request req, String contentType) {
        return req.headerMap().get("Accept").exists((Function1)new Serializable(contentType){
            public static final long serialVersionUID = 0L;
            private final String contentType$1;

            public final boolean apply(String x$1) {
                return x$1.contains(this.contentType$1);
            }
            {
                this.contentType$1 = contentType$1;
            }
        });
    }

    public boolean expectsHtml(Request req) {
        QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
        return decoder.getPath().endsWith(".html") || this.accepts(req, MediaType$.MODULE$.Html());
    }

    public boolean expectsJson(Request req) {
        QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
        return decoder.getPath().endsWith(".json") || this.accepts(req, MediaType$.MODULE$.Json());
    }

    public Future<Response> newResponse(Version version, Status status, Iterable<Tuple2<String, Object>> headers, String contentType, Buf content) {
        Response response = Response$.MODULE$.apply(version, status);
        response.content_$eq(content);
        headers.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(response){
            public static final long serialVersionUID = 0L;
            private final Response response$1;

            public final HeaderMap apply(Tuple2<String, Object> x$2) {
                Tuple2<String, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    HeaderMap headerMap = this.response$1.headerMap().add(k, v.toString());
                    return headerMap;
                }
                throw new MatchError(tuple2);
            }
            {
                this.response$1 = response$1;
            }
        });
        response.headerMap().add("Content-Language", "en");
        response.headerMap().add("Content-Length", ((Object)BoxesRunTime.boxToInteger((int)content.length())).toString());
        response.headerMap().add("Content-Type", contentType);
        return Future$.MODULE$.value((Object)response);
    }

    public Version newResponse$default$1() {
        return Version$.MODULE$.Http11();
    }

    public Status newResponse$default$2() {
        return Status$.MODULE$.Ok();
    }

    public Iterable<Tuple2<String, Object>> newResponse$default$3() {
        return (Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Future<Response> newOk(String msg) {
        String x$4 = "text/plain;charset=UTF-8";
        Buf x$5 = Buf.Utf8$.MODULE$.apply(msg);
        Version x$6 = this.newResponse$default$1();
        Status x$7 = this.newResponse$default$2();
        Iterable<Tuple2<String, Object>> x$8 = this.newResponse$default$3();
        return this.newResponse(x$6, x$7, x$8, x$4, x$5);
    }

    public Future<Response> new404(String msg) {
        Status x$9 = Status$.MODULE$.NotFound();
        String x$10 = "text/plain;charset=UTF-8";
        Buf x$11 = Buf.Utf8$.MODULE$.apply(msg);
        Version x$12 = this.newResponse$default$1();
        Iterable<Tuple2<String, Object>> x$13 = this.newResponse$default$3();
        return this.newResponse(x$12, x$9, x$13, x$10, x$11);
    }

    public Tuple2<String, Map<String, Seq<String>>> parse(String uri) {
        QueryStringDecoder qsd = new QueryStringDecoder(uri);
        Map params = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(qsd.getParameters()).asScala()).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(List<String> x$3) {
                return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSeq();
            }
        });
        return new Tuple2((Object)qsd.getPath(), (Object)params);
    }

    private HttpUtils$() {
        MODULE$ = this;
    }
}

