/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.lint;

import com.twitter.util.lint.Category;
import com.twitter.util.lint.Issue;
import com.twitter.util.lint.Rule;
import com.twitter.util.lint.Rule$;
import java.net.URL;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class LoggingRules$ {
    public static final LoggingRules$ MODULE$;
    private final Regex jarNameRegex;
    private final Rule MultipleSlf4jImpls;
    private final Rule NoLoggingHandler;

    static {
        new LoggingRules$();
    }

    private Regex jarNameRegex() {
        return this.jarNameRegex;
    }

    public String jarName(String url) {
        String name;
        String string = url;
        Option option = this.jarNameRegex().unapplySeq((CharSequence)string);
        String string2 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (name = (String)((LinearSeqOptimized)option.get()).apply(0)) : url;
        return string2;
    }

    public Seq<Issue> issues(Seq<String> jarPaths) {
        return jarPaths.length() > 1 ? (Seq)jarPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Issue apply(String jarPath) {
                return new Issue(LoggingRules$.MODULE$.jarName(jarPath));
            }
        }, Seq$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
    }

    public Rule MultipleSlf4jImpls() {
        return this.MultipleSlf4jImpls;
    }

    public Rule NoLoggingHandler() {
        return this.NoLoggingHandler;
    }

    private LoggingRules$() {
        MODULE$ = this;
        this.jarNameRegex = new StringOps(Predef$.MODULE$.augmentString(".*/([^/]+\\.jar)!.*")).r();
        this.MultipleSlf4jImpls = Rule$.MODULE$.apply((Category)Category.Configuration$.MODULE$, "Multiple Slf4j Implementations", "You should only depend on a single concrete implementation of the slf4j api. See http://www.slf4j.org/codes.html#multiple_bindings", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Issue> apply() {
                Seq paths = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ClassLoader.getSystemResources("org/slf4j/impl/StaticLoggerBinder.class")).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(URL x$1) {
                        return x$1.getFile();
                    }
                }).toSeq();
                return LoggingRules$.MODULE$.issues((Seq<String>)paths);
            }
        });
        this.NoLoggingHandler = Rule$.MODULE$.apply((Category)Category.Configuration$.MODULE$, "Admin logging handler implementation to dynamically change log levels is not configured", "To configure, please add a dependency on one of the supported TwitterServer logging implementations which will provide the ability to dynamically change the logging levels for that implementation: logback-classic, slf4j-log4j12, or slf4j-jdk14.", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Issue> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Issue[]{new Issue("No logging handler implementation configured.")}));
            }
        });
    }
}

