/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.lint;

import com.twitter.concurrent.Scheduler;
import com.twitter.concurrent.Scheduler$;
import com.twitter.conversions.time$;
import com.twitter.util.Duration;
import com.twitter.util.Duration$;
import com.twitter.util.lint.Category;
import com.twitter.util.lint.Issue;
import com.twitter.util.lint.Rule;
import com.twitter.util.lint.Rule$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class SchedulerBlockingRule$ {
    public static final SchedulerBlockingRule$ MODULE$;

    static {
        new SchedulerBlockingRule$();
    }

    public Rule apply() {
        return this.apply((Scheduler)Scheduler$.MODULE$, time$.MODULE$.intToTimeableNumber(5).seconds());
    }

    public Rule apply(Scheduler scheduler, Duration minimumBlocking) {
        return Rule$.MODULE$.apply((Category)Category.Performance$.MODULE$, "Blocking the Scheduler", new StringOps(Predef$.MODULE$.augmentString("\n        |Blocking the Scheduler via usage of `com.twitter.util.Await` can\n        |cause unexpected slowness, a decrease in throughput, and potentially\n        |deadlocks for your application. Developers should instead write\n        |code in terms of the `Future` combinators or do the blocking in\n        |a `com.twitter.util.FuturePool`. To help track down the code\n        |doing the blocking, you can set the System property\n        |`-Dcom.twitter.concurrent.schedulerSampleBlockingFraction=$fraction`\n        |which is defined in `com.twitter.concurrent.LocalScheduler` and it will\n        |log that fraction of blocking stacktraces.\n        |\n        |The metric for this lint rule is exported at \"scheduler/blocking_ms\"\n        |and more details can be found at:\n        |https://twitter.github.io/finagle/guide/Metrics.html#scheduler\n      ")).stripMargin(), (Function0)new Serializable(scheduler, minimumBlocking){
            public static final long serialVersionUID = 0L;
            private final Scheduler scheduler$1;
            private final Duration minimumBlocking$1;

            public final Seq<Issue> apply() {
                Duration blocking = Duration$.MODULE$.fromNanoseconds(this.scheduler$1.blockingTimeNanos());
                return blocking.$less$eq((Object)this.minimumBlocking$1) ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Issue[]{new Issue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The Scheduler has been blocked for ", " milliseconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)blocking.inMillis())})))}));
            }
            {
                this.scheduler$1 = scheduler$1;
                this.minimumBlocking$1 = minimumBlocking$1;
            }
        });
    }

    private SchedulerBlockingRule$() {
        MODULE$ = this;
    }
}

