/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.util;

import com.twitter.finagle.Service;
import com.twitter.finagle.Service$;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.HttpMuxer;
import com.twitter.finagle.http.MediaType$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Response$;
import com.twitter.finagle.http.Route;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.http.Version$;
import com.twitter.io.Buf;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import java.util.List;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class HttpUtils$ {
    public static final HttpUtils$ MODULE$;

    static {
        new HttpUtils$();
    }

    public Service<Request, Response> combine(Seq<HttpMuxer> services) {
        return Service$.MODULE$.mk((Function1)new Serializable(services){
            public static final long serialVersionUID = 0L;
            private final Seq services$1;

            public final Future<Response> apply(Request req) {
                Seq routes = (Seq)this.services$1.flatMap((Function1)new Serializable(this, req){
                    public static final long serialVersionUID = 0L;
                    private final Request req$1;

                    public final Iterable<Route> apply(HttpMuxer x$1) {
                        return Option$.MODULE$.option2Iterable(x$1.route(this.req$1));
                    }
                    {
                        this.req$1 = req$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return routes.nonEmpty() ? ((Route)routes.maxBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Route x$2) {
                        return x$2.pattern().length();
                    }
                }, (Ordering)Ordering.Int$.MODULE$)).handler().apply((Object)req) : Future$.MODULE$.value((Object)Response$.MODULE$.apply(req.version(), Status$.MODULE$.NotFound()));
            }
            {
                this.services$1 = services$1;
            }
        });
    }

    public boolean accepts(Request req, String contentType) {
        return req.headerMap().get("Accept").exists((Function1)new Serializable(contentType){
            public static final long serialVersionUID = 0L;
            private final String contentType$1;

            public final boolean apply(String x$3) {
                return x$3.contains(this.contentType$1);
            }
            {
                this.contentType$1 = contentType$1;
            }
        });
    }

    public boolean expectsHtml(Request req) {
        QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
        return decoder.getPath().endsWith(".html") || this.accepts(req, MediaType$.MODULE$.Html());
    }

    public boolean expectsJson(Request req) {
        QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
        return decoder.getPath().endsWith(".json") || this.accepts(req, MediaType$.MODULE$.Json());
    }

    public Future<Response> newResponse(Version version, Status status, Iterable<Tuple2<String, Object>> headers, String contentType, Buf content) {
        Response response = Response$.MODULE$.apply(version, status);
        response.content_$eq(content);
        headers.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(response){
            public static final long serialVersionUID = 0L;
            private final Response response$1;

            public final HeaderMap apply(Tuple2<String, Object> x$4) {
                Tuple2<String, Object> tuple2 = x$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    HeaderMap headerMap = this.response$1.headerMap().add(k, v.toString());
                    return headerMap;
                }
                throw new MatchError(tuple2);
            }
            {
                this.response$1 = response$1;
            }
        });
        response.headerMap().add("Content-Language", "en");
        response.headerMap().add("Content-Length", ((Object)BoxesRunTime.boxToInteger((int)content.length())).toString());
        response.headerMap().add("Content-Type", contentType);
        return Future$.MODULE$.value((Object)response);
    }

    public Version newResponse$default$1() {
        return Version$.MODULE$.Http11();
    }

    public Status newResponse$default$2() {
        return Status$.MODULE$.Ok();
    }

    public Iterable<Tuple2<String, Object>> newResponse$default$3() {
        return (Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Future<Response> newOk(String msg, String contentType) {
        String x$6 = contentType;
        Buf x$7 = Buf.Utf8$.MODULE$.apply(msg);
        Version x$8 = this.newResponse$default$1();
        Status x$9 = this.newResponse$default$2();
        Iterable<Tuple2<String, Object>> x$10 = this.newResponse$default$3();
        return this.newResponse(x$8, x$9, x$10, x$6, x$7);
    }

    public String newOk$default$2() {
        return "text/plain;charset=UTF-8";
    }

    public Future<Response> new404(String msg, String contentType) {
        Status x$11 = Status$.MODULE$.NotFound();
        String x$12 = contentType;
        Buf x$13 = Buf.Utf8$.MODULE$.apply(msg);
        Version x$14 = this.newResponse$default$1();
        Iterable<Tuple2<String, Object>> x$15 = this.newResponse$default$3();
        return this.newResponse(x$14, x$11, x$15, x$12, x$13);
    }

    public String new404$default$2() {
        return "text/plain;charset=UTF-8";
    }

    public Tuple2<String, Map<String, Seq<String>>> parse(String uri) {
        QueryStringDecoder qsd = new QueryStringDecoder(uri);
        Map params = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(qsd.getParameters()).asScala()).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(List<String> x$5) {
                return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$5).asScala()).toSeq();
            }
        });
        return new Tuple2((Object)qsd.getPath(), (Object)params);
    }

    private HttpUtils$() {
        MODULE$ = this;
    }
}

