/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.handler;

import com.twitter.finagle.stats.BucketAndCount;
import com.twitter.server.handler.HistogramQueryHandler;
import com.twitter.server.util.HtmlUtils$;
import com.twitter.server.util.JsonConverter$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class HistogramQueryHandler$ {
    public static HistogramQueryHandler$ MODULE$;
    private final String com$twitter$server$handler$HistogramQueryHandler$$ContentTypeJson;
    private final String com$twitter$server$handler$HistogramQueryHandler$$ContentTypeHtml;
    private final Seq<Tuple2<String, Object>> com$twitter$server$handler$HistogramQueryHandler$$SummaryThresholds;
    private final String render;

    static {
        new HistogramQueryHandler$();
    }

    public String com$twitter$server$handler$HistogramQueryHandler$$ContentTypeJson() {
        return this.com$twitter$server$handler$HistogramQueryHandler$$ContentTypeJson;
    }

    public String com$twitter$server$handler$HistogramQueryHandler$$ContentTypeHtml() {
        return this.com$twitter$server$handler$HistogramQueryHandler$$ContentTypeHtml;
    }

    public Seq<Tuple2<String, Object>> com$twitter$server$handler$HistogramQueryHandler$$SummaryThresholds() {
        return this.com$twitter$server$handler$HistogramQueryHandler$$SummaryThresholds;
    }

    public int countPoints(Seq<BucketAndCount> counts) {
        return BoxesRunTime.unboxToInt((Object)counts.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & java.io.Serializable & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)HistogramQueryHandler$.$anonfun$countPoints$1(BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
    }

    public Seq<HistogramQueryHandler.BucketAndPercentage> pdf(Seq<BucketAndCount> counts) {
        int count = this.countPoints(counts);
        return (Seq)counts.map((Function1 & java.io.Serializable & Serializable)v -> new HistogramQueryHandler.BucketAndPercentage(v.lowerLimit(), v.upperLimit(), (float)v.count() / (float)count), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<HistogramQueryHandler.BucketAndPercentage> cdf(Seq<BucketAndCount> counts) {
        int count = this.countPoints(counts);
        IntRef c = IntRef.create((int)0);
        return (Seq)counts.map((Function1 & java.io.Serializable & Serializable)v -> {
            c$1.elem += v.count();
            return new HistogramQueryHandler.BucketAndPercentage(v.lowerLimit(), v.upperLimit(), (float)c$1.elem / (float)count);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String deliverData(Seq<BucketAndCount> counts, Function1<Seq<BucketAndCount>, Object> transform) {
        return JsonConverter$.MODULE$.writeToString(transform.apply(counts));
    }

    public String render() {
        return this.render;
    }

    public String renderFront(Seq<String> keys) {
        String css = "\n      <link type=\"text/css\" href=\"/admin/files/css/metric-query.css\" rel=\"stylesheet\"/>\n      <link type=\"text/css\" href=\"/admin/files/css/histogram-homepage.css\" rel=\"stylesheet\"/>\n      ";
        String histogramListing = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      <div id=\"metrics-grid\" class=\"row\">\n        <div class=\"col-md-4 snuggle-right\">\n          <ul id=\"metrics\" class=\"list-unstyled\">\n            ", "\n          </ul>\n        </div>\n        <div class=\"col-md-8 snuggle-left\">\n          <div style=\"width: 95%; margin: 0 auto;\">\n            <div id=\"metrics-header\">Histograms</div>\n            <ul>\n              <li class=\"metrics-point\">Visualize metric distributions</li>\n              <li class=\"metrics-point\">Download histogram contents</li>\n              <li class=\"metrics-point\">For more, read the\n                <a id=\"doc-link\" href=\"https://twitter.github.io/twitter-server/Features.html#histograms\">docs</a>\n              </li>\n            </ul>\n          </div>\n        </div>\n      </div>\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((TraversableLike)keys.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & java.io.Serializable & Serializable)key -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<li id=\"", "\"><a id=\"special-", "\">", "</a></li>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.replace("/", "-"), key, HtmlUtils$.MODULE$.escapeHtml((String)key)})), Seq$.MODULE$.canBuildFrom())).mkString("\n")}));
        String scripts = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      <script>\n        ", "\n      </script>\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((TraversableLike)keys.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & java.io.Serializable & Serializable)key -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"document.getElementById(\"special-", "\").setAttribute(\"href\", window.location.href + \"?h=", "&fmt=plot_cdf\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, key})), Seq$.MODULE$.canBuildFrom())).mkString("\n")}));
        return css + histogramListing + scripts;
    }

    public static final /* synthetic */ int $anonfun$countPoints$1(int x0$1, BucketAndCount x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int acc = tuple2._1$mcI$sp();
        BucketAndCount v = (BucketAndCount)tuple2._2();
        int n = acc + v.count();
        return n;
    }

    private static final String entry$1(String id, String display) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<tr>\n                <td style=\"text-align:left\">", "</td>\n                <td style=\"text-align:left\" id=\"", "\"></td>\n              </tr>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HtmlUtils$.MODULE$.escapeHtml(display), id}));
    }

    private HistogramQueryHandler$() {
        MODULE$ = this;
        this.com$twitter$server$handler$HistogramQueryHandler$$ContentTypeJson = "application/json;charset=UTF-8";
        this.com$twitter$server$handler$HistogramQueryHandler$$ContentTypeHtml = "text/html;charset=UTF-8";
        this.com$twitter$server$handler$HistogramQueryHandler$$SummaryThresholds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p50"), (Object)BoxesRunTime.boxToDouble((double)0.5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p90"), (Object)BoxesRunTime.boxToDouble((double)0.9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p95"), (Object)BoxesRunTime.boxToDouble((double)0.95)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p99"), (Object)BoxesRunTime.boxToDouble((double)0.99)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p999"), (Object)BoxesRunTime.boxToDouble((double)0.999)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p9999"), (Object)BoxesRunTime.boxToDouble((double)0.9999))}));
        String css = "<link type=\"text/css\" href=\"/admin/files/css/histogram-query.css\" rel=\"stylesheet\"/>";
        String chart = "<div class=\"chart\">\n             <div id=\"curve_chart\" style=\"width: 900px; height: 500px\"></div>\n           </div>";
        String statsTable = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          <div id=\"stats\">\n            <table>\n              <thead>\n                <th style=\"text-align:left\" colspan=\"2\">Details</th>\n              </thead>\n              <tbody>\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n                ", "\n              </tbody>\n            </table>\n          </div>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HistogramQueryHandler$.entry$1("detail_count", "Count"), HistogramQueryHandler$.entry$1("detail_sum", "Sum"), HistogramQueryHandler$.entry$1("detail_average", "Average"), HistogramQueryHandler$.entry$1("detail_min", "Min"), HistogramQueryHandler$.entry$1("detail_max", "Max"), HistogramQueryHandler$.entry$1("detail_p50", "p50"), HistogramQueryHandler$.entry$1("detail_p90", "p90"), HistogramQueryHandler$.entry$1("detail_p95", "p95"), HistogramQueryHandler$.entry$1("detail_p99", "p99"), HistogramQueryHandler$.entry$1("detail_p999", "p999"), HistogramQueryHandler$.entry$1("detail_p9999", "p9999")}));
        String buttonPanel = "<div id=\"option-panel\">\n          <form action=\"post\">\n            <span class=\"option-description\">Type:\n              <a id=\"PDF\" class=\"button-switch button-light-green left-rounded\" title=\"Probability density function\">PDF</a><a id=\"CDF\" class=\"button-switch button-green right-rounded\" title=\"Cumulative distribution function\">CDF</a>\n            </span>\n\n            <span class=\"option-description\">Scale:\n              <a id=\"reg\" class=\"button-switch button-red left-rounded\" title=\"Linear scale\">Reg</a><a id=\"log\" class=\"button-switch button-light-red right-rounded\" title=\"Log scale\">Log</a>\n            </span>\n\n            <span class=\"option-description\">Refresh:\n              <a id=\"refreshOn\" class=\"button-switch button-gray left-rounded\" title=\"Refresh the plot every minute\">On</a><a id=\"refreshOff\" class=\"button-switch button-black right-rounded\">Off</a>\n            </span>\n\n            <span class=\"option-description-last\"><a id=\"download-link\" class=\"button-download button-blue\" title=\"Download bucket counts in json\">Download</a></span>\n          </form>\n        </div>";
        String scripts = "\n        <script type=\"text/javascript\" src=\"https://www.gstatic.com/charts/loader.js\"></script>\n        <script type=\"text/javascript\" src=\"/admin/files/js/histogram-utils.js\"></script>\n        <script type=\"text/javascript\" src=\"/admin/files/js/histogram-dom.js\"></script>\n        <script type=\"text/javascript\" src=\"/admin/files/js/histogram-main.js\"></script>";
        this.render = css + chart + statsTable + buttonPanel + scripts;
    }
}

