/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.handler;

import com.twitter.finagle.stats.MetricBuilder;
import com.twitter.finagle.stats.StatsFormatter;
import com.twitter.finagle.stats.StatsFormatter$;
import com.twitter.finagle.stats.exp.ConstantExpression;
import com.twitter.finagle.stats.exp.Expression;
import com.twitter.finagle.stats.exp.FunctionExpression;
import com.twitter.finagle.stats.exp.HistogramExpression;
import com.twitter.finagle.stats.exp.MetricExpression;
import com.twitter.finagle.stats.exp.NoExpression$;
import com.twitter.finagle.stats.metadataScopeSeparator$;
import com.twitter.server.util.MetricSchemaSource;
import com.twitter.server.util.MetricSchemaSource$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class MetricExpressionHandler$ {
    public static MetricExpressionHandler$ MODULE$;
    private final double com$twitter$server$handler$MetricExpressionHandler$$Version;
    private final StatsFormatter statsFormatter;

    static {
        new MetricExpressionHandler$();
    }

    public MetricSchemaSource $lessinit$greater$default$1() {
        return new MetricSchemaSource(MetricSchemaSource$.MODULE$.$lessinit$greater$default$1());
    }

    public double com$twitter$server$handler$MetricExpressionHandler$$Version() {
        return this.com$twitter$server$handler$MetricExpressionHandler$$Version;
    }

    private StatsFormatter statsFormatter() {
        return this.statsFormatter;
    }

    public String translateToQuery(Expression expr2, boolean shouldRate) {
        String string;
        Expression expression = expr2;
        if (expression instanceof HistogramExpression) {
            HistogramExpression histogramExpression = (HistogramExpression)expression;
            MetricBuilder schema = histogramExpression.metricBuilder();
            Either component = histogramExpression.component();
            string = this.getHisto(schema, (Either<Expression.HistogramComponent, Object>)component);
        } else if (expression instanceof MetricExpression) {
            MetricExpression metricExpression = (MetricExpression)expression;
            MetricBuilder schema = metricExpression.metricBuilder();
            string = this.getMetric(schema, shouldRate);
        } else if (expression instanceof ConstantExpression) {
            String repr;
            ConstantExpression constantExpression = (ConstantExpression)expression;
            string = repr = constantExpression.repr();
        } else if (expression instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression;
            String funcName = functionExpression.fnName();
            Seq exprs = functionExpression.exprs();
            string = new StringBuilder(2).append(funcName).append("(").append(((TraversableOnce)exprs.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.translateToQuery((Expression)expr, shouldRate), Seq$.MODULE$.canBuildFrom())).mkString(",")).append(")").toString();
        } else if (NoExpression$.MODULE$.equals(expression)) {
            string = "null";
        } else {
            throw new MatchError((Object)expression);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private String getHisto(MetricBuilder metricBuilder, Either<Expression.HistogramComponent, Object> histoComponent) {
        block11: {
            block10: {
                name = metricBuilder.name().mkString(metadataScopeSeparator$.MODULE$.apply());
                var6_4 = false;
                var7_5 = null;
                var8_6 = histoComponent;
                if (!(var8_6 instanceof Right)) break block10;
                var9_7 = (Right)var8_6;
                percentile = BoxesRunTime.unboxToDouble((Object)var9_7.value());
                var3_9 = this.statsFormatter().labelPercentile(percentile);
                break block11;
            }
            if (!(var8_6 instanceof Left)) ** GOTO lbl-1000
            var6_4 = true;
            var7_5 = (Left)var8_6;
            var12_10 = (Expression.HistogramComponent)var7_5.value();
            if (Expression.Min$.MODULE$.equals(var12_10)) {
                var3_9 = this.statsFormatter().labelMin();
            } else if (var6_4 && Expression.Max$.MODULE$.equals(var13_11 = (Expression.HistogramComponent)var7_5.value())) {
                var3_9 = this.statsFormatter().labelMax();
            } else if (var6_4 && Expression.Avg$.MODULE$.equals(var14_12 = (Expression.HistogramComponent)var7_5.value())) {
                var3_9 = this.statsFormatter().labelAverage();
            } else if (var6_4 && Expression.Sum$.MODULE$.equals(var15_13 = (Expression.HistogramComponent)var7_5.value())) {
                var3_9 = this.statsFormatter().labelSum();
            } else if (var6_4 && Expression.Count$.MODULE$.equals(var16_14 = (Expression.HistogramComponent)var7_5.value())) {
                var3_9 = this.statsFormatter().labelCount();
            } else {
                throw new MatchError(var8_6);
            }
        }
        component = var3_9;
        return this.statsFormatter().histoName(name, component);
    }

    private String getMetric(MetricBuilder metricBuilder, boolean shouldRate) {
        MetricBuilder.MetricType metricType = metricBuilder.metricType();
        String string = MetricBuilder.CounterType$.MODULE$.equals(metricType) && shouldRate ? new StringBuilder(6).append("rate(").append(metricBuilder.name().mkString(metadataScopeSeparator$.MODULE$.apply())).append(")").toString() : metricBuilder.name().mkString(metadataScopeSeparator$.MODULE$.apply());
        return string;
    }

    private MetricExpressionHandler$() {
        MODULE$ = this;
        this.com$twitter$server$handler$MetricExpressionHandler$$Version = 1.1;
        this.statsFormatter = StatsFormatter$.MODULE$.default();
    }
}

