/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.util;

import com.twitter.finagle.Service;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.HttpMuxer;
import com.twitter.finagle.http.MediaType$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Response$;
import com.twitter.finagle.http.Route;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.http.Version$;
import com.twitter.io.Buf;
import com.twitter.server.util.HttpUtils$;
import com.twitter.util.Closable$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Time;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class HttpUtils$ {
    public static HttpUtils$ MODULE$;

    static {
        new HttpUtils$();
    }

    public Service<Request, Response> combine(Seq<HttpMuxer> services) {
        return new Service<Request, Response>(services){
            private final Seq services$1;

            public Future<Response> apply(Request req) {
                Seq routes = (Seq)this.services$1.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(x$1.route(req)), Seq$.MODULE$.canBuildFrom());
                return routes.nonEmpty() ? ((Route)routes.maxBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)anon.1.$anonfun$apply$2(x$2)), (Ordering)Ordering.Int$.MODULE$)).handler().apply((Object)req) : Future$.MODULE$.value((Object)Response$.MODULE$.apply(req.version(), Status$.MODULE$.NotFound()));
            }

            public Future<BoxedUnit> close(Time deadline) {
                return Closable$.MODULE$.all(this.services$1).close(deadline);
            }

            public static final /* synthetic */ int $anonfun$apply$2(Route x$2) {
                return x$2.pattern().length();
            }
            {
                this.services$1 = services$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(com.twitter.finagle.http.Request com.twitter.finagle.http.HttpMuxer ), $anonfun$apply$2$adapted(com.twitter.finagle.http.Route )}, serializedLambda);
            }
        };
    }

    public boolean accepts(Request req, String contentType) {
        return req.headerMap().get("Accept").exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains(contentType)));
    }

    public boolean expectsHtml(Request req) {
        QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
        return decoder.path().endsWith(".html") || this.accepts(req, MediaType$.MODULE$.Html());
    }

    public boolean expectsJson(Request req) {
        QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
        return decoder.path().endsWith(".json") || this.accepts(req, MediaType$.MODULE$.Json());
    }

    public Future<Response> newResponse(Version version, Status status, Iterable<Tuple2<String, Object>> headers, String contentType, Buf content) {
        Response response = Response$.MODULE$.apply(version, status);
        response.content_$eq(content);
        headers.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HttpUtils$.$anonfun$newResponse$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            HeaderMap headerMap = response.headerMap().add(k, v.toString());
            return headerMap;
        });
        response.headerMap().add("Content-Language", "en");
        response.headerMap().add("Content-Length", ((Object)BoxesRunTime.boxToInteger((int)content.length())).toString());
        response.headerMap().add("Content-Type", contentType);
        return Future$.MODULE$.value((Object)response);
    }

    public Version newResponse$default$1() {
        return Version$.MODULE$.Http11();
    }

    public Status newResponse$default$2() {
        return Status$.MODULE$.Ok();
    }

    public Iterable<Tuple2<String, Object>> newResponse$default$3() {
        return (Iterable)Nil$.MODULE$;
    }

    public Future<Response> newOk(String msg, String contentType) {
        String x$1 = contentType;
        Buf x$2 = Buf.Utf8$.MODULE$.apply(msg);
        Version x$3 = this.newResponse$default$1();
        Status x$4 = this.newResponse$default$2();
        Iterable<Tuple2<String, Object>> x$5 = this.newResponse$default$3();
        return this.newResponse(x$3, x$4, x$5, x$1, x$2);
    }

    public String newOk$default$2() {
        return "text/plain;charset=UTF-8";
    }

    public Future<Response> new404(String msg, String contentType) {
        Status x$1 = Status$.MODULE$.NotFound();
        String x$2 = contentType;
        Buf x$3 = Buf.Utf8$.MODULE$.apply(msg);
        Version x$4 = this.newResponse$default$1();
        Iterable<Tuple2<String, Object>> x$5 = this.newResponse$default$3();
        return this.newResponse(x$4, x$1, x$5, x$2, x$3);
    }

    public String new404$default$2() {
        return "text/plain;charset=UTF-8";
    }

    public static final /* synthetic */ boolean $anonfun$newResponse$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private HttpUtils$() {
        MODULE$ = this;
    }
}

