/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.twitter.finagle.stats.MetricBuilder;
import com.twitter.finagle.stats.StatsFormatter;
import com.twitter.finagle.stats.StatsFormatter$;
import com.twitter.finagle.stats.metadataScopeSeparator$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class SchemaSerializer$
extends StdSerializer<MetricBuilder> {
    public static SchemaSerializer$ MODULE$;
    private final StatsFormatter statsFormatter;

    static {
        new SchemaSerializer$();
    }

    public void serialize(MetricBuilder metricBuilder, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        String string;
        String formattedName = metricBuilder.name().mkString(metadataScopeSeparator$.MODULE$.apply());
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("name", formattedName);
        jsonGenerator.writeArrayFieldStart("relative_name");
        Seq seq = metricBuilder.relativeName();
        Nil$ nil$ = Nil$.MODULE$;
        if (seq == null ? nil$ != null : !seq.equals(nil$)) {
            metricBuilder.relativeName().foreach((Function1 & Serializable & scala.Serializable)segment -> {
                jsonGenerator.writeString(SchemaSerializer$.MODULE$.convertNullToString(segment));
                return BoxedUnit.UNIT;
            });
        } else {
            metricBuilder.name().foreach((Function1 & Serializable & scala.Serializable)segment -> {
                jsonGenerator.writeString(SchemaSerializer$.MODULE$.convertNullToString(segment));
                return BoxedUnit.UNIT;
            });
        }
        jsonGenerator.writeEndArray();
        MetricBuilder.MetricType metricType = metricBuilder.metricType();
        if (MetricBuilder.UnlatchedCounter$.MODULE$.equals(metricType)) {
            string = "unlatched_counter";
        } else if (MetricBuilder.CounterType$.MODULE$.equals(metricType)) {
            string = "counter";
        } else if (MetricBuilder.CounterishGaugeType$.MODULE$.equals(metricType)) {
            string = "counterish_gauge";
        } else if (MetricBuilder.GaugeType$.MODULE$.equals(metricType)) {
            string = "gauge";
        } else if (MetricBuilder.HistogramType$.MODULE$.equals(metricType)) {
            string = "histogram";
        } else {
            throw new MatchError((Object)metricType);
        }
        String dataType = string;
        jsonGenerator.writeStringField("kind", dataType);
        jsonGenerator.writeObjectFieldStart("source");
        jsonGenerator.writeStringField("class", (String)metricBuilder.sourceClass().getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unspecified"));
        jsonGenerator.writeStringField("category", metricBuilder.role().toString());
        jsonGenerator.writeStringField("process_path", (String)metricBuilder.processPath().getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unspecified"));
        jsonGenerator.writeEndObject();
        jsonGenerator.writeStringField("description", metricBuilder.description());
        jsonGenerator.writeStringField("unit", metricBuilder.units().toString());
        jsonGenerator.writeStringField("verbosity", metricBuilder.verbosity().toString());
        jsonGenerator.writeBooleanField("key_indicator", metricBuilder.keyIndicator());
        MetricBuilder.MetricType metricType2 = metricBuilder.metricType();
        if (MetricBuilder.HistogramType$.MODULE$.equals(metricType2)) {
            jsonGenerator.writeObjectFieldStart("buckets");
            jsonGenerator.writeStringField("count", new StringBuilder(5).append(this.statsFormatter.histogramSeparator()).append("count").toString());
            jsonGenerator.writeStringField("sum", new StringBuilder(3).append(this.statsFormatter.histogramSeparator()).append("sum").toString());
            jsonGenerator.writeStringField("average", new StringBuilder(0).append(this.statsFormatter.histogramSeparator()).append(this.statsFormatter.labelAverage()).toString());
            jsonGenerator.writeStringField("minimum", new StringBuilder(0).append(this.statsFormatter.histogramSeparator()).append(this.statsFormatter.labelMin()).toString());
            jsonGenerator.writeStringField("maximum", new StringBuilder(0).append(this.statsFormatter.histogramSeparator()).append(this.statsFormatter.labelMax()).toString());
            metricBuilder.percentiles().foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)bucket -> jsonGenerator.writeStringField(((Object)BoxesRunTime.boxToDouble((double)bucket)).toString(), new StringBuilder(0).append(SchemaSerializer$.MODULE$.statsFormatter.histogramSeparator()).append(SchemaSerializer$.MODULE$.statsFormatter.labelPercentile(bucket)).toString()));
            jsonGenerator.writeEndObject();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        jsonGenerator.writeEndObject();
    }

    private String convertNullToString(String segment) {
        return segment == null ? "null" : segment;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SchemaSerializer$() {
        super(MetricBuilder.class);
        MODULE$ = this;
        this.statsFormatter = StatsFormatter$.MODULE$.default();
    }
}

