/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.util;

import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.MediaType$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Response$;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.http.Version$;
import com.twitter.io.Buf;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class HttpUtils$ {
    public static HttpUtils$ MODULE$;

    static {
        new HttpUtils$();
    }

    public boolean accepts(Request req, String contentType) {
        return req.headerMap().get("Accept").exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains(contentType)));
    }

    public boolean expectsHtml(Request req) {
        QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
        return decoder.path().endsWith(".html") || this.accepts(req, MediaType$.MODULE$.Html());
    }

    public boolean expectsJson(Request req) {
        QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
        return decoder.path().endsWith(".json") || this.accepts(req, MediaType$.MODULE$.Json());
    }

    public Future<Response> newResponse(Version version, Status status, Iterable<Tuple2<String, Object>> headers, String contentType, Buf content) {
        Response response = Response$.MODULE$.apply(version, status);
        response.content_$eq(content);
        headers.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HttpUtils$.$anonfun$newResponse$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            HeaderMap headerMap = response.headerMap().add(k, v.toString());
            return headerMap;
        });
        response.headerMap().add("Content-Language", "en");
        response.headerMap().add("Content-Length", ((Object)BoxesRunTime.boxToInteger((int)content.length())).toString());
        response.headerMap().add("Content-Type", contentType);
        return Future$.MODULE$.value((Object)response);
    }

    public Version newResponse$default$1() {
        return Version$.MODULE$.Http11();
    }

    public Status newResponse$default$2() {
        return Status$.MODULE$.Ok();
    }

    public Iterable<Tuple2<String, Object>> newResponse$default$3() {
        return (Iterable)Nil$.MODULE$;
    }

    public Future<Response> newOk(String msg, String contentType) {
        String x$1 = contentType;
        Buf x$2 = Buf.Utf8$.MODULE$.apply(msg);
        Version x$3 = this.newResponse$default$1();
        Status x$4 = this.newResponse$default$2();
        Iterable<Tuple2<String, Object>> x$5 = this.newResponse$default$3();
        return this.newResponse(x$3, x$4, x$5, x$1, x$2);
    }

    public String newOk$default$2() {
        return "text/plain;charset=UTF-8";
    }

    public Future<Response> new404(String msg, String contentType) {
        Status x$1 = Status$.MODULE$.NotFound();
        String x$2 = contentType;
        Buf x$3 = Buf.Utf8$.MODULE$.apply(msg);
        Version x$4 = this.newResponse$default$1();
        Iterable<Tuple2<String, Object>> x$5 = this.newResponse$default$3();
        return this.newResponse(x$4, x$1, x$5, x$2, x$3);
    }

    public String new404$default$2() {
        return "text/plain;charset=UTF-8";
    }

    public static final /* synthetic */ boolean $anonfun$newResponse$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private HttpUtils$() {
        MODULE$ = this;
    }
}

