/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.twitter.finagle.stats.MetricBuilder;
import com.twitter.finagle.stats.MetricBuilder$;
import com.twitter.finagle.stats.StatsFormatter;
import com.twitter.finagle.stats.StatsFormatter$;
import com.twitter.finagle.stats.metadataScopeSeparator$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class SchemaSerializer$
extends StdSerializer<MetricBuilder> {
    public static SchemaSerializer$ MODULE$;
    private final StatsFormatter statsFormatter;

    static {
        new SchemaSerializer$();
    }

    private void writeArray(JsonGenerator jsonGenerator, String name, Iterator<String> strings) {
        jsonGenerator.writeArrayFieldStart(name);
        strings.foreach((Function1 & Serializable & scala.Serializable)s -> {
            jsonGenerator.writeString(SchemaSerializer$.MODULE$.convertNullToString(s));
            return BoxedUnit.UNIT;
        });
        jsonGenerator.writeEndArray();
    }

    private void writeDictionary(JsonGenerator jsonGenerator, String name, Iterable<Tuple2<String, String>> entries) {
        jsonGenerator.writeObjectFieldStart(name);
        entries.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SchemaSerializer$.$anonfun$writeDictionary$1(jsonGenerator, x0$1);
            return BoxedUnit.UNIT;
        });
        jsonGenerator.writeEndObject();
    }

    public void serialize(MetricBuilder metricBuilder, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        String formattedName = metricBuilder.name().mkString(metadataScopeSeparator$.MODULE$.apply());
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("name", formattedName);
        jsonGenerator.writeStringField("dimensional_name", metricBuilder.identity().dimensionalName().mkString(MetricBuilder$.MODULE$.DimensionalNameScopeSeparator()));
        this.writeArray(jsonGenerator, "relative_name", (Iterator<String>)(metricBuilder.relativeName().nonEmpty() ? metricBuilder.relativeName() : metricBuilder.name()).iterator());
        this.writeDictionary(jsonGenerator, "labels", (Iterable<Tuple2<String, String>>)metricBuilder.identity().labels());
        jsonGenerator.writeBooleanField("dimensional_support", this.dimensionalSupport(metricBuilder.identity().identityType()));
        String dataType = metricBuilder.metricType().toJsonString();
        jsonGenerator.writeStringField("kind", dataType);
        jsonGenerator.writeObjectFieldStart("source");
        jsonGenerator.writeStringField("class", (String)metricBuilder.sourceClass().getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unspecified"));
        jsonGenerator.writeStringField("category", metricBuilder.role().toString());
        jsonGenerator.writeStringField("process_path", (String)metricBuilder.processPath().getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unspecified"));
        jsonGenerator.writeEndObject();
        jsonGenerator.writeStringField("description", metricBuilder.description());
        jsonGenerator.writeStringField("unit", metricBuilder.units().toString());
        jsonGenerator.writeStringField("verbosity", metricBuilder.verbosity().toString());
        jsonGenerator.writeBooleanField("key_indicator", metricBuilder.keyIndicator());
        MetricBuilder.MetricType metricType = metricBuilder.metricType();
        if (MetricBuilder.HistogramType$.MODULE$.equals(metricType)) {
            jsonGenerator.writeStringField("histogram_format", metricBuilder.histogramFormat().toString());
            jsonGenerator.writeObjectFieldStart("buckets");
            jsonGenerator.writeStringField("count", new StringBuilder(5).append(this.statsFormatter.histogramSeparator()).append("count").toString());
            jsonGenerator.writeStringField("sum", new StringBuilder(3).append(this.statsFormatter.histogramSeparator()).append("sum").toString());
            jsonGenerator.writeStringField("average", new StringBuilder(0).append(this.statsFormatter.histogramSeparator()).append(this.statsFormatter.labelAverage()).toString());
            jsonGenerator.writeStringField("minimum", new StringBuilder(0).append(this.statsFormatter.histogramSeparator()).append(this.statsFormatter.labelMin()).toString());
            jsonGenerator.writeStringField("maximum", new StringBuilder(0).append(this.statsFormatter.histogramSeparator()).append(this.statsFormatter.labelMax()).toString());
            metricBuilder.percentiles().foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)bucket -> jsonGenerator.writeStringField(((Object)BoxesRunTime.boxToDouble((double)bucket)).toString(), new StringBuilder(0).append(SchemaSerializer$.MODULE$.statsFormatter.histogramSeparator()).append(SchemaSerializer$.MODULE$.statsFormatter.labelPercentile(bucket)).toString()));
            jsonGenerator.writeEndObject();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        jsonGenerator.writeEndObject();
    }

    private boolean dimensionalSupport(MetricBuilder.IdentityType identityType) {
        MetricBuilder.IdentityType$.ResolvedIdentityType resolvedIdentityType = MetricBuilder.IdentityType$.MODULE$.toResolvedIdentityType(identityType);
        MetricBuilder.IdentityType$.Full$ full$ = MetricBuilder.IdentityType$.Full$.MODULE$;
        return !(resolvedIdentityType != null ? !resolvedIdentityType.equals(full$) : full$ != null);
    }

    private String convertNullToString(String segment) {
        return segment == null ? "null" : segment;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$writeDictionary$1(JsonGenerator jsonGenerator$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        jsonGenerator$2.writeStringField(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SchemaSerializer$() {
        super(MetricBuilder.class);
        MODULE$ = this;
        this.statsFormatter = StatsFormatter$.MODULE$.default();
    }
}

