/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.handler;

import com.twitter.finagle.Service;
import com.twitter.finagle.http.MediaType$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Uri;
import com.twitter.finagle.http.Uri$;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.stats.HistogramDetail;
import com.twitter.finagle.stats.WithHistogramDetails;
import com.twitter.io.Buf;
import com.twitter.server.handler.MetricTypeQueryHandler$;
import com.twitter.server.util.HttpUtils$;
import com.twitter.server.util.JsonConverter$;
import com.twitter.server.util.MetricSource;
import com.twitter.util.Future;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\b\u0010\u0001aA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!)A\b\u0001C\u0001{!1!\t\u0001Q\u0005\n\rCa!\u0016\u0001!\n\u00131\u0006B\u00028\u0001A\u0013%q\u000e\u0003\u0004r\u0001\u0001&IA\u001d\u0005\u0006o\u0002!\t\u0001_\u0004\n\u0003\u0003y\u0011\u0011!E\u0001\u0003\u00071\u0001BD\b\u0002\u0002#\u0005\u0011Q\u0001\u0005\u0007y)!\t!!\u0004\t\u0013\u0005=!\"%A\u0005\u0002\u0005E\u0001\"CA\u0014\u0015E\u0005I\u0011AA\u0015\u0005YiU\r\u001e:jGRK\b/Z)vKJL\b*\u00198eY\u0016\u0014(B\u0001\t\u0012\u0003\u001dA\u0017M\u001c3mKJT!AE\n\u0002\rM,'O^3s\u0015\t!R#A\u0004uo&$H/\u001a:\u000b\u0003Y\t1aY8n\u0007\u0001\u0019\"\u0001A\r\u0011\tiir$J\u0007\u00027)\u0011AdE\u0001\bM&t\u0017m\u001a7f\u0013\tq2DA\u0004TKJ4\u0018nY3\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tZ\u0012\u0001\u00025uiBL!\u0001J\u0011\u0003\u000fI+\u0017/^3tiB\u0011\u0001EJ\u0005\u0003O\u0005\u0012\u0001BU3ta>t7/Z\u0001\u0007g>,(oY3\u0011\u0005)jS\"A\u0016\u000b\u00051\n\u0012\u0001B;uS2L!AL\u0016\u0003\u00195+GO]5d'>,(oY3\u0002\u000f\u0011,G/Y5mgB\u0019\u0011\u0007\u000e\u001c\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012aa\u00149uS>t\u0007CA\u001c;\u001b\u0005A$BA\u001d\u001c\u0003\u0015\u0019H/\u0019;t\u0013\tY\u0004H\u0001\u000bXSRD\u0007*[:u_\u001e\u0014\u0018-\u001c#fi\u0006LGn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007y\u0002\u0015\t\u0005\u0002@\u00015\tq\u0002C\u0004)\u0007A\u0005\t\u0019A\u0015\t\u000f=\u001a\u0001\u0013!a\u0001a\u0005Q\u0001.[:u_\u001e\u0014\u0018-\\:\u0016\u0003\u0011\u0003B!\u0012'P%:\u0011aI\u0013\t\u0003\u000fJj\u0011\u0001\u0013\u0006\u0003\u0013^\ta\u0001\u0010:p_Rt\u0014BA&3\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0004\u001b\u0006\u0004(BA&3!\t)\u0005+\u0003\u0002R\u001d\n11\u000b\u001e:j]\u001e\u0004\"aN*\n\u0005QC$a\u0004%jgR|wM]1n\t\u0016$\u0018-\u001b7\u0002\u000bE,XM]=\u0015\u0005]#\u0007c\u0001-\\;6\t\u0011L\u0003\u0002[e\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005qK&\u0001C%uKJ\f'\r\\3\u0011\u0005y\u000bgB\u0001\u0016`\u0013\t\u00017&\u0001\u0007NKR\u0014\u0018nY*pkJ\u001cW-\u0003\u0002cG\nqQ*\u001a;sS\u000e$\u0016\u0010]3J]\u001a|'B\u00011,\u0011\u0015)W\u00011\u0001g\u0003\u0011YW-_:\u0011\u0007\u001ddwJ\u0004\u0002iU:\u0011q)[\u0005\u0002g%\u00111NM\u0001\ba\u0006\u001c7.Y4f\u0013\taVN\u0003\u0002le\u0005Iq-\u001a;ISN$xn\u001d\u000b\u0002aB\u0019q\r\\/\u0002\u0017E,XM]=ISN$xn\u001d\u000b\u0003aNDQ!Z\u0004A\u0002Q\u00042!R;P\u0013\t1hJA\u0002TKR\fQ!\u00199qYf$\"!\u001f@\u0011\u0007idX%D\u0001|\u0015\ta3#\u0003\u0002~w\n1a)\u001e;ve\u0016DQa \u0005A\u0002}\t1A]3r\u0003YiU\r\u001e:jGRK\b/Z)vKJL\b*\u00198eY\u0016\u0014\bCA \u000b'\rQ\u0011q\u0001\t\u0004c\u0005%\u0011bAA\u0006e\t1\u0011I\\=SK\u001a$\"!a\u0001\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019BK\u0002*\u0003+Y#!a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C\u0011\u0014AC1o]>$\u0018\r^5p]&!\u0011QEA\u000e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-\"f\u0001\u0019\u0002\u0016\u0001")
public class MetricTypeQueryHandler
extends Service<Request, Response> {
    private final MetricSource source;
    private final Option<WithHistogramDetails> details;

    public static Option<WithHistogramDetails> $lessinit$greater$default$2() {
        return MetricTypeQueryHandler$.MODULE$.$lessinit$greater$default$2();
    }

    public static MetricSource $lessinit$greater$default$1() {
        return MetricTypeQueryHandler$.MODULE$.$lessinit$greater$default$1();
    }

    private Map<String, HistogramDetail> histograms() {
        Map map;
        Option<WithHistogramDetails> option = this.details;
        if (option instanceof Some) {
            Some some = (Some)option;
            WithHistogramDetails histos = (WithHistogramDetails)some.value();
            map = histos.histogramDetails();
        } else if (None$.MODULE$.equals(option)) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            throw new MatchError(option);
        }
        return map;
    }

    private Iterable<MetricSource.MetricTypeInfo> query(Iterable<String> keys) {
        return (Iterable)keys.flatMap((Function1 & Serializable)k -> $this.source.getType((String)k).map((Function1 & Serializable)e -> e));
    }

    private Iterable<MetricSource.MetricTypeInfo> getHistos() {
        return (Iterable)this.histograms().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            MetricSource.MetricTypeInfo metricTypeInfo = new MetricSource.MetricTypeInfo(name, "histogram");
            return metricTypeInfo;
        });
    }

    private Iterable<MetricSource.MetricTypeInfo> queryHistos(Set<String> keys) {
        return (Iterable)this.histograms().filterKeys((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)keys.contains((Object)elem))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            MetricSource.MetricTypeInfo metricTypeInfo = new MetricSource.MetricTypeInfo(name, "histogram");
            return metricTypeInfo;
        });
    }

    public Future<Response> apply(Request req) {
        Uri uri = Uri$.MODULE$.fromRequest(req);
        boolean latched = this.source.hasLatchedCounters();
        Iterable keysParam = uri.params().getAll("m");
        Iterable metrics = keysParam.isEmpty() ? (Iterable)this.source.typeMap().$plus$plus(this.getHistos()) : (Iterable)this.query((Iterable<String>)keysParam).$plus$plus(this.queryHistos((Set<String>)keysParam.toSet()));
        String x$1 = MediaType$.MODULE$.JsonUtf8();
        Buf x$2 = Buf.Utf8$.MODULE$.apply(JsonConverter$.MODULE$.writeToString(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latched"), (Object)BoxesRunTime.boxToBoolean((boolean)latched)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics"), (Object)metrics)}))));
        Version x$3 = HttpUtils$.MODULE$.newResponse$default$1();
        Status x$4 = HttpUtils$.MODULE$.newResponse$default$2();
        Iterable<Tuple2<String, Object>> x$5 = HttpUtils$.MODULE$.newResponse$default$3();
        return HttpUtils$.MODULE$.newResponse(x$3, x$4, x$5, x$1, x$2);
    }

    public MetricTypeQueryHandler(MetricSource source, Option<WithHistogramDetails> details) {
        this.source = source;
        this.details = details;
    }
}

