/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.lint;

import com.twitter.finagle.stats.DelegatingStatsReceiver$;
import com.twitter.finagle.stats.LoadedStatsReceiver$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.lint.Category;
import com.twitter.util.lint.Issue;
import com.twitter.util.lint.Rule;
import com.twitter.util.lint.Rule$;
import java.io.Serializable;
import scala.Function0;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.runtime.ScalaRunTime$;

public final class NumberOfStatsReceiversRule$ {
    public static final NumberOfStatsReceiversRule$ MODULE$ = new NumberOfStatsReceiversRule$();

    public Rule apply() {
        return this.apply((Seq<StatsReceiver>)DelegatingStatsReceiver$.MODULE$.all((StatsReceiver)LoadedStatsReceiver$.MODULE$));
    }

    public Rule apply(Seq<StatsReceiver> statsReceivers) {
        return Rule$.MODULE$.apply((Category)Category.Performance$.MODULE$, "Number of StatsReceivers", "More than one StatsReceiver loaded causes a larger than necessary memory footprint and slower runtime usage. Examine your (transitive) dependencies and remove unwanted StatsReceivers either via dependency management or the com.twitter.finagle.util.loadServiceIgnoredPaths flag. Alternatively, having none loaded indicates that the service will not have any telemetry reported which is dangerous way to operate a service.", (Function0 & Serializable)() -> statsReceivers.size() == 1 ? Nil$.MODULE$ : (statsReceivers.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Issue[]{new Issue("No StatsReceivers registered")})) : (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Issue[]{new Issue(new StringBuilder(36).append("Multiple StatsReceivers registered: ").append(statsReceivers.mkString(", ")).toString())}))));
    }

    private NumberOfStatsReceiversRule$() {
    }
}

