/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.handler;

import com.twitter.finagle.stats.MetricBuilder;
import com.twitter.finagle.stats.StatsFormatter;
import com.twitter.finagle.stats.StatsFormatter$;
import com.twitter.finagle.stats.exp.ConstantExpression;
import com.twitter.finagle.stats.exp.Expression;
import com.twitter.finagle.stats.exp.FunctionExpression;
import com.twitter.finagle.stats.exp.HistogramExpression;
import com.twitter.finagle.stats.exp.MetricExpression;
import com.twitter.finagle.stats.exp.NoExpression$;
import com.twitter.finagle.stats.exp.StringExpression;
import com.twitter.finagle.stats.metadataScopeSeparator$;
import com.twitter.server.util.MetricSchemaSource;
import com.twitter.server.util.MetricSchemaSource$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;

public final class MetricExpressionHandler$ {
    public static final MetricExpressionHandler$ MODULE$ = new MetricExpressionHandler$();
    private static final double com$twitter$server$handler$MetricExpressionHandler$$Version = 1.1;
    private static final StatsFormatter statsFormatter = StatsFormatter$.MODULE$.default();
    private static final String Wildcard = "/*";

    public MetricSchemaSource $lessinit$greater$default$1() {
        return new MetricSchemaSource(MetricSchemaSource$.MODULE$.$lessinit$greater$default$1(), MetricSchemaSource$.MODULE$.$lessinit$greater$default$2());
    }

    public double com$twitter$server$handler$MetricExpressionHandler$$Version() {
        return com$twitter$server$handler$MetricExpressionHandler$$Version;
    }

    private StatsFormatter statsFormatter() {
        return statsFormatter;
    }

    private String Wildcard() {
        return Wildcard;
    }

    public String translateToQuery(Expression expr2, boolean shouldRate, boolean sourceLatched, Map<String, String> labels) {
        String string;
        Expression expression = expr2;
        if (expression instanceof HistogramExpression) {
            HistogramExpression histogramExpression = (HistogramExpression)expression;
            MetricBuilder schema = histogramExpression.metricBuilder();
            string = this.getHisto(schema, labels);
        } else if (expression instanceof MetricExpression) {
            MetricExpression metricExpression = (MetricExpression)expression;
            MetricBuilder schema = metricExpression.metricBuilder();
            boolean showRollup = metricExpression.showRollup();
            string = this.getMetric(schema, showRollup, shouldRate, sourceLatched);
        } else if (expression instanceof ConstantExpression) {
            String repr;
            ConstantExpression constantExpression = (ConstantExpression)expression;
            string = repr = constantExpression.repr();
        } else if (expression instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression;
            String funcName = functionExpression.fnName();
            Seq exprs = functionExpression.exprs();
            string = new StringBuilder(2).append(funcName).append("(").append(((IterableOnceOps)exprs.map((Function1 & Serializable)expr -> MODULE$.translateToQuery((Expression)expr, shouldRate, sourceLatched, labels))).mkString(",")).append(")").toString();
        } else if (expression instanceof StringExpression) {
            StringExpression stringExpression = (StringExpression)expression;
            Seq expr3 = stringExpression.exprs();
            boolean isCounter = stringExpression.isCounter();
            String metric = expr3.mkString(metadataScopeSeparator$.MODULE$.apply());
            string = isCounter && shouldRate && !sourceLatched ? new StringBuilder(6).append("rate(").append(metric).append(")").toString() : metric;
        } else if (NoExpression$.MODULE$.equals(expression)) {
            string = "null";
        } else {
            throw new MatchError((Object)expression);
        }
        return string;
    }

    private String getHisto(MetricBuilder metricBuilder, Map<String, String> labels) {
        String name = metricBuilder.name().mkString(metadataScopeSeparator$.MODULE$.apply());
        return this.statsFormatter().histoName(name, (String)labels.apply((Object)"bucket"));
    }

    private String getMetric(MetricBuilder metricBuilder, boolean showRollUp, boolean shouldRate, boolean sourceLatched) {
        String metric = new StringBuilder(0).append(metricBuilder.name().mkString(metadataScopeSeparator$.MODULE$.apply())).append((Object)(showRollUp ? this.Wildcard() : "")).toString();
        MetricBuilder.MetricType metricType = metricBuilder.metricType();
        String string = MetricBuilder.CounterType$.MODULE$.equals(metricType) && shouldRate && !sourceLatched ? new StringBuilder(6).append("rate(").append(metric).append(")").toString() : (MetricBuilder.CounterishGaugeType$.MODULE$.equals(metricType) && shouldRate ? new StringBuilder(6).append("rate(").append(metric).append(")").toString() : metric);
        return string;
    }

    private MetricExpressionHandler$() {
    }
}

