/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.handler;

import com.twitter.finagle.Service;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.jvm.ContentionSnapshot;
import com.twitter.server.util.HttpUtils$;
import com.twitter.util.Future;
import com.twitter.util.logging.Logger;
import com.twitter.util.logging.Logging;
import java.io.Serializable;
import java.lang.management.ManagementPermission;
import org.slf4j.Marker;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005}2A\u0001B\u0003\u0001\u001d!)a\u0005\u0001C\u0001O!1!\u0006\u0001Q\u0001\n-BQa\u000e\u0001\u0005\u0002a\u0012\u0011cQ8oi\u0016tG/[8o\u0011\u0006tG\r\\3s\u0015\t1q!A\u0004iC:$G.\u001a:\u000b\u0005!I\u0011AB:feZ,'O\u0003\u0002\u000b\u0017\u00059Ao^5ui\u0016\u0014(\"\u0001\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001ya\u0004\u0005\u0003\u0011'UYR\"A\t\u000b\u0005II\u0011a\u00024j]\u0006<G.Z\u0005\u0003)E\u0011qaU3sm&\u001cW\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019#\u0005!\u0001\u000e\u001e;q\u0013\tQrCA\u0004SKF,Xm\u001d;\u0011\u0005Ya\u0012BA\u000f\u0018\u0005!\u0011Vm\u001d9p]N,\u0007CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u001dawnZ4j]\u001eT!aI\u0005\u0002\tU$\u0018\u000e\\\u0005\u0003K\u0001\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u0002\u000b\u0005\u00112m\u001c8uK:$\u0018n\u001c8T]\u0006\u00048\u000f[8u!\ras&M\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1q\n\u001d;j_:\u0004\"AM\u001b\u000e\u0003MR!\u0001N\u0005\u0002\u0007)4X.\u0003\u00027g\t\u00112i\u001c8uK:$\u0018n\u001c8T]\u0006\u00048\u000f[8u\u0003\u0015\t\u0007\u000f\u001d7z)\tIT\bE\u0002;wmi\u0011AI\u0005\u0003y\t\u0012aAR;ukJ,\u0007\"\u0002 \u0004\u0001\u0004)\u0012a\u0001:fc\u0002")
public class ContentionHandler
extends Service<Request, Response>
implements Logging {
    private final Option<ContentionSnapshot> contentionSnapshot;
    private Logger com$twitter$util$logging$Logging$$_logger;
    private volatile boolean bitmap$0;

    public final Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public final String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public boolean isTraceEnabled(Marker marker) {
        return Logging.isTraceEnabled$((Logging)this, (Marker)marker);
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void trace(Marker marker, Function0<Object> message) {
        Logging.trace$((Logging)this, (Marker)marker, message);
    }

    public void trace(Function0<Object> message, Throwable cause) {
        Logging.trace$((Logging)this, message, (Throwable)cause);
    }

    public void trace(Marker marker, Function0<Object> message, Throwable cause) {
        Logging.trace$((Logging)this, (Marker)marker, message, (Throwable)cause);
    }

    public <T> T traceResult(Function0<String> message, Function0<T> fn) {
        return (T)Logging.traceResult$((Logging)this, message, fn);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isDebugEnabled(Marker marker) {
        return Logging.isDebugEnabled$((Logging)this, (Marker)marker);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Marker marker, Function0<Object> message) {
        Logging.debug$((Logging)this, (Marker)marker, message);
    }

    public void debug(Function0<Object> message, Throwable cause) {
        Logging.debug$((Logging)this, message, (Throwable)cause);
    }

    public void debug(Marker marker, Function0<Object> message, Throwable cause) {
        Logging.debug$((Logging)this, (Marker)marker, message, (Throwable)cause);
    }

    public <T> T debugResult(Function0<String> message, Function0<T> fn) {
        return (T)Logging.debugResult$((Logging)this, message, fn);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public boolean isInfoEnabled(Marker marker) {
        return Logging.isInfoEnabled$((Logging)this, (Marker)marker);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Marker marker, Function0<Object> message) {
        Logging.info$((Logging)this, (Marker)marker, message);
    }

    public void info(Function0<Object> message, Throwable cause) {
        Logging.info$((Logging)this, message, (Throwable)cause);
    }

    public void info(Marker marker, Function0<Object> message, Throwable cause) {
        Logging.info$((Logging)this, (Marker)marker, message, (Throwable)cause);
    }

    public <T> T infoResult(Function0<String> message, Function0<T> fn) {
        return (T)Logging.infoResult$((Logging)this, message, fn);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public boolean isWarnEnabled(Marker marker) {
        return Logging.isWarnEnabled$((Logging)this, (Marker)marker);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Marker marker, Function0<Object> message) {
        Logging.warn$((Logging)this, (Marker)marker, message);
    }

    public void warn(Function0<Object> message, Throwable cause) {
        Logging.warn$((Logging)this, message, (Throwable)cause);
    }

    public void warn(Marker marker, Function0<Object> message, Throwable cause) {
        Logging.warn$((Logging)this, (Marker)marker, message, (Throwable)cause);
    }

    public <T> T warnResult(Function0<String> message, Function0<T> fn) {
        return (T)Logging.warnResult$((Logging)this, message, fn);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public boolean isErrorEnabled(Marker marker) {
        return Logging.isErrorEnabled$((Logging)this, (Marker)marker);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void error(Marker marker, Function0<Object> message) {
        Logging.error$((Logging)this, (Marker)marker, message);
    }

    public void error(Function0<Object> message, Throwable cause) {
        Logging.error$((Logging)this, message, (Throwable)cause);
    }

    public void error(Marker marker, Function0<Object> message, Throwable cause) {
        Logging.error$((Logging)this, (Marker)marker, message, (Throwable)cause);
    }

    public <T> T errorResult(Function0<String> message, Function0<T> fn) {
        return (T)Logging.errorResult$((Logging)this, message, fn);
    }

    private Logger com$twitter$util$logging$Logging$$_logger$lzycompute() {
        ContentionHandler contentionHandler = this;
        synchronized (contentionHandler) {
            if (!this.bitmap$0) {
                this.com$twitter$util$logging$Logging$$_logger = Logging.com$twitter$util$logging$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.com$twitter$util$logging$Logging$$_logger;
    }

    public final Logger com$twitter$util$logging$Logging$$_logger() {
        return !this.bitmap$0 ? this.com$twitter$util$logging$Logging$$_logger$lzycompute() : this.com$twitter$util$logging$Logging$$_logger;
    }

    public Future<Response> apply(Request req) {
        Future<Response> future;
        Option<ContentionSnapshot> option = this.contentionSnapshot;
        if (option instanceof Some) {
            Some some = (Some)option;
            ContentionSnapshot snapshot = (ContentionSnapshot)some.value();
            ContentionSnapshot.Snapshot snap = snapshot.snap();
            String deadlockMsg = snap.deadlocks().isEmpty() ? "" : StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("DEADLOCKS:\n\n%s\n\n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{snap.deadlocks().mkString("\n\n")}));
            String msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%sBlocked:\n%s\n\nLock Owners:\n%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{deadlockMsg, snap.blockedThreads().mkString("\n"), snap.lockOwners().mkString("\n")}));
            future = HttpUtils$.MODULE$.newOk(msg, HttpUtils$.MODULE$.newOk$default$2());
        } else {
            String msg = "Contention snapshotting is not enabled due to SecurityManager restrictions.\nPlease ensure that the java.lang.management.ManagementPermission(\"control\") is allowed.";
            future = HttpUtils$.MODULE$.newOk(msg, HttpUtils$.MODULE$.newOk$default$2());
        }
        return future;
    }

    private final /* synthetic */ Option liftedTree1$1(SecurityManager securityManager$1, ManagementPermission permission$1) {
        Some some;
        try {
            securityManager$1.checkPermission(permission$1);
            some = new Some((Object)new ContentionSnapshot());
        }
        catch (SecurityException e) {
            this.warn((Function0<Object>)(Function0 & Serializable)() -> "Contention snapshotting is not allowed by SecurityManager.", e);
            some = None$.MODULE$;
        }
        return some;
    }

    public ContentionHandler() {
        Some some;
        Logging.$init$((Logging)this);
        ManagementPermission permission = new ManagementPermission("control");
        Option option = Option$.MODULE$.apply((Object)System.getSecurityManager());
        if (option instanceof Some) {
            Some some2 = (Some)option;
            SecurityManager securityManager = (SecurityManager)some2.value();
            some = this.liftedTree1$1(securityManager, permission);
        } else {
            some = new Some((Object)new ContentionSnapshot());
        }
        this.contentionSnapshot = some;
    }
}

