/*
 * Decompiled with CFR 0.152.
 */
package com.twitter;

import com.twitter.Extractor;
import com.twitter.Regex;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Autolink {
    public static final String DEFAULT_LIST_CLASS = "tweet-url list-slug";
    public static final String DEFAULT_USERNAME_CLASS = "tweet-url username";
    public static final String DEFAULT_HASHTAG_CLASS = "tweet-url hashtag";
    public static final String DEFAULT_CASHTAG_CLASS = "tweet-url cashtag";
    public static final String DEFAULT_USERNAME_URL_BASE = "https://twitter.com/";
    public static final String DEFAULT_LIST_URL_BASE = "https://twitter.com/";
    public static final String DEFAULT_HASHTAG_URL_BASE = "https://twitter.com/#!/search?q=%23";
    public static final String DEFAULT_CASHTAG_URL_BASE = "https://twitter.com/#!/search?q=%24";
    public static final String DEFAULT_INVISIBLE_TAG_ATTRS = "style='position:absolute;left:-9999px;'";
    protected String urlClass = null;
    protected String listClass = "tweet-url list-slug";
    protected String usernameClass = "tweet-url username";
    protected String hashtagClass = "tweet-url hashtag";
    protected String cashtagClass = "tweet-url cashtag";
    protected String usernameUrlBase = "https://twitter.com/";
    protected String listUrlBase = "https://twitter.com/";
    protected String hashtagUrlBase = "https://twitter.com/#!/search?q=%23";
    protected String cashtagUrlBase = "https://twitter.com/#!/search?q=%24";
    protected String invisibleTagAttrs = "style='position:absolute;left:-9999px;'";
    protected boolean noFollow = true;
    protected boolean usernameIncludeSymbol = false;
    protected String symbolTag = null;
    protected String textWithSymbolTag = null;
    protected String urlTarget = null;
    protected LinkAttributeModifier linkAttributeModifier = null;
    protected LinkTextModifier linkTextModifier = null;
    private Extractor extractor = new Extractor();

    private static CharSequence escapeHTML(CharSequence text) {
        StringBuilder builder = new StringBuilder(text.length() * 2);
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    builder.append("&amp;");
                    continue block7;
                }
                case '>': {
                    builder.append("&gt;");
                    continue block7;
                }
                case '<': {
                    builder.append("&lt;");
                    continue block7;
                }
                case '\"': {
                    builder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    builder.append("&#39;");
                    continue block7;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder;
    }

    public Autolink() {
        this.extractor.setExtractURLWithoutProtocol(false);
    }

    public String escapeBrackets(String text) {
        int len = text.length();
        if (len == 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(len + 16);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void linkToText(Extractor.Entity entity, CharSequence text, Map<String, String> attributes, StringBuilder builder) {
        if (this.noFollow) {
            attributes.put("rel", "nofollow");
        }
        if (this.linkAttributeModifier != null) {
            this.linkAttributeModifier.modify(entity, attributes);
        }
        if (this.linkTextModifier != null) {
            text = this.linkTextModifier.modify(entity, text);
        }
        builder.append("<a");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            builder.append(" ").append(Autolink.escapeHTML(entry.getKey())).append("=\"").append(Autolink.escapeHTML(entry.getValue())).append("\"");
        }
        builder.append(">").append(text).append("</a>");
    }

    public void linkToTextWithSymbol(Extractor.Entity entity, CharSequence symbol, CharSequence text, Map<String, String> attributes, StringBuilder builder) {
        boolean includeSymbol;
        CharSequence taggedSymbol = this.symbolTag == null || this.symbolTag.isEmpty() ? symbol : String.format("<%s>%s</%s>", this.symbolTag, symbol, this.symbolTag);
        text = Autolink.escapeHTML(text);
        CharSequence taggedText = this.textWithSymbolTag == null || this.textWithSymbolTag.isEmpty() ? text : String.format("<%s>%s</%s>", this.textWithSymbolTag, text, this.textWithSymbolTag);
        boolean bl = includeSymbol = this.usernameIncludeSymbol || !Regex.AT_SIGNS.matcher(symbol).matches();
        if (includeSymbol) {
            this.linkToText(entity, taggedSymbol.toString() + taggedText, attributes, builder);
        } else {
            builder.append(taggedSymbol);
            this.linkToText(entity, taggedText, attributes, builder);
        }
    }

    public void linkToHashtag(Extractor.Entity entity, String text, StringBuilder builder) {
        CharSequence hashChar = text.subSequence(entity.getStart(), entity.getStart() + 1);
        String hashtag = entity.getValue();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("href", this.hashtagUrlBase + hashtag);
        attrs.put("title", "#" + hashtag);
        if (Regex.RTL_CHARACTERS.matcher(text).find()) {
            attrs.put("class", this.hashtagClass + " rtl");
        } else {
            attrs.put("class", this.hashtagClass);
        }
        this.linkToTextWithSymbol(entity, hashChar, hashtag, attrs, builder);
    }

    public void linkToCashtag(Extractor.Entity entity, String text, StringBuilder builder) {
        String cashtag = entity.getValue();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("href", this.cashtagUrlBase + cashtag);
        attrs.put("title", "$" + cashtag);
        attrs.put("class", this.cashtagClass);
        this.linkToTextWithSymbol(entity, "$", cashtag, attrs, builder);
    }

    public void linkToMentionAndList(Extractor.Entity entity, String text, StringBuilder builder) {
        String mention = entity.getValue();
        CharSequence atChar = text.subSequence(entity.getStart(), entity.getStart() + 1);
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        if (entity.listSlug != null) {
            mention = mention + entity.listSlug;
            attrs.put("class", this.listClass);
            attrs.put("href", this.listUrlBase + mention);
        } else {
            attrs.put("class", this.usernameClass);
            attrs.put("href", this.usernameUrlBase + mention);
        }
        this.linkToTextWithSymbol(entity, atChar, mention, attrs, builder);
    }

    public void linkToURL(Extractor.Entity entity, String text, StringBuilder builder) {
        String url = entity.getValue();
        CharSequence linkText = Autolink.escapeHTML(url);
        if (entity.displayURL != null && entity.expandedURL != null) {
            String displayURLSansEllipses = entity.displayURL.replace("\u2026", "");
            int diplayURLIndexInExpandedURL = entity.expandedURL.indexOf(displayURLSansEllipses);
            if (diplayURLIndexInExpandedURL != -1) {
                String beforeDisplayURL = entity.expandedURL.substring(0, diplayURLIndexInExpandedURL);
                String afterDisplayURL = entity.expandedURL.substring(diplayURLIndexInExpandedURL + displayURLSansEllipses.length());
                String precedingEllipsis = entity.displayURL.startsWith("\u2026") ? "\u2026" : "";
                String followingEllipsis = entity.displayURL.endsWith("\u2026") ? "\u2026" : "";
                String invisibleSpan = "<span " + this.invisibleTagAttrs + ">";
                StringBuilder sb = new StringBuilder("<span class='tco-ellipsis'>");
                sb.append(precedingEllipsis);
                sb.append(invisibleSpan).append("&nbsp;</span></span>");
                sb.append(invisibleSpan).append(Autolink.escapeHTML(beforeDisplayURL)).append("</span>");
                sb.append("<span class='js-display-url'>").append(Autolink.escapeHTML(displayURLSansEllipses)).append("</span>");
                sb.append(invisibleSpan).append(Autolink.escapeHTML(afterDisplayURL)).append("</span>");
                sb.append("<span class='tco-ellipsis'>").append(invisibleSpan).append("&nbsp;</span>").append(followingEllipsis).append("</span>");
                linkText = sb;
            } else {
                linkText = entity.displayURL;
            }
        }
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("href", url.toString());
        if (this.urlClass != null) {
            attrs.put("class", this.urlClass);
        }
        if (this.urlClass != null && !this.urlClass.isEmpty()) {
            attrs.put("class", this.urlClass);
        }
        if (this.urlTarget != null && !this.urlTarget.isEmpty()) {
            attrs.put("target", this.urlTarget);
        }
        this.linkToText(entity, linkText, attrs, builder);
    }

    public String autoLinkEntities(String text, List<Extractor.Entity> entities) {
        StringBuilder builder = new StringBuilder(text.length() * 2);
        int beginIndex = 0;
        for (Extractor.Entity entity : entities) {
            builder.append(text.subSequence(beginIndex, entity.start));
            switch (entity.type) {
                case URL: {
                    this.linkToURL(entity, text, builder);
                    break;
                }
                case HASHTAG: {
                    this.linkToHashtag(entity, text, builder);
                    break;
                }
                case MENTION: {
                    this.linkToMentionAndList(entity, text, builder);
                    break;
                }
                case CASHTAG: {
                    this.linkToCashtag(entity, text, builder);
                }
            }
            beginIndex = entity.end;
        }
        builder.append(text.subSequence(beginIndex, text.length()));
        return builder.toString();
    }

    public String autoLink(String text) {
        text = this.escapeBrackets(text);
        List<Extractor.Entity> entities = this.extractor.extractEntitiesWithIndices(text);
        return this.autoLinkEntities(text, entities);
    }

    public String autoLinkUsernamesAndLists(String text) {
        return this.autoLinkEntities(text, this.extractor.extractMentionsOrListsWithIndices(text));
    }

    public String autoLinkHashtags(String text) {
        return this.autoLinkEntities(text, this.extractor.extractHashtagsWithIndices(text));
    }

    public String autoLinkURLs(String text) {
        return this.autoLinkEntities(text, this.extractor.extractURLsWithIndices(text));
    }

    public String autoLinkCashtags(String text) {
        return this.autoLinkEntities(text, this.extractor.extractCashtagsWithIndices(text));
    }

    public String getUrlClass() {
        return this.urlClass;
    }

    public void setUrlClass(String urlClass) {
        this.urlClass = urlClass;
    }

    public String getListClass() {
        return this.listClass;
    }

    public void setListClass(String listClass) {
        this.listClass = listClass;
    }

    public String getUsernameClass() {
        return this.usernameClass;
    }

    public void setUsernameClass(String usernameClass) {
        this.usernameClass = usernameClass;
    }

    public String getHashtagClass() {
        return this.hashtagClass;
    }

    public void setHashtagClass(String hashtagClass) {
        this.hashtagClass = hashtagClass;
    }

    public String getCashtagClass() {
        return this.cashtagClass;
    }

    public void setCashtagClass(String cashtagClass) {
        this.cashtagClass = cashtagClass;
    }

    public String getUsernameUrlBase() {
        return this.usernameUrlBase;
    }

    public void setUsernameUrlBase(String usernameUrlBase) {
        this.usernameUrlBase = usernameUrlBase;
    }

    public String getListUrlBase() {
        return this.listUrlBase;
    }

    public void setListUrlBase(String listUrlBase) {
        this.listUrlBase = listUrlBase;
    }

    public String getHashtagUrlBase() {
        return this.hashtagUrlBase;
    }

    public void setHashtagUrlBase(String hashtagUrlBase) {
        this.hashtagUrlBase = hashtagUrlBase;
    }

    public String getCashtagUrlBase() {
        return this.cashtagUrlBase;
    }

    public void setCashtagUrlBase(String cashtagUrlBase) {
        this.cashtagUrlBase = cashtagUrlBase;
    }

    public boolean isNoFollow() {
        return this.noFollow;
    }

    public void setNoFollow(boolean noFollow) {
        this.noFollow = noFollow;
    }

    public void setUsernameIncludeSymbol(boolean usernameIncludeSymbol) {
        this.usernameIncludeSymbol = usernameIncludeSymbol;
    }

    public void setSymbolTag(String tag) {
        this.symbolTag = tag;
    }

    public void setTextWithSymbolTag(String tag) {
        this.textWithSymbolTag = tag;
    }

    public void setUrlTarget(String target) {
        this.urlTarget = target;
    }

    public void setLinkAttributeModifier(LinkAttributeModifier modifier) {
        this.linkAttributeModifier = modifier;
    }

    public void setLinkTextModifier(LinkTextModifier modifier) {
        this.linkTextModifier = modifier;
    }

    public static interface LinkTextModifier {
        public CharSequence modify(Extractor.Entity var1, CharSequence var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LinkAttributeModifier {
        public void modify(Extractor.Entity var1, Map<String, String> var2);
    }
}

