/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.twittertext;

import java.text.StringCharacterIterator;
import java.util.List;

public class HitHighlighter {
    public static final String DEFAULT_HIGHLIGHT_TAG = "em";
    protected String highlightTag = "em";

    public String highlight(String text, List<List<Integer>> hits) {
        if (hits == null || hits.isEmpty()) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length());
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        boolean isCounting = true;
        boolean tagOpened = false;
        int currentIndex = 0;
        char currentChar = iterator.first();
        while (currentChar != '\uffff') {
            for (List<Integer> startEnd : hits) {
                if (startEnd.get(0) == currentIndex) {
                    sb.append(this.tag(false));
                    tagOpened = true;
                    continue;
                }
                if (startEnd.get(1) != currentIndex) continue;
                sb.append(this.tag(true));
                tagOpened = false;
            }
            if (currentChar == '<') {
                isCounting = false;
            } else if (currentChar == '>' && !isCounting) {
                isCounting = true;
            }
            if (isCounting) {
                ++currentIndex;
            }
            sb.append(currentChar);
            currentChar = iterator.next();
        }
        if (tagOpened) {
            sb.append(this.tag(true));
        }
        return sb.toString();
    }

    protected String tag(boolean closeTag) {
        StringBuilder sb = new StringBuilder(this.highlightTag.length() + 3);
        sb.append("<");
        if (closeTag) {
            sb.append("/");
        }
        sb.append(this.highlightTag).append(">");
        return sb.toString();
    }

    public String getHighlightTag() {
        return this.highlightTag;
    }

    public void setHighlightTag(String highlightTag) {
        this.highlightTag = highlightTag;
    }
}

