/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.twittertext;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.twitter.twittertext.Range;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TwitterTextConfiguration {
    private static final int DEFAULT_VERSION = 2;
    private static final int DEFAULT_WEIGHTED_LENGTH = 280;
    private static final int DEFAULT_SCALE = 100;
    private static final int DEFAULT_WEIGHT = 200;
    private static final int DEFAULT_TRANSFORMED_URL_LENGTH = 23;
    private static final List<TwitterTextWeightedRange> DEFAULT_RANGES = new ArrayList<TwitterTextWeightedRange>();
    private int version;
    private int maxWeightedTweetLength;
    private int scale;
    private int defaultWeight;
    private int transformedURLLength;
    @Nonnull
    private List<TwitterTextWeightedRange> ranges;

    @Nonnull
    public static TwitterTextConfiguration configurationFromJson(@Nonnull String json, boolean isResource) {
        TwitterTextConfiguration config;
        block6: {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                if (isResource) {
                    InputStream resourceStream = TwitterTextConfiguration.class.getResourceAsStream("/" + json);
                    if (resourceStream == null) {
                        resourceStream = TwitterTextConfiguration.class.getClassLoader().getResourceAsStream(json);
                    }
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream));
                        config = (TwitterTextConfiguration)objectMapper.readValue((Reader)reader, TwitterTextConfiguration.class);
                        break block6;
                    }
                    catch (NullPointerException ex) {
                        return TwitterTextConfiguration.getDefaultConfig();
                    }
                }
                config = (TwitterTextConfiguration)objectMapper.readValue(json, TwitterTextConfiguration.class);
            }
            catch (IOException ex) {
                config = TwitterTextConfiguration.getDefaultConfig();
            }
        }
        return config;
    }

    private static TwitterTextConfiguration getDefaultConfig() {
        return new TwitterTextConfiguration().setVersion(2).setMaxWeightedTweetLength(280).setScale(100).setDefaultWeight(200).setRanges(DEFAULT_RANGES).setTransformedURLLength(23);
    }

    private TwitterTextConfiguration setVersion(int version) {
        this.version = version;
        return this;
    }

    private TwitterTextConfiguration setMaxWeightedTweetLength(int maxWeightedTweetLength) {
        this.maxWeightedTweetLength = maxWeightedTweetLength;
        return this;
    }

    private TwitterTextConfiguration setScale(int scale) {
        this.scale = scale;
        return this;
    }

    private TwitterTextConfiguration setDefaultWeight(int defaultWeight) {
        this.defaultWeight = defaultWeight;
        return this;
    }

    private TwitterTextConfiguration setTransformedURLLength(int urlLength) {
        this.transformedURLLength = urlLength;
        return this;
    }

    private TwitterTextConfiguration setRanges(@Nonnull List<TwitterTextWeightedRange> ranges) {
        this.ranges = ranges;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMaxWeightedTweetLength() {
        return this.maxWeightedTweetLength;
    }

    public int getScale() {
        return this.scale;
    }

    public int getDefaultWeight() {
        return this.defaultWeight;
    }

    public int getTransformedURLLength() {
        return this.transformedURLLength;
    }

    @Nonnull
    public List<TwitterTextWeightedRange> getRanges() {
        return this.ranges;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.version;
        result = result * 31 + this.maxWeightedTweetLength;
        result = result * 31 + this.scale;
        result = result * 31 + this.defaultWeight;
        result = result * 31 + this.transformedURLLength;
        result = result * 31 + this.ranges.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterTextConfiguration that = (TwitterTextConfiguration)o;
        return this.version == that.version && this.maxWeightedTweetLength == that.maxWeightedTweetLength && this.scale == that.scale && this.defaultWeight == that.defaultWeight && this.transformedURLLength == that.transformedURLLength && this.ranges.equals(that.ranges);
    }

    static {
        DEFAULT_RANGES.add(new TwitterTextWeightedRange().setStart(0).setEnd(4351).setWeight(100));
        DEFAULT_RANGES.add(new TwitterTextWeightedRange().setStart(8192).setEnd(8205).setWeight(100));
        DEFAULT_RANGES.add(new TwitterTextWeightedRange().setStart(8208).setEnd(8223).setWeight(100));
        DEFAULT_RANGES.add(new TwitterTextWeightedRange().setStart(8242).setEnd(8247).setWeight(100));
    }

    public static class TwitterTextWeightedRange {
        private int start;
        private int end;
        private int weight;

        private TwitterTextWeightedRange setStart(int start) {
            this.start = start;
            return this;
        }

        private TwitterTextWeightedRange setEnd(int end) {
            this.end = end;
            return this;
        }

        private TwitterTextWeightedRange setWeight(int weight) {
            this.weight = weight;
            return this;
        }

        @Nonnull
        public Range getRange() {
            return new Range(this.start, this.end);
        }

        public int getWeight() {
            return this.weight;
        }

        public int hashCode() {
            return 31 * this.start + 31 * this.end + 31 * this.weight;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TwitterTextWeightedRange that = (TwitterTextWeightedRange)o;
            return this.start == that.start && this.end == that.end && this.weight == that.weight;
        }
    }
}

