/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.twittertext;

import com.twitter.twittertext.Extractor;
import com.twitter.twittertext.Range;
import com.twitter.twittertext.TwitterTextConfiguration;
import com.twitter.twittertext.TwitterTextParseResults;
import com.twitter.twittertext.Validator;
import java.text.Normalizer;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TwitterTextParser {
    public static final TwitterTextParseResults EMPTY_TWITTER_TEXT_PARSE_RESULTS = new TwitterTextParseResults(0, 0, false, Range.EMPTY, Range.EMPTY);
    public static final TwitterTextConfiguration TWITTER_TEXT_DEFAULT_CONFIG = TwitterTextConfiguration.configurationFromJson("v1.json", true);
    public static final TwitterTextConfiguration TWITTER_TEXT_WEIGHTED_CHAR_COUNT_CONFIG = TwitterTextConfiguration.configurationFromJson("v2.json", true);
    private static final Extractor EXTRACTOR = new Extractor();

    private TwitterTextParser() {
    }

    @Nonnull
    public static TwitterTextParseResults parseTweet(@Nullable String tweet) {
        return TwitterTextParser.parseTweet(tweet, TWITTER_TEXT_WEIGHTED_CHAR_COUNT_CONFIG);
    }

    @Nonnull
    public static TwitterTextParseResults parseTweet(@Nullable String tweet, @Nonnull TwitterTextConfiguration config) {
        return TwitterTextParser.parseTweet(tweet, config, true);
    }

    @Nonnull
    public static TwitterTextParseResults parseTweetWithoutUrlExtraction(@Nullable String tweet) {
        return TwitterTextParser.parseTweet(tweet, TWITTER_TEXT_WEIGHTED_CHAR_COUNT_CONFIG, false);
    }

    @Nonnull
    private static TwitterTextParseResults parseTweet(@Nullable String tweet, @Nonnull TwitterTextConfiguration config, boolean extractURLs) {
        if (tweet == null || tweet.trim().length() == 0) {
            return EMPTY_TWITTER_TEXT_PARSE_RESULTS;
        }
        String normalizedTweet = Normalizer.normalize(tweet, Normalizer.Form.NFC);
        int tweetLength = normalizedTweet.length();
        if (tweetLength == 0) {
            return EMPTY_TWITTER_TEXT_PARSE_RESULTS;
        }
        int scale = config.getScale();
        int maxWeightedTweetLength = config.getMaxWeightedTweetLength();
        int scaledMaxWeightedTweetLength = maxWeightedTweetLength * scale;
        int transformedUrlWeight = config.getTransformedURLLength() * scale;
        List<TwitterTextConfiguration.TwitterTextWeightedRange> ranges = config.getRanges();
        List<Extractor.Entity> urlEntities = EXTRACTOR.extractURLsWithIndices(normalizedTweet);
        boolean hasInvalidCharacters = false;
        int weightedCount = 0;
        int offset = 0;
        int validOffset = 0;
        while (offset < tweetLength) {
            int charWeight = config.getDefaultWeight();
            if (extractURLs) {
                ListIterator<Extractor.Entity> urlEntityIterator = urlEntities.listIterator();
                while (urlEntityIterator.hasNext()) {
                    Extractor.Entity urlEntity = urlEntityIterator.next();
                    if (urlEntity.start != offset) continue;
                    int urlLength = urlEntity.end - urlEntity.start;
                    offset += urlLength;
                    if ((weightedCount += transformedUrlWeight) <= scaledMaxWeightedTweetLength) {
                        validOffset += urlLength;
                    }
                    urlEntityIterator.remove();
                    break;
                }
            }
            if (offset >= tweetLength) continue;
            int codePoint = normalizedTweet.codePointAt(offset);
            for (TwitterTextConfiguration.TwitterTextWeightedRange weightedRange : ranges) {
                if (!weightedRange.getRange().isInRange(codePoint)) continue;
                charWeight = weightedRange.getWeight();
                break;
            }
            hasInvalidCharacters = hasInvalidCharacters || Validator.hasInvalidCharacters(normalizedTweet.substring(offset, offset + 1));
            int charCount = Character.charCount(codePoint);
            offset += charCount;
            if (hasInvalidCharacters || (weightedCount += charWeight) > scaledMaxWeightedTweetLength) continue;
            validOffset += charCount;
        }
        int normalizedTweetOffset = tweet.length() - normalizedTweet.length();
        int scaledWeightedLength = weightedCount / scale;
        boolean isValid = !hasInvalidCharacters && scaledWeightedLength <= maxWeightedTweetLength;
        int permillage = scaledWeightedLength * 1000 / maxWeightedTweetLength;
        return new TwitterTextParseResults(scaledWeightedLength, permillage, isValid, new Range(0, offset + normalizedTweetOffset - 1), new Range(0, validOffset + normalizedTweetOffset - 1));
    }
}

