/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.twittertext;

import com.twitter.twittertext.Range;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TwitterTextConfiguration {
    private static final int DEFAULT_VERSION = 3;
    private static final int DEFAULT_WEIGHTED_LENGTH = 280;
    private static final int DEFAULT_SCALE = 100;
    private static final int DEFAULT_WEIGHT = 200;
    private static final boolean DEFAULT_EMOJI_PARSING_ENABLED = true;
    private static final int DEFAULT_TRANSFORMED_URL_LENGTH = 23;
    private static final List<TwitterTextWeightedRange> DEFAULT_RANGES = new ArrayList<TwitterTextWeightedRange>();
    private final int version;
    private final int maxWeightedTweetLength;
    private final int scale;
    private final int defaultWeight;
    private final boolean emojiParsingEnabled;
    private final int transformedURLLength;
    @Nonnull
    private final List<TwitterTextWeightedRange> ranges;

    public static TwitterTextConfiguration getDefaultConfig() {
        return new Builder().setVersion(3).setMaxWeightedTweetLength(280).setScale(100).setDefaultWeight(200).setEmojiParsingEnabled(true).setRanges(DEFAULT_RANGES).setTransformedURLLength(23).build();
    }

    private TwitterTextConfiguration(@Nonnull Builder builder) {
        this.version = builder.version;
        this.maxWeightedTweetLength = builder.maxWeightedTweetLength;
        this.scale = builder.scale;
        this.defaultWeight = builder.defaultWeight;
        this.emojiParsingEnabled = builder.emojiParsingEnabled;
        this.transformedURLLength = builder.transformedURLLength;
        this.ranges = builder.ranges;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMaxWeightedTweetLength() {
        return this.maxWeightedTweetLength;
    }

    public int getScale() {
        return this.scale;
    }

    public int getDefaultWeight() {
        return this.defaultWeight;
    }

    public boolean getEmojiParsingEnabled() {
        return this.emojiParsingEnabled;
    }

    public int getTransformedURLLength() {
        return this.transformedURLLength;
    }

    @Nonnull
    public List<TwitterTextWeightedRange> getRanges() {
        return this.ranges;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.version;
        result = result * 31 + this.maxWeightedTweetLength;
        result = result * 31 + this.scale;
        result = result * 31 + this.defaultWeight;
        result = result * 31 + (this.emojiParsingEnabled ? 1 : 0);
        result = result * 31 + this.transformedURLLength;
        result = result * 31 + this.ranges.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterTextConfiguration that = (TwitterTextConfiguration)o;
        return this.version == that.version && this.maxWeightedTweetLength == that.maxWeightedTweetLength && this.scale == that.scale && this.defaultWeight == that.defaultWeight && this.emojiParsingEnabled == that.emojiParsingEnabled && this.transformedURLLength == that.transformedURLLength && this.ranges.equals(that.ranges);
    }

    static {
        DEFAULT_RANGES.add(new TwitterTextWeightedRange().setStart(0).setEnd(4351).setWeight(100));
        DEFAULT_RANGES.add(new TwitterTextWeightedRange().setStart(8192).setEnd(8205).setWeight(100));
        DEFAULT_RANGES.add(new TwitterTextWeightedRange().setStart(8208).setEnd(8223).setWeight(100));
        DEFAULT_RANGES.add(new TwitterTextWeightedRange().setStart(8242).setEnd(8247).setWeight(100));
    }

    public static class TwitterTextWeightedRange {
        private int start;
        private int end;
        private int weight;

        private TwitterTextWeightedRange setStart(int start) {
            this.start = start;
            return this;
        }

        private TwitterTextWeightedRange setEnd(int end) {
            this.end = end;
            return this;
        }

        private TwitterTextWeightedRange setWeight(int weight) {
            this.weight = weight;
            return this;
        }

        @Nonnull
        public Range getRange() {
            return new Range(this.start, this.end);
        }

        public int getWeight() {
            return this.weight;
        }

        public int hashCode() {
            return 31 * this.start + 31 * this.end + 31 * this.weight;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TwitterTextWeightedRange that = (TwitterTextWeightedRange)o;
            return this.start == that.start && this.end == that.end && this.weight == that.weight;
        }
    }

    public static final class Builder {
        private int version;
        private int maxWeightedTweetLength;
        private int scale;
        private int defaultWeight;
        private boolean emojiParsingEnabled;
        private int transformedURLLength;
        @Nonnull
        private List<TwitterTextWeightedRange> ranges = new ArrayList<TwitterTextWeightedRange>();

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder setMaxWeightedTweetLength(int maxWeightedTweetLength) {
            this.maxWeightedTweetLength = maxWeightedTweetLength;
            return this;
        }

        public Builder setScale(int scale) {
            this.scale = scale;
            return this;
        }

        public Builder setDefaultWeight(int defaultWeight) {
            this.defaultWeight = defaultWeight;
            return this;
        }

        public Builder setEmojiParsingEnabled(boolean emojiParsingEnabled) {
            this.emojiParsingEnabled = emojiParsingEnabled;
            return this;
        }

        public Builder setTransformedURLLength(int urlLength) {
            this.transformedURLLength = urlLength;
            return this;
        }

        public Builder setRanges(@Nonnull List<TwitterTextWeightedRange> ranges) {
            this.ranges = ranges;
            return this;
        }

        public TwitterTextConfiguration build() {
            return new TwitterTextConfiguration(this);
        }
    }
}

