/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectMapperCopier$;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.twitter.util.jackson.ScalaObjectMapper;
import com.twitter.util.jackson.ScalaObjectMapper$Builder$;
import com.twitter.util.jackson.serde.DefaultSerdeModule$;
import com.twitter.util.jackson.serde.LongKeyDeserializers$;
import com.twitter.util.validation.ScalaValidator;
import com.twitter.util.validation.ScalaValidator$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class ScalaObjectMapper$ {
    public static ScalaObjectMapper$ MODULE$;
    private final ScalaValidator DefaultValidator;
    private final boolean DefaultNumbersAsStrings;
    private final Seq<Module> DefaultJacksonModules;
    private final PropertyNamingStrategy DefaultPropertyNamingStrategy;
    private final JsonInclude.Include DefaultSerializationInclude;
    private final Map<SerializationFeature, Object> DefaultSerializationConfig;
    private final Map<DeserializationFeature, Object> DefaultDeserializationConfig;
    private final Seq<Module> DefaultAdditionalJacksonModules;
    private final boolean DefaultValidation;

    static {
        new ScalaObjectMapper$();
    }

    public ScalaValidator DefaultValidator() {
        return this.DefaultValidator;
    }

    public boolean DefaultNumbersAsStrings() {
        return this.DefaultNumbersAsStrings;
    }

    public Seq<Module> DefaultJacksonModules() {
        return this.DefaultJacksonModules;
    }

    public PropertyNamingStrategy DefaultPropertyNamingStrategy() {
        return this.DefaultPropertyNamingStrategy;
    }

    public JsonInclude.Include DefaultSerializationInclude() {
        return this.DefaultSerializationInclude;
    }

    public Map<SerializationFeature, Object> DefaultSerializationConfig() {
        return this.DefaultSerializationConfig;
    }

    public Map<DeserializationFeature, Object> DefaultDeserializationConfig() {
        return this.DefaultDeserializationConfig;
    }

    public Seq<Module> DefaultAdditionalJacksonModules() {
        return this.DefaultAdditionalJacksonModules;
    }

    public boolean DefaultValidation() {
        return this.DefaultValidation;
    }

    public ScalaObjectMapper apply() {
        return this.builder().objectMapper();
    }

    public ScalaObjectMapper apply(ObjectMapper underlying) {
        return new ScalaObjectMapper(this.builder().configureJacksonScalaObjectMapper(underlying));
    }

    public ScalaObjectMapper objectMapper(ObjectMapper underlying) {
        ObjectMapper objectMapperCopy = ObjectMapperCopier$.MODULE$.copy(underlying);
        return new ScalaObjectMapper(objectMapperCopy);
    }

    public ScalaObjectMapper yamlObjectMapper(ObjectMapper underlying) {
        JsonFactory jsonFactory = underlying.getFactory();
        if (!(jsonFactory instanceof YAMLFactory)) {
            throw new IllegalArgumentException("The underlying mapper is not properly configured with a YAMLFactory");
        }
        ObjectMapper objectMapperCopy = ObjectMapperCopier$.MODULE$.copy(underlying);
        ScalaObjectMapper scalaObjectMapper = new ScalaObjectMapper(objectMapperCopy);
        return scalaObjectMapper;
    }

    public ScalaObjectMapper camelCaseObjectMapper(ObjectMapper underlying) {
        ObjectMapper objectMapperCopy = ObjectMapperCopier$.MODULE$.copy(underlying);
        objectMapperCopy.setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE);
        return new ScalaObjectMapper(objectMapperCopy);
    }

    public ScalaObjectMapper snakeCaseObjectMapper(ObjectMapper underlying) {
        ObjectMapper objectMapperCopy = ObjectMapperCopier$.MODULE$.copy(underlying);
        objectMapperCopy.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        return new ScalaObjectMapper(objectMapperCopy);
    }

    public ScalaObjectMapper.Builder builder() {
        return ScalaObjectMapper$Builder$.MODULE$.apply(ScalaObjectMapper$Builder$.MODULE$.apply$default$1(), ScalaObjectMapper$Builder$.MODULE$.apply$default$2(), ScalaObjectMapper$Builder$.MODULE$.apply$default$3(), ScalaObjectMapper$Builder$.MODULE$.apply$default$4(), ScalaObjectMapper$Builder$.MODULE$.apply$default$5(), ScalaObjectMapper$Builder$.MODULE$.apply$default$6(), ScalaObjectMapper$Builder$.MODULE$.apply$default$7(), ScalaObjectMapper$Builder$.MODULE$.apply$default$8(), ScalaObjectMapper$Builder$.MODULE$.apply$default$9(), ScalaObjectMapper$Builder$.MODULE$.apply$default$10());
    }

    private ScalaObjectMapper$() {
        MODULE$ = this;
        this.DefaultValidator = ScalaValidator$.MODULE$.apply();
        this.DefaultNumbersAsStrings = false;
        this.DefaultJacksonModules = (Seq)new .colon.colon((Object)DefaultScalaModule$.MODULE$, (List)new .colon.colon((Object)new JavaTimeModule(), (List)new .colon.colon((Object)LongKeyDeserializers$.MODULE$, (List)new .colon.colon((Object)DefaultSerdeModule$.MODULE$, (List)Nil$.MODULE$))));
        this.DefaultPropertyNamingStrategy = PropertyNamingStrategies.SNAKE_CASE;
        this.DefaultSerializationInclude = JsonInclude.Include.NON_ABSENT;
        this.DefaultSerializationConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SerializationFeature.WRITE_DATES_AS_TIMESTAMPS), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SerializationFeature.WRITE_ENUMS_USING_TO_STRING), (Object)BoxesRunTime.boxToBoolean((boolean)true))}));
        this.DefaultDeserializationConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeserializationFeature.READ_ENUMS_USING_TO_STRING), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY), (Object)BoxesRunTime.boxToBoolean((boolean)true))}));
        this.DefaultAdditionalJacksonModules = (Seq)Nil$.MODULE$;
        this.DefaultValidation = true;
    }
}

