/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.jackson.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.TimeFormat;
import com.twitter.util.jackson.serde.TimeStringDeserializer$;
import java.io.Serializable;
import java.util.Locale;
import java.util.TimeZone;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015s!\u0002\b\u0010\u0011\u0003Qb!\u0002\u000f\u0010\u0011\u0003i\u0002\"B\u0014\u0002\t\u0003A\u0003BB\u0015\u0002A\u0003%!\u0006C\u00036\u0003\u0011\u0005a\u0007\u0003\u00046\u0003\u0011\u0005\u0011\u0011\u0002\u0005\u0007k\u0005!\t!a\u0004\t\u0013\u0005U\u0012!!A\u0005\n\u0005]b\u0001\u0002\u000f\u0010\u0001aB\u0001B\u0014\u0005\u0003\u0002\u0003\u0006Ia\u0014\u0005\u0006O!!\tA\u0015\u0005\u0006)\"!\t%\u0016\u0005\u0007I\"\u0001K\u0011B3\t\u000b5DA\u0011\t8\u0002-QKW.Z*ue&tw\rR3tKJL\u0017\r\\5{KJT!\u0001E\t\u0002\u000bM,'\u000fZ3\u000b\u0005I\u0019\u0012a\u00026bG.\u001cxN\u001c\u0006\u0003)U\tA!\u001e;jY*\u0011acF\u0001\bi^LG\u000f^3s\u0015\u0005A\u0012aA2p[\u000e\u0001\u0001CA\u000e\u0002\u001b\u0005y!A\u0006+j[\u0016\u001cFO]5oO\u0012+7/\u001a:jC2L'0\u001a:\u0014\u0007\u0005qB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0015J!A\n\u0011\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005Q\u0012!\u0005#fM\u0006,H\u000e\u001e+j[\u00164uN]7biB\u00111F\r\b\u0003YA\u0002\"!\f\u0011\u000e\u00039R!aL\r\u0002\rq\u0012xn\u001c;?\u0013\t\t\u0004%\u0001\u0004Qe\u0016$WMZ\u0005\u0003gQ\u0012aa\u0015;sS:<'BA\u0019!\u0003\u0015\t\u0007\u000f\u001d7z)\u00059\u0004CA\u000e\t'\rA\u0011H\u0013\t\u0004u\u00113U\"A\u001e\u000b\u0005qj\u0014aA:uI*\u0011ahP\u0001\u0006I\u0016\u001cXM\u001d\u0006\u0003\u0001\u0006\u000b\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003%\tS!aQ\f\u0002\u0013\u0019\f7\u000f^3sq6d\u0017BA#<\u0005U\u0019F\u000fZ*dC2\f'\u000fR3tKJL\u0017\r\\5{KJ\u0004\"a\u0012%\u000e\u0003MI!!S\n\u0003\tQKW.\u001a\t\u0003\u00172k\u0011!P\u0005\u0003\u001bv\u0012acQ8oi\u0016DH/^1m\t\u0016\u001cXM]5bY&TXM]\u0001\u000bi&lWMR8s[\u0006$\bCA$Q\u0013\t\t6C\u0001\u0006US6,gi\u001c:nCR$\"aN*\t\u000b9S\u0001\u0019A(\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004\rZs\u0006\"B,\f\u0001\u0004A\u0016A\u00016q!\tIF,D\u0001[\u0015\tY\u0016)\u0001\u0003d_J,\u0017BA/[\u0005)Q5o\u001c8QCJ\u001cXM\u001d\u0005\u0006?.\u0001\r\u0001Y\u0001\u0005GRDH\u000f\u0005\u0002bE6\tq(\u0003\u0002d\u007f\t1B)Z:fe&\fG.\u001b>bi&|gnQ8oi\u0016DH/A\u0006iC:$G.\u001a+pW\u0016tG\u0003\u0002$gW2DQa\u001a\u0007A\u0002!\fQ\u0001^8lK:\u0004\"!W5\n\u0005)T&!\u0003&t_:$vn[3o\u0011\u00159F\u00021\u0001Y\u0011\u0015yF\u00021\u0001a\u0003A\u0019'/Z1uK\u000e{g\u000e^3yiV\fG\u000eF\u0002p}~\u0004$\u0001];\u0011\u0007\u0005\f8/\u0003\u0002s\u007f\t\u0001\"j]8o\t\u0016\u001cXM]5bY&TXM\u001d\t\u0003iVd\u0001\u0001B\u0005w\u001b\u0005\u0005\t\u0011!B\u0001o\n\u0019q\fJ\u0019\u0012\u0005a\\\bCA\u0010z\u0013\tQ\bEA\u0004O_RD\u0017N\\4\u0011\u0005}a\u0018BA?!\u0005\r\te.\u001f\u0005\u0006?6\u0001\r\u0001\u0019\u0005\b\u0003\u0003i\u0001\u0019AA\u0002\u0003!\u0001(o\u001c9feRL\bcA1\u0002\u0006%\u0019\u0011qA \u0003\u0019\t+\u0017M\u001c)s_B,'\u000f^=\u0015\u0007]\nY\u0001\u0003\u0004\u0002\u000e\u0015\u0001\rAK\u0001\ba\u0006$H/\u001a:o)\u001d9\u0014\u0011CA\n\u0003WAa!!\u0004\u0007\u0001\u0004Q\u0003bBA\u000b\r\u0001\u0007\u0011qC\u0001\u0007Y>\u001c\u0017\r\\3\u0011\u000b}\tI\"!\b\n\u0007\u0005m\u0001E\u0001\u0004PaRLwN\u001c\t\u0005\u0003?\t9#\u0004\u0002\u0002\")\u0019A#a\t\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006LA!!\u000b\u0002\"\t1Aj\\2bY\u0016Dq!!\f\u0007\u0001\u0004\ty#\u0001\u0005uS6,'p\u001c8f!\u0011\ty\"!\r\n\t\u0005M\u0012\u0011\u0005\u0002\t)&lWMW8oK\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\u0004\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\u0011\ty$a\t\u0002\t1\fgnZ\u0005\u0005\u0003\u0007\niD\u0001\u0004PE*,7\r\u001e")
public class TimeStringDeserializer
extends StdScalarDeserializer<Time>
implements ContextualDeserializer {
    private final TimeFormat timeFormat;

    public static TimeStringDeserializer apply(String string, Option<Locale> option, TimeZone timeZone) {
        return TimeStringDeserializer$.MODULE$.apply(string, option, timeZone);
    }

    public static TimeStringDeserializer apply(String string) {
        return TimeStringDeserializer$.MODULE$.apply(string);
    }

    public static TimeStringDeserializer apply() {
        return TimeStringDeserializer$.MODULE$.apply();
    }

    public Time deserialize(JsonParser jp, DeserializationContext ctxt) {
        JsonToken jsonToken = jp.currentToken();
        boolean bl = JsonToken.NOT_AVAILABLE.equals(jsonToken) ? true : JsonToken.START_OBJECT.equals(jsonToken);
        Time time = bl ? this.handleToken(jp.nextToken(), jp, ctxt) : this.handleToken(jp.currentToken(), jp, ctxt);
        return time;
    }

    private Time handleToken(JsonToken token, JsonParser jp, DeserializationContext ctxt) {
        Time time;
        try {
            String value = jp.getText().trim();
            if (value.isEmpty()) {
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)"field cannot be empty");
            }
            time = this.timeFormat.parse(value);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)new StringBuilder(24).append("error parsing '").append(jp.getText()).append("' into a ").append(Time$.MODULE$.getClass().getName()).toString(), (Throwable)e);
            }
            throw throwable;
        }
        return time;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        Option deserializerOption = Option$.MODULE$.apply((Object)this.findFormatOverrides(ctxt, property, this.handledType())).flatMap((Function1 & Serializable & scala.Serializable)jsonFormat -> Option$.MODULE$.apply((Object)TimeStringDeserializer$.MODULE$.apply(jsonFormat.getPattern(), (Option<Locale>)Option$.MODULE$.apply((Object)jsonFormat.getLocale()), (TimeZone)Option$.MODULE$.apply((Object)jsonFormat.getTimeZone()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TimeZone.getTimeZone("UTC")))).withFilter((Function1 & Serializable & scala.Serializable)deserializer -> BoxesRunTime.boxToBoolean((boolean)jsonFormat.hasPattern())).map((Function1 & Serializable & scala.Serializable)deserializer -> deserializer));
        return (JsonDeserializer)deserializerOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> this);
    }

    public TimeStringDeserializer(TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
        super(Time.class);
    }
}

