/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectMapperCopier$;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.TextNode;
import com.twitter.util.jackson.JsonDiff;
import com.twitter.util.jackson.ScalaObjectMapper;
import com.twitter.util.jackson.ScalaObjectMapper$;
import com.twitter.util.logging.Logger;
import com.twitter.util.logging.Logging;
import java.io.PrintStream;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JsonDiff$
implements Logging {
    public static JsonDiff$ MODULE$;
    private ScalaObjectMapper mapper;
    private ObjectMapper sortingObjectMapper;
    private Logger com$twitter$util$logging$Logging$$_logger;
    private volatile byte bitmap$0;

    static {
        new JsonDiff$();
    }

    public final Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public final String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public boolean isTraceEnabled(Marker marker) {
        return Logging.isTraceEnabled$((Logging)this, (Marker)marker);
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void trace(Marker marker, Function0<Object> message) {
        Logging.trace$((Logging)this, (Marker)marker, message);
    }

    public void trace(Function0<Object> message, Throwable cause) {
        Logging.trace$((Logging)this, message, (Throwable)cause);
    }

    public void trace(Marker marker, Function0<Object> message, Throwable cause) {
        Logging.trace$((Logging)this, (Marker)marker, message, (Throwable)cause);
    }

    public <T> T traceResult(Function0<String> message, Function0<T> fn) {
        return (T)Logging.traceResult$((Logging)this, message, fn);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isDebugEnabled(Marker marker) {
        return Logging.isDebugEnabled$((Logging)this, (Marker)marker);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Marker marker, Function0<Object> message) {
        Logging.debug$((Logging)this, (Marker)marker, message);
    }

    public void debug(Function0<Object> message, Throwable cause) {
        Logging.debug$((Logging)this, message, (Throwable)cause);
    }

    public void debug(Marker marker, Function0<Object> message, Throwable cause) {
        Logging.debug$((Logging)this, (Marker)marker, message, (Throwable)cause);
    }

    public <T> T debugResult(Function0<String> message, Function0<T> fn) {
        return (T)Logging.debugResult$((Logging)this, message, fn);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public boolean isInfoEnabled(Marker marker) {
        return Logging.isInfoEnabled$((Logging)this, (Marker)marker);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Marker marker, Function0<Object> message) {
        Logging.info$((Logging)this, (Marker)marker, message);
    }

    public void info(Function0<Object> message, Throwable cause) {
        Logging.info$((Logging)this, message, (Throwable)cause);
    }

    public void info(Marker marker, Function0<Object> message, Throwable cause) {
        Logging.info$((Logging)this, (Marker)marker, message, (Throwable)cause);
    }

    public <T> T infoResult(Function0<String> message, Function0<T> fn) {
        return (T)Logging.infoResult$((Logging)this, message, fn);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public boolean isWarnEnabled(Marker marker) {
        return Logging.isWarnEnabled$((Logging)this, (Marker)marker);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Marker marker, Function0<Object> message) {
        Logging.warn$((Logging)this, (Marker)marker, message);
    }

    public void warn(Function0<Object> message, Throwable cause) {
        Logging.warn$((Logging)this, message, (Throwable)cause);
    }

    public void warn(Marker marker, Function0<Object> message, Throwable cause) {
        Logging.warn$((Logging)this, (Marker)marker, message, (Throwable)cause);
    }

    public <T> T warnResult(Function0<String> message, Function0<T> fn) {
        return (T)Logging.warnResult$((Logging)this, message, fn);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public boolean isErrorEnabled(Marker marker) {
        return Logging.isErrorEnabled$((Logging)this, (Marker)marker);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void error(Marker marker, Function0<Object> message) {
        Logging.error$((Logging)this, (Marker)marker, message);
    }

    public void error(Function0<Object> message, Throwable cause) {
        Logging.error$((Logging)this, message, (Throwable)cause);
    }

    public void error(Marker marker, Function0<Object> message, Throwable cause) {
        Logging.error$((Logging)this, (Marker)marker, message, (Throwable)cause);
    }

    public <T> T errorResult(Function0<String> message, Function0<T> fn) {
        return (T)Logging.errorResult$((Logging)this, message, fn);
    }

    private Logger com$twitter$util$logging$Logging$$_logger$lzycompute() {
        JsonDiff$ jsonDiff$ = this;
        synchronized (jsonDiff$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.com$twitter$util$logging$Logging$$_logger = Logging.com$twitter$util$logging$Logging$$_logger$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.com$twitter$util$logging$Logging$$_logger;
    }

    public final Logger com$twitter$util$logging$Logging$$_logger() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.com$twitter$util$logging$Logging$$_logger$lzycompute() : this.com$twitter$util$logging$Logging$$_logger;
    }

    private ScalaObjectMapper mapper$lzycompute() {
        JsonDiff$ jsonDiff$ = this;
        synchronized (jsonDiff$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.mapper = ScalaObjectMapper$.MODULE$.builder().objectMapper();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.mapper;
    }

    private ScalaObjectMapper mapper() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.mapper$lzycompute() : this.mapper;
    }

    /*
     * WARNING - void declaration
     */
    private ObjectMapper sortingObjectMapper$lzycompute() {
        JsonDiff$ jsonDiff$ = this;
        synchronized (jsonDiff$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                ObjectMapper newMapper = ObjectMapperCopier$.MODULE$.copy(this.mapper().underlying());
                newMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
                newMapper.setDefaultPropertyInclusion(JsonInclude.Include.ALWAYS);
                this.sortingObjectMapper = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sortingObjectMapper;
    }

    private ObjectMapper sortingObjectMapper() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sortingObjectMapper$lzycompute() : this.sortingObjectMapper;
    }

    public String toSortedString(JsonNode jsonNode) {
        String string;
        if (jsonNode.isTextual()) {
            string = jsonNode.textValue();
        } else {
            Object node = this.sortingObjectMapper().treeToValue((TreeNode)jsonNode, Object.class);
            string = this.sortingObjectMapper().writeValueAsString(node);
        }
        return string;
    }

    public <T> Option<JsonDiff.Result> diff(T expected, T actual) {
        return this.diff(expected, actual, (Option<Function1<JsonNode, JsonNode>>)None$.MODULE$);
    }

    public <T> Option<JsonDiff.Result> diff(T expected, T actual, Function1<JsonNode, JsonNode> normalizeFn) {
        return this.diff(expected, actual, (Option<Function1<JsonNode, JsonNode>>)Option$.MODULE$.apply(normalizeFn));
    }

    public <T> void assertDiff(T expected, T actual) throws AssertionError {
        this.assert(expected, actual, (Option<Function1<JsonNode, JsonNode>>)None$.MODULE$, System.out);
    }

    public <T> void assertDiff(T expected, T actual, Function1<JsonNode, JsonNode> normalizeFn) throws AssertionError {
        this.assert(expected, actual, (Option<Function1<JsonNode, JsonNode>>)Option$.MODULE$.apply(normalizeFn), System.out);
    }

    public <T> void assertDiff(T expected, T actual, PrintStream p) throws AssertionError {
        this.assert(expected, actual, (Option<Function1<JsonNode, JsonNode>>)None$.MODULE$, p);
    }

    public <T> void assertDiff(T expected, T actual, Function1<JsonNode, JsonNode> normalizeFn, PrintStream p) throws AssertionError {
        this.assert(expected, actual, (Option<Function1<JsonNode, JsonNode>>)Option$.MODULE$.apply(normalizeFn), p);
    }

    private <T> Option<JsonDiff.Result> diff(T expected, T actual, Option<Function1<JsonNode, JsonNode>> normalizer) {
        None$ none$;
        JsonNode jsonNode;
        String actualJson = this.jsonString(actual);
        String expectedJson = this.jsonString(expected);
        JsonNode jsonNode2 = this.tryJsonNodeParse(actualJson);
        Option<Function1<JsonNode, JsonNode>> option = normalizer;
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 normalizerFn = (Function1)some.value();
            jsonNode = (JsonNode)normalizerFn.apply((Object)jsonNode2);
        } else {
            jsonNode = jsonNode2;
        }
        JsonNode actualJsonNode = jsonNode;
        JsonNode expectedJsonNode = this.tryJsonNodeParse(expectedJson);
        JsonNode jsonNode3 = actualJsonNode;
        JsonNode jsonNode4 = expectedJsonNode;
        if (jsonNode3 == null ? jsonNode4 != null : !jsonNode3.equals(jsonNode4)) {
            JsonDiff.Result result = new JsonDiff.Result(expectedJsonNode, this.mapper().writePrettyString(expectedJsonNode), actualJsonNode, this.mapper().writePrettyString(actualJsonNode));
            none$ = new Some((Object)result);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private <T> void assert(T expected, T actual, Option<Function1<JsonNode, JsonNode>> normalizer, PrintStream p) {
        Option<JsonDiff.Result> option = this.diff(expected, actual, normalizer);
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonDiff.Result result = (JsonDiff.Result)some.value();
            p.println("JSON DIFF FAILED!");
            p.println(result);
            throw new AssertionError((Object)new StringBuilder(9).append(this.getClass().getName()).append(" failure\n").append(result).toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private JsonNode tryJsonNodeParse(String expectedJsonStr) {
        JsonNode jsonNode;
        try {
            jsonNode = (JsonNode)this.mapper().parse(expectedJsonStr, ManifestFactory$.MODULE$.classType(JsonNode.class));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            TextNode textNode = new TextNode(expectedJsonStr);
            jsonNode = textNode;
        }
        return jsonNode;
    }

    private String jsonString(Object receivedJson) {
        String string;
        Object object = receivedJson;
        String string2 = object instanceof String ? (string = (String)object) : this.mapper().writeValueAsString(receivedJson);
        return string2;
    }

    private JsonDiff$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

