/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.jackson.caseclass;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.twitter.util.jackson.caseclass.CaseClassField;
import com.twitter.util.jackson.caseclass.exceptions.CaseClassFieldMappingException;
import com.twitter.util.jackson.caseclass.exceptions.CaseClassFieldMappingException$PropertyPath$;
import com.twitter.util.jackson.caseclass.exceptions.CaseClassFieldMappingException$ValidationError$Field$;
import com.twitter.util.jackson.caseclass.exceptions.CaseClassFieldMappingException$ValidationError$Method$;
import com.twitter.util.validation.ScalaValidator;
import com.twitter.util.validation.conversions.ConstraintViolationOps;
import com.twitter.util.validation.conversions.ConstraintViolationOps$;
import com.twitter.util.validation.conversions.PathOps;
import com.twitter.util.validation.conversions.PathOps$;
import com.twitter.util.validation.metadata.ExecutableDescriptor;
import com.twitter.util.validation.metadata.MethodDescriptor;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.Payload;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.util.control.NonFatal$;

public final class CaseClassDeserializer$ {
    public static final CaseClassDeserializer$ MODULE$ = new CaseClassDeserializer$();
    private static final JsonParser EmptyJsonParser = new JsonFactory().createParser("");

    public JsonParser EmptyJsonParser() {
        return EmptyJsonParser;
    }

    private String applyPropertyNamingStrategy(DeserializationConfig config, String fieldName) {
        return config.getPropertyNamingStrategy().nameForField((MapperConfig)config, null, fieldName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<CaseClassFieldMappingException> executeFieldValidations(Option<ScalaValidator> validatorOption, Option<ExecutableDescriptor> executableDescriptorOption, DeserializationConfig config, Object[] constructorValues, CaseClassField[] fields) {
        Seq seq;
        Tuple2 tuple2 = new Tuple2(validatorOption, executableDescriptorOption);
        if (tuple2 == null) return (Seq)package$.MODULE$.Seq().empty();
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (!(option instanceof Some)) return (Seq)package$.MODULE$.Seq().empty();
        Some some = (Some)option;
        ScalaValidator validator = (ScalaValidator)some.value();
        if (!(option2 instanceof Some)) return (Seq)package$.MODULE$.Seq().empty();
        Some some2 = (Some)option2;
        ExecutableDescriptor executableDescriptor = (ExecutableDescriptor)some2.value();
        Set violations = validator.forExecutables().validateExecutableParameters(executableDescriptor, constructorValues, (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$1 -> x$1.name(), ClassTag$.MODULE$.apply(String.class)), (Seq)Nil$.MODULE$);
        if (violations.nonEmpty()) {
            ListBuffer results = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            for (ConstraintViolation violation : violations) {
                results.append((Object)new CaseClassFieldMappingException(CaseClassFieldMappingException$PropertyPath$.MODULE$.leaf(this.applyPropertyNamingStrategy(config, PathOps.RichPath$.MODULE$.getLeafNode$extension(PathOps$.MODULE$.RichPath(violation.getPropertyPath())).toString())), new CaseClassFieldMappingException.Reason(violation.getMessage(), new CaseClassFieldMappingException.ValidationError(violation, CaseClassFieldMappingException$ValidationError$Field$.MODULE$, (Option<Payload>)ConstraintViolationOps.RichConstraintViolation$.MODULE$.getDynamicPayload$extension(ConstraintViolationOps$.MODULE$.RichConstraintViolation(violation), Payload.class)))));
            }
            seq = results.toSeq();
            return seq;
        } else {
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return seq;
    }

    private CaseClassFieldMappingException.PropertyPath getMethodValidationViolationPropertyPath(DeserializationConfig config, ConstraintViolation<?> violation) {
        CaseClassFieldMappingException.PropertyPath propertyPath;
        Path propertyPath2 = violation.getPropertyPath();
        Iterator iterator = CollectionConverters$.MODULE$.IteratorHasAsScala(propertyPath2.iterator()).asScala();
        if (iterator.hasNext()) {
            iterator.next();
            propertyPath = iterator.hasNext() ? CaseClassFieldMappingException$PropertyPath$.MODULE$.leaf(this.applyPropertyNamingStrategy(config, PathOps.RichPath$.MODULE$.getLeafNode$extension(PathOps$.MODULE$.RichPath(propertyPath2)).toString())) : CaseClassFieldMappingException$PropertyPath$.MODULE$.Empty();
        } else {
            propertyPath = CaseClassFieldMappingException$PropertyPath$.MODULE$.Empty();
        }
        return propertyPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<CaseClassFieldMappingException> executeMethodValidations(Option<ScalaValidator> validatorOption, Option<MethodDescriptor[]> methodDescriptorsOption, DeserializationConfig config, Object obj) {
        Tuple2 tuple2 = new Tuple2(validatorOption, methodDescriptorsOption);
        if (tuple2 == null) return (Seq)package$.MODULE$.Seq().empty();
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (!(option instanceof Some)) return (Seq)package$.MODULE$.Seq().empty();
        Some some = (Some)option;
        ScalaValidator validator = (ScalaValidator)some.value();
        if (!(option2 instanceof Some)) return (Seq)package$.MODULE$.Seq().empty();
        Some some2 = (Some)option2;
        MethodDescriptor[] methodDescriptors = (MethodDescriptor[])some2.value();
        try {
            Seq seq = ((IterableOnceOps)validator.forExecutables().validateMethods(methodDescriptors, obj, (Seq)Nil$.MODULE$).map((Function1 & Serializable)violation -> new CaseClassFieldMappingException(MODULE$.getMethodValidationViolationPropertyPath(config, (ConstraintViolation<?>)violation), new CaseClassFieldMappingException.Reason(violation.getMessage(), new CaseClassFieldMappingException.ValidationError((ConstraintViolation<?>)violation, CaseClassFieldMappingException$ValidationError$Method$.MODULE$, (Option<Payload>)ConstraintViolationOps.RichConstraintViolation$.MODULE$.getDynamicPayload$extension(ConstraintViolationOps$.MODULE$.RichConstraintViolation(violation), Payload.class)))))).toSeq();
            return seq;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 == null) throw throwable;
            Option option3 = NonFatal$.MODULE$.unapply(throwable2);
            if (option3.isEmpty()) throw throwable;
            Throwable e = (Throwable)option3.get();
            if (!(e instanceof InvocationTargetException)) throw throwable;
            InvocationTargetException invocationTargetException = (InvocationTargetException)e;
            if (invocationTargetException.getCause() == null) throw throwable;
            throw invocationTargetException.getCause();
        }
    }

    private CaseClassDeserializer$() {
    }
}

