/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.jackson.caseclass;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.twitter.util.jackson.caseclass.CaseClassDeserializer;
import com.twitter.util.jackson.caseclass.CaseClassField;
import com.twitter.util.jackson.caseclass.package$;
import com.twitter.util.reflect.Annotations$;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import org.json4s.reflect.ClassDescriptor;
import scala.Array$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CaseClassField$
implements Serializable {
    public static final CaseClassField$ MODULE$ = new CaseClassField$();

    public CaseClassField[] createFields(Class<?> clazz, Executable constructor, ClassDescriptor clazzDescriptor, CaseClassDeserializer.PropertyDefinition[] propertyDefinitions, Map<String, Annotation[]> fieldAnnotations, PropertyNamingStrategy namingStrategy) {
        Parameter[] parameters = constructor.getParameters();
        CaseClassField[] fields = new CaseClassField[parameters.length];
        for (int index = 0; index < parameters.length; ++index) {
            Annotation[] annotationArray;
            CaseClassDeserializer.PropertyDefinition propertyDefinition = propertyDefinitions[index];
            Option option = fieldAnnotations.get((Object)propertyDefinition.beanPropertyDefinition().getName());
            if (option instanceof Some) {
                Some some = (Some)option;
                Annotation[] v = (Annotation[])some.value();
                annotationArray = v;
            } else {
                annotationArray = (Annotation[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Annotation.class));
            }
            Annotation[] annotations = annotationArray;
            String name = this.jsonNameForField(namingStrategy, annotations, propertyDefinition.beanPropertyDefinition().getName());
            fields[index] = this.apply(name, index, propertyDefinition.javaType(), clazz, annotations, propertyDefinition.beanPropertyDefinition(), package$.MODULE$.defaultMethod(clazzDescriptor, index));
        }
        return fields;
    }

    private String jsonNameForField(PropertyNamingStrategy namingStrategy, Annotation[] annotations, String name) {
        String string;
        Some some;
        JsonProperty jsonProperty;
        Option option = Annotations$.MODULE$.findAnnotation(annotations, ClassTag$.MODULE$.apply(JsonProperty.class));
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((jsonProperty = (JsonProperty)(some = (Some)option).value()).value()))) {
            string = jsonProperty.value();
        } else {
            String decodedName = NameTransformer$.MODULE$.decode(name);
            string = namingStrategy.nameForField(null, null, decodedName);
        }
        return string;
    }

    public CaseClassField apply(String name, int index, JavaType javaType, Class<?> parentClass, Annotation[] annotations, BeanPropertyDefinition beanPropertyDefinition, Option<Function0<Object>> defaultFn) {
        return new CaseClassField(name, index, javaType, parentClass, annotations, beanPropertyDefinition, defaultFn);
    }

    public Option<Tuple7<String, Object, JavaType, Class<?>, Annotation[], BeanPropertyDefinition, Option<Function0<Object>>>> unapply(CaseClassField x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.name(), (Object)BoxesRunTime.boxToInteger((int)x$0.index()), (Object)x$0.javaType(), x$0.parentClass(), (Object)x$0.annotations(), (Object)x$0.beanPropertyDefinition(), x$0.defaultFn()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CaseClassField$.class);
    }

    private CaseClassField$() {
    }
}

