/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.jackson.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.twitter.util.Duration;
import com.twitter.util.Duration$;
import scala.Option;
import scala.util.control.NonFatal$;

public final class DurationStringDeserializer$
extends JsonDeserializer<Duration> {
    public static final DurationStringDeserializer$ MODULE$ = new DurationStringDeserializer$();

    public final Duration deserialize(JsonParser jp, DeserializationContext ctxt) {
        JsonToken jsonToken = jp.currentToken();
        boolean bl = JsonToken.NOT_AVAILABLE.equals(jsonToken) ? true : JsonToken.START_OBJECT.equals(jsonToken);
        Duration duration = bl ? this.handleToken(jp.nextToken(), jp, ctxt) : this.handleToken(jp.currentToken(), jp, ctxt);
        return duration;
    }

    private Duration handleToken(JsonToken token, JsonParser jp, DeserializationContext ctxt) {
        Duration duration;
        String value = jp.getText().trim();
        if (value.isEmpty()) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"field cannot be empty");
        }
        try {
            duration = Duration$.MODULE$.parse(value);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)e.getMessage(), (Throwable)e);
            }
            throw throwable;
        }
        return duration;
    }

    private DurationStringDeserializer$() {
    }
}

