/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.jackson.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.TimeFormat;
import com.twitter.util.jackson.serde.TimeStringDeserializer$;
import java.io.Serializable;
import java.util.Locale;
import java.util.TimeZone;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005-s!\u0002\b\u0010\u0011\u0003Qb!\u0002\u000f\u0010\u0011\u0003i\u0002\"\u0002\u0017\u0002\t\u0003i\u0003B\u0002\u0018\u0002A\u0003%q\u0006C\u0003;\u0003\u0011\u00051\b\u0003\u0004;\u0003\u0011\u0005\u00111\u0003\u0005\u0007u\u0005!\t!!\u0007\t\u0013\u0005m\u0012!!A\u0005\n\u0005ub\u0001\u0002\u000f\u0010\u0001uB\u0001b\u0015\u0005\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u0006Y!!\ta\u0016\u0005\u00063\"!\tE\u0017\u0005\u0007S\"\u0001K\u0011\u00026\t\u000bIDA\u0011I:\u0002-QKW.Z*ue&tw\rR3tKJL\u0017\r\\5{KJT!\u0001E\t\u0002\u000bM,'\u000fZ3\u000b\u0005I\u0019\u0012a\u00026bG.\u001cxN\u001c\u0006\u0003)U\tA!\u001e;jY*\u0011acF\u0001\bi^LG\u000f^3s\u0015\u0005A\u0012aA2p[\u000e\u0001\u0001CA\u000e\u0002\u001b\u0005y!A\u0006+j[\u0016\u001cFO]5oO\u0012+7/\u001a:jC2L'0\u001a:\u0014\u0007\u0005qB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K)j\u0011A\n\u0006\u0003O!\n!![8\u000b\u0003%\nAA[1wC&\u00111F\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\t\u0011\u0003R3gCVdG\u000fV5nK\u001a{'/\\1u!\t\u0001tG\u0004\u00022kA\u0011!\u0007I\u0007\u0002g)\u0011A'G\u0001\u0007yI|w\u000e\u001e \n\u0005Y\u0002\u0013A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!A\u000e\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0003q\u0002\"a\u0007\u0005\u0014\u0007!qt\nE\u0002@\u0013.k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b1a\u001d;e\u0015\t\u0019E)A\u0003eKN,'O\u0003\u0002F\r\u0006AA-\u0019;bE&tGM\u0003\u0002\u0013\u000f*\u0011\u0001jF\u0001\nM\u0006\u001cH/\u001a:y[2L!A\u0013!\u0003+M#HmU2bY\u0006\u0014H)Z:fe&\fG.\u001b>feB\u0011A*T\u0007\u0002'%\u0011aj\u0005\u0002\u0005)&lW\r\u0005\u0002Q#6\t!)\u0003\u0002S\u0005\n12i\u001c8uKb$X/\u00197EKN,'/[1mSj,'/\u0001\u0006uS6,gi\u001c:nCR\u0004\"\u0001T+\n\u0005Y\u001b\"A\u0003+j[\u00164uN]7biR\u0011A\b\u0017\u0005\u0006'*\u0001\r\u0001V\u0001\fI\u0016\u001cXM]5bY&TX\rF\u0002L7\u000eDQ\u0001X\u0006A\u0002u\u000b!A\u001b9\u0011\u0005y\u000bW\"A0\u000b\u0005\u00014\u0015\u0001B2pe\u0016L!AY0\u0003\u0015)\u001bxN\u001c)beN,'\u000fC\u0003e\u0017\u0001\u0007Q-\u0001\u0003dib$\bC\u00014h\u001b\u0005!\u0015B\u00015E\u0005Y!Um]3sS\u0006d\u0017N_1uS>t7i\u001c8uKb$\u0018a\u00035b]\u0012dW\rV8lK:$BaS6qc\")A\u000e\u0004a\u0001[\u0006)Ao\\6f]B\u0011aL\\\u0005\u0003_~\u0013\u0011BS:p]R{7.\u001a8\t\u000bqc\u0001\u0019A/\t\u000b\u0011d\u0001\u0019A3\u0002!\r\u0014X-\u0019;f\u0007>tG/\u001a=uk\u0006dG#\u0002;\u0002\b\u0005%\u0001GA;{!\r1g\u000f_\u0005\u0003o\u0012\u0013\u0001CS:p]\u0012+7/\u001a:jC2L'0\u001a:\u0011\u0005eTH\u0002\u0001\u0003\nw6\t\t\u0011!A\u0003\u0002q\u00141a\u0018\u00132#\ri\u0018\u0011\u0001\t\u0003?yL!a \u0011\u0003\u000f9{G\u000f[5oOB\u0019q$a\u0001\n\u0007\u0005\u0015\u0001EA\u0002B]fDQ\u0001Z\u0007A\u0002\u0015Dq!a\u0003\u000e\u0001\u0004\ti!\u0001\u0005qe>\u0004XM\u001d;z!\r1\u0017qB\u0005\u0004\u0003#!%\u0001\u0004\"fC:\u0004&o\u001c9feRLHc\u0001\u001f\u0002\u0016!1\u0011qC\u0003A\u0002=\nq\u0001]1ui\u0016\u0014h\u000eF\u0004=\u00037\ti\"!\r\t\r\u0005]a\u00011\u00010\u0011\u001d\tyB\u0002a\u0001\u0003C\ta\u0001\\8dC2,\u0007#B\u0010\u0002$\u0005\u001d\u0012bAA\u0013A\t1q\n\u001d;j_:\u0004B!!\u000b\u0002.5\u0011\u00111\u0006\u0006\u0003)!JA!a\f\u0002,\t1Aj\\2bY\u0016Dq!a\r\u0007\u0001\u0004\t)$\u0001\u0005uS6,'p\u001c8f!\u0011\tI#a\u000e\n\t\u0005e\u00121\u0006\u0002\t)&lWMW8oK\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t\u0015\u0002\t1\fgnZ\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0004PE*,7\r\u001e")
public class TimeStringDeserializer
extends StdScalarDeserializer<Time>
implements ContextualDeserializer {
    private final TimeFormat timeFormat;

    public static TimeStringDeserializer apply(String pattern, Option<Locale> locale, TimeZone timezone) {
        return TimeStringDeserializer$.MODULE$.apply(pattern, locale, timezone);
    }

    public static TimeStringDeserializer apply(String pattern) {
        return TimeStringDeserializer$.MODULE$.apply(pattern);
    }

    public static TimeStringDeserializer apply() {
        return TimeStringDeserializer$.MODULE$.apply();
    }

    public Time deserialize(JsonParser jp, DeserializationContext ctxt) {
        JsonToken jsonToken = jp.currentToken();
        boolean bl = JsonToken.NOT_AVAILABLE.equals(jsonToken) ? true : JsonToken.START_OBJECT.equals(jsonToken);
        Time time = bl ? this.handleToken(jp.nextToken(), jp, ctxt) : this.handleToken(jp.currentToken(), jp, ctxt);
        return time;
    }

    private Time handleToken(JsonToken token, JsonParser jp, DeserializationContext ctxt) {
        Time time;
        try {
            String value = jp.getText().trim();
            if (value.isEmpty()) {
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)"field cannot be empty");
            }
            time = this.timeFormat.parse(value);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)new StringBuilder(15).append("error parsing '").append(jp.getText()).append(new StringBuilder(9).append("' into a ").append(Time$.MODULE$.getClass().getName()).toString()).toString(), (Throwable)e);
            }
            throw throwable;
        }
        return time;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        Option deserializerOption = Option$.MODULE$.apply((Object)this.findFormatOverrides(ctxt, property, this.handledType())).flatMap((Function1 & Serializable)jsonFormat -> Option$.MODULE$.apply((Object)TimeStringDeserializer$.MODULE$.apply(jsonFormat.getPattern(), (Option<Locale>)Option$.MODULE$.apply((Object)jsonFormat.getLocale()), (TimeZone)Option$.MODULE$.apply((Object)jsonFormat.getTimeZone()).getOrElse((Function0 & Serializable)() -> TimeZone.getTimeZone("UTC")))).withFilter((Function1 & Serializable)deserializer -> BoxesRunTime.boxToBoolean((boolean)jsonFormat.hasPattern())).map((Function1 & Serializable)deserializer -> deserializer));
        return (JsonDeserializer)deserializerOption.getOrElse((Function0 & Serializable)() -> this);
    }

    public TimeStringDeserializer(TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
        super(Time.class);
    }
}

