/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.sun.management.UnixOperatingSystemMXBean;
import com.twitter.conversions.StringOps;
import com.twitter.conversions.StringOps$;
import com.twitter.finagle.stats.BroadcastStatsReceiver$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.jvm.Allocations;
import com.twitter.jvm.Jvm;
import com.twitter.jvm.Jvm$;
import java.io.Serializable;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class JvmStats$ {
    public static JvmStats$ MODULE$;
    private final Set<Object> gauges;
    private volatile Allocations allocations;

    static {
        new JvmStats$();
    }

    public void register(StatsReceiver statsReceiver) {
        Object object;
        Object object2;
        Object object3;
        StatsReceiver stats = statsReceiver.scope("jvm");
        MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        StatsReceiver heapStats = stats.scope("heap");
        this.gauges.add((Object)heapStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> JvmStats$.heap$1(mem).getCommitted()));
        this.gauges.add((Object)heapStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> JvmStats$.heap$1(mem).getMax()));
        this.gauges.add((Object)heapStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> JvmStats$.heap$1(mem).getUsed()));
        StatsReceiver nonHeapStats = stats.scope("nonheap");
        this.gauges.add((Object)nonHeapStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> JvmStats$.nonHeap$1(mem).getCommitted()));
        this.gauges.add((Object)nonHeapStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> JvmStats$.nonHeap$1(mem).getMax()));
        this.gauges.add((Object)nonHeapStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> JvmStats$.nonHeap$1(mem).getUsed()));
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        StatsReceiver threadStats = stats.scope("thread");
        this.gauges.add((Object)threadStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"daemon_count"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> threads.getDaemonThreadCount()));
        this.gauges.add((Object)threadStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> threads.getThreadCount()));
        this.gauges.add((Object)threadStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"peak_count"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> threads.getPeakThreadCount()));
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        this.gauges.add((Object)stats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"start_time"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> runtime.getStartTime()));
        this.gauges.add((Object)stats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uptime"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> runtime.getUptime()));
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        this.gauges.add((Object)stats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"num_cpus"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> os.getAvailableProcessors()));
        OperatingSystemMXBean operatingSystemMXBean = os;
        if (operatingSystemMXBean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixOperatingSystemMXBean = (UnixOperatingSystemMXBean)operatingSystemMXBean;
            this.gauges.add((Object)stats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fd_count"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> unixOperatingSystemMXBean.getOpenFileDescriptorCount()));
            object3 = BoxesRunTime.boxToBoolean((boolean)this.gauges.add((Object)stats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fd_limit"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> unixOperatingSystemMXBean.getMaxFileDescriptorCount())));
        } else {
            object3 = BoxedUnit.UNIT;
        }
        StatsReceiver compilerStats = stats.scope("compiler");
        this.gauges.add((Object)compilerStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"graal"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> {
            String string = System.getProperty("jvmci.Compiler");
            float f = "graal".equals(string) ? 1.0f : 0.0f;
            return f;
        }));
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean == null) {
            object2 = BoxedUnit.UNIT;
        } else {
            StatsReceiver compilationStats = stats.scope("compilation");
            object2 = BoxesRunTime.boxToBoolean((boolean)this.gauges.add((Object)compilationStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time_msec"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> compilationMXBean.getTotalCompilationTime())));
        }
        ClassLoadingMXBean classes = ManagementFactory.getClassLoadingMXBean();
        StatsReceiver classLoadingStats = stats.scope("classes");
        this.gauges.add((Object)classLoadingStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total_loaded"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> classes.getTotalLoadedClassCount()));
        this.gauges.add((Object)classLoadingStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total_unloaded"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> classes.getUnloadedClassCount()));
        this.gauges.add((Object)classLoadingStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_loaded"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> classes.getLoadedClassCount()));
        Buffer memPool = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getMemoryPoolMXBeans()).asScala();
        StatsReceiver memStats = stats.scope("mem");
        StatsReceiver currentMem = memStats.scope("current");
        StatsReceiver postGCMem = memStats.scope("postGC");
        StatsReceiver postGCStats = BroadcastStatsReceiver$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StatsReceiver[]{stats.scope("postGC"), postGCMem})));
        memPool.foreach((Function1 & Serializable & scala.Serializable)pool -> {
            Object object;
            String name = StringOps.RichString$.MODULE$.regexSub$extension(StringOps$.MODULE$.RichString(pool.getName()), new StringOps(Predef$.MODULE$.augmentString("[^\\w]")).r(), (Function1 & Serializable & scala.Serializable)m -> "_");
            Object object2 = pool.getCollectionUsage() != null ? BoxesRunTime.boxToBoolean((boolean)JvmStats$.MODULE$.gauges.add((Object)postGCStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name, "used"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> JvmStats$.usage$1(pool).getUsed()))) : BoxedUnit.UNIT;
            if (pool.getUsage() != null) {
                JvmStats$.MODULE$.gauges.add((Object)currentMem.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name, "used"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> JvmStats$.usage$2(pool).getUsed()));
                object = BoxesRunTime.boxToBoolean((boolean)JvmStats$.MODULE$.gauges.add((Object)currentMem.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name, "max"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> JvmStats$.usage$2(pool).getMax())));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        this.gauges.add((Object)postGCStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)memPool.flatMap((Function1 & Serializable & scala.Serializable)p -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)p.getCollectionUsage())), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getUsed()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
        this.gauges.add((Object)currentMem.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)memPool.flatMap((Function1 & Serializable & scala.Serializable)p -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)p.getUsage())), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getUsed()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
        Jvm jvm = Jvm$.MODULE$.apply();
        jvm.metaspaceUsage().foreach((Function1 & Serializable & scala.Serializable)usage -> BoxesRunTime.boxToBoolean((boolean)JvmStats$.MODULE$.gauges.add((Object)memStats.scope("metaspace").addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max_capacity"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> usage.maxCapacity().inBytes()))));
        StatsReceiver spStats = stats.scope("safepoint");
        this.gauges.add((Object)spStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sync_time_millis"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> jvm.safepoint().syncTimeMillis()));
        this.gauges.add((Object)spStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total_time_millis"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> jvm.safepoint().totalTimeMillis()));
        this.gauges.add((Object)spStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> jvm.safepoint().count()));
        List<BufferPoolMXBean> list = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        if (list == null) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            StatsReceiver bufferPoolStats = memStats.scope("buffer");
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).foreach((Function1 & Serializable & scala.Serializable)bp -> BoxesRunTime.boxToBoolean((boolean)JvmStats$.$anonfun$register$36(bufferPoolStats, bp)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Buffer gcPool = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getGarbageCollectorMXBeans()).asScala();
        StatsReceiver gcStats = stats.scope("gc");
        gcPool.foreach((Function1 & Serializable & scala.Serializable)gc -> BoxesRunTime.boxToBoolean((boolean)JvmStats$.$anonfun$register$40(gcStats, gc)));
        this.gauges.add((Object)gcStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cycles"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)gcPool.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getCollectionCount()), Buffer$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> x$4 > 0L)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
        this.gauges.add((Object)gcStats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msec"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)gcPool.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getCollectionTime()), Buffer$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$6 -> x$6 > 0L)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
        this.allocations = new Allocations(gcStats);
        this.allocations.start();
        if (this.allocations.trackingEden()) {
            StatsReceiver allocationStats = memStats.scope("allocations");
            StatsReceiver eden = allocationStats.scope("eden");
            object = BoxesRunTime.boxToBoolean((boolean)this.gauges.add((Object)eden.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bytes"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> JvmStats$.MODULE$.allocations.eden())));
        } else {
            object = BoxedUnit.UNIT;
        }
        this.gauges.add((Object)stats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"application_time_millis"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> (float)jvm.applicationTime() / (float)1000000));
        this.gauges.add((Object)stats.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tenuring_threshold"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> jvm.tenuringThreshold()));
    }

    private static final MemoryUsage heap$1(MemoryMXBean mem$1) {
        return mem$1.getHeapMemoryUsage();
    }

    private static final MemoryUsage nonHeap$1(MemoryMXBean mem$1) {
        return mem$1.getNonHeapMemoryUsage();
    }

    private static final MemoryUsage usage$1(MemoryPoolMXBean pool$1) {
        return pool$1.getCollectionUsage();
    }

    private static final MemoryUsage usage$2(MemoryPoolMXBean pool$1) {
        return pool$1.getUsage();
    }

    public static final /* synthetic */ boolean $anonfun$register$36(StatsReceiver bufferPoolStats$1, BufferPoolMXBean bp) {
        String name = bp.getName();
        JvmStats$.MODULE$.gauges.add((Object)bufferPoolStats$1.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name, "count"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> bp.getCount()));
        JvmStats$.MODULE$.gauges.add((Object)bufferPoolStats$1.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name, "used"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> bp.getMemoryUsed()));
        return JvmStats$.MODULE$.gauges.add((Object)bufferPoolStats$1.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name, "max"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> bp.getTotalCapacity()));
    }

    public static final /* synthetic */ boolean $anonfun$register$40(StatsReceiver gcStats$1, GarbageCollectorMXBean gc) {
        String name = StringOps.RichString$.MODULE$.regexSub$extension(StringOps$.MODULE$.RichString(gc.getName()), new StringOps(Predef$.MODULE$.augmentString("[^\\w]")).r(), (Function1 & Serializable & scala.Serializable)m -> "_");
        JvmStats$.MODULE$.gauges.add((Object)gcStats$1.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name, "cycles"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> gc.getCollectionCount()));
        return JvmStats$.MODULE$.gauges.add((Object)gcStats$1.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name, "msec"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> gc.getCollectionTime()));
    }

    private JvmStats$() {
        MODULE$ = this;
        this.gauges = Set$.MODULE$.empty();
    }
}

