/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.Handler;
import com.twitter.logging.LazyLogRecordUnformatted;
import com.twitter.logging.ProxyHandler;
import com.twitter.logging.ThrottledHandler$;
import com.twitter.util.Duration;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rv!B\u0001\u0003\u0011\u0003I\u0011\u0001\u0005+ie>$H\u000f\\3e\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0004m_\u001e<\u0017N\\4\u000b\u0005\u00151\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u000f\u0005\u00191m\\7\u0004\u0001A\u0011!bC\u0007\u0002\u0005\u0019)AB\u0001E\u0001\u001b\t\u0001B\u000b\u001b:piRdW\r\u001a%b]\u0012dWM]\n\u0003\u00179\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\f\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\n\u0011\u0015A2\u0002\"\u0001\u001a\u0003\u0015\t\u0007\u000f\u001d7z)\u001dQ\u0012QMA;\u0003o\u00022aD\u000e\u001e\u0013\ta\u0002CA\u0005Gk:\u001cG/[8oaA\u0011!B\b\u0004\u0005\u0019\t\u0001qd\u0005\u0002\u001fAA\u0011!\"I\u0005\u0003E\t\u0011A\u0002\u0015:pqfD\u0015M\u001c3mKJD\u0011\u0002\n\u0010\u0003\u0002\u0003\u0006I!\n\u0015\u0002\u000f!\fg\u000e\u001a7feB\u0011!BJ\u0005\u0003O\t\u0011q\u0001S1oI2,'/\u0003\u0002%C!A!F\bBC\u0002\u0013\u00051&\u0001\u0005ekJ\fG/[8o+\u0005a\u0003CA\u00171\u001b\u0005q#BA\u0018\u0005\u0003\u0011)H/\u001b7\n\u0005Er#\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u0011Mr\"\u0011!Q\u0001\n1\n\u0011\u0002Z;sCRLwN\u001c\u0011\t\u0011Ur\"Q1A\u0005\u0002Y\nA\"\\1y)>$\u0015n\u001d9mCf,\u0012a\u000e\t\u0003\u001faJ!!\u000f\t\u0003\u0007%sG\u000f\u0003\u0005<=\t\u0005\t\u0015!\u00038\u00035i\u0017\r\u001f+p\t&\u001c\b\u000f\\1zA!)QC\bC\u0001{Q!QDP A\u0011\u0015!C\b1\u0001&\u0011\u0015QC\b1\u0001-\u0011\u0015)D\b1\u00018\r\u0011\u0011e\u0004B\"\u0003\u0011QC'o\u001c;uY\u0016\u001c\"!\u0011\b\t\u0011\u0015\u000b%\u0011!Q\u0001\n\u0019\u000b\u0011b\u001d;beR$\u0016.\\3\u0011\u00055:\u0015B\u0001%/\u0005\u0011!\u0016.\\3\t\u0011)\u000b%\u0011!Q\u0001\n-\u000bAA\\1nKB\u0011Aj\u0014\b\u0003\u001f5K!A\u0014\t\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001dBA\u0001bU!\u0003\u0002\u0003\u0006I\u0001V\u0001\u0006Y\u00164X\r\u001c\t\u0003+jk\u0011A\u0016\u0006\u0003\u0007]S!a\f-\u000b\u0003e\u000bAA[1wC&\u00111L\u0016\u0002\u0006\u0019\u00164X\r\u001c\u0005\u0006+\u0005#\t!\u0018\u000b\u0005=\u0002\f'\r\u0005\u0002`\u00036\ta\u0004C\u0003F9\u0002\u0007a\tC\u0003K9\u0002\u00071\nC\u0003T9\u0002\u0007A\u000b\u0003\u0004e\u0003\u0002\u0006K!Z\u0001\bKb\u0004\u0018N]3e!\tya-\u0003\u0002h!\t9!i\\8mK\u0006t\u0007FA2j!\ty!.\u0003\u0002l!\tAao\u001c7bi&dW\r\u0003\u0004n\u0003\u0002\u0006IA\\\u0001\u0006G>,h\u000e\u001e\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fa!\u0019;p[&\u001c'BA:X\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003kB\u0014Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\b\"B<B\t\u0003B\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003-CQA_!\u0005\u0006m\f1!\u00193e)\u0011)G0a\u0001\t\u000buL\b\u0019\u0001@\u0002\rI,7m\u001c:e!\t)v0C\u0002\u0002\u0002Y\u0013\u0011\u0002T8h%\u0016\u001cwN\u001d3\t\r\u0005\u0015\u0011\u00101\u0001G\u0003\rqwn\u001e\u0005\b\u0003\u0013\tEQAA\u0006\u0003=\u0011X-\\8wK&3W\t\u001f9je\u0016$GcA3\u0002\u000e!9\u0011QAA\u0004\u0001\u00041\u0005\u0002CA\t\u0003\u0002&I!a\u0005\u0002!A,(\r\\5tQN;\u0018\r\u001c7po\u0016$GCAA\u000b!\ry\u0011qC\u0005\u0004\u00033\u0001\"\u0001B+oSRD\u0011\"!\b\u001f\u0005\u0004%I!a\b\u0002\u001d1\f7\u000f\u001e$mkND7\t[3dWV\u0011\u0011\u0011\u0005\t\u0005_\u0006\rb)C\u0002\u0002&A\u0014q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\u0005\t\u0003Sq\u0002\u0015!\u0003\u0002\"\u0005yA.Y:u\r2,8\u000f[\"iK\u000e\\\u0007\u0005C\u0005\u0002.y\u0011\r\u0011\"\u0003\u00020\u0005YA\u000f\u001b:piRdW-T1q+\t\t\t\u0004\u0005\u0004\u00024\u0005U2JX\u0007\u0002e&\u0019\u0011q\u0007:\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0003\u0005\u0002<y\u0001\u000b\u0011BA\u0019\u00031!\bN]8ui2,W*\u00199!\u0011\u001d\tyD\bC\u0001\u0003'\tQA]3tKRD\u0003\"!\u0010\u0002D\u0005%\u0013Q\n\t\u0004\u001f\u0005\u0015\u0013bAA$!\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005-\u0013\u0001H+tK\u00022G.^:i)\"\u0014x\u000e\u001e;mK\u0012D\u0013\u0006I5ogR,\u0017\rZ\u0011\u0003\u0003\u001f\na!\u000e\u00184]E\u001a\u0004bBA*=\u0011\u0005\u00111C\u0001\u000fM2,8\u000f\u001b+ie>$H\u000f\\3e\u0011\u001d\t9F\bC!\u00033\nq\u0001];cY&\u001c\b\u000e\u0006\u0003\u0002\u0016\u0005m\u0003BB?\u0002V\u0001\u0007a\u0010C\u0004\u0002`y!I!!\u0019\u0002\u0013\u0011|\u0007+\u001e2mSNDG\u0003BA\u000b\u0003GBa!`A/\u0001\u0004q\bB\u0002\u0013\u0018\u0001\u0004\t9\u0007\u0005\u0003\u0002j\u0005=db\u0001\u0006\u0002l%\u0019\u0011Q\u000e\u0002\u0002\u000fA\f7m[1hK&!\u0011\u0011OA:\u00059A\u0015M\u001c3mKJ4\u0015m\u0019;pefT1!!\u001c\u0003\u0011\u001dQs\u0003%AA\u00021Bq!N\f\u0011\u0002\u0003\u0007q\u0007\u0003\u0005\u0002|-\u0011\r\u0011\"\u0003,\u0003%ye.Z*fG>tG\rC\u0004\u0002\u0000-\u0001\u000b\u0011\u0002\u0017\u0002\u0015=sWmU3d_:$\u0007\u0005C\u0005\u0002\u0004.\t\n\u0011\"\u0001\u0002\u0006\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\b*\u001aA&!#,\u0005\u0005-\u0005\u0003BAG\u0003/k!!a$\u000b\t\u0005E\u00151S\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!&\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\u000byIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!(\f#\u0003%\t!a(\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM*\"!!)+\u0007]\nI\t")
public class ThrottledHandler
extends ProxyHandler {
    private final Duration duration;
    private final int maxToDisplay;
    private final AtomicReference<Time> lastFlushCheck;
    private final ConcurrentHashMap<String, Throttle> throttleMap;

    public static int apply$default$3() {
        return ThrottledHandler$.MODULE$.apply$default$3();
    }

    public static Duration apply$default$2() {
        return ThrottledHandler$.MODULE$.apply$default$2();
    }

    public static Function0<ThrottledHandler> apply(Function0<Handler> function0, Duration duration, int n) {
        return ThrottledHandler$.MODULE$.apply(function0, duration, n);
    }

    public Duration duration() {
        return this.duration;
    }

    public int maxToDisplay() {
        return this.maxToDisplay;
    }

    private AtomicReference<Time> lastFlushCheck() {
        return this.lastFlushCheck;
    }

    private ConcurrentHashMap<String, Throttle> throttleMap() {
        return this.throttleMap;
    }

    public void reset() {
        this.flushThrottled();
    }

    public void flushThrottled() {
        Time now = Time$.MODULE$.now();
        ((MapLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.throttleMap()).asScala()).retain((Function2)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final Time now$1;

            public final boolean apply(String x0$1, Throttle x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (tuple2 != null) {
                    Throttle throttle = (Throttle)tuple2._2();
                    boolean bl = !throttle.removeIfExpired(this.now$1);
                    return bl;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.now$1 = now$1;
            }
        });
    }

    @Override
    public void publish(LogRecord record) {
        String string;
        LogRecord logRecord;
        Time last;
        Time now = Time$.MODULE$.now();
        if (now.$minus(last = this.lastFlushCheck().get()).$greater((Object)ThrottledHandler$.MODULE$.com$twitter$logging$ThrottledHandler$$OneSecond()) && this.lastFlushCheck().compareAndSet(last, now)) {
            this.flushThrottled();
        }
        if ((logRecord = record) instanceof LazyLogRecordUnformatted) {
            LazyLogRecordUnformatted lazyLogRecordUnformatted = (LazyLogRecordUnformatted)logRecord;
            string = lazyLogRecordUnformatted.preformatted();
        } else {
            string = record.getMessage();
        }
        String key = string;
        this.tryPublish$1(record, now, key);
    }

    public void com$twitter$logging$ThrottledHandler$$doPublish(LogRecord record) {
        super.publish(record);
    }

    private final void tryPublish$1(LogRecord record$1, Time now$2, String key$1) {
        Throttle throttle;
        while (!(throttle = this.throttleMap().computeIfAbsent(key$1, new Function<String, Throttle>(this, record$1, now$2){
            private final /* synthetic */ ThrottledHandler $outer;
            private final LogRecord record$1;
            private final Time now$2;

            public Throttle apply(String key) {
                return new Throttle(this.$outer, this.now$2, this.record$1.getLoggerName(), this.record$1.getLevel());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$1 = record$1;
                this.now$2 = now$2;
            }
        })).add(record$1, now$2)) {
        }
    }

    public ThrottledHandler(Handler handler, Duration duration, int maxToDisplay) {
        this.duration = duration;
        this.maxToDisplay = maxToDisplay;
        super(handler);
        this.lastFlushCheck = new AtomicReference<Time>(Time$.MODULE$.epoch());
        this.throttleMap = new ConcurrentHashMap();
    }

    public class Throttle {
        private final Time startTime;
        private final String name;
        private final Level level;
        private volatile boolean expired;
        private final AtomicInteger count;
        public final /* synthetic */ ThrottledHandler $outer;

        public String toString() {
            return new StringBuilder().append((Object)"Throttle: startTime=").append((Object)this.startTime).append((Object)" count=").append((Object)BoxesRunTime.boxToInteger((int)this.count.get())).toString();
        }

        public final boolean add(LogRecord record, Time now) {
            boolean bl;
            if (this.expired) {
                bl = false;
            } else {
                if (this.count.incrementAndGet() <= this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().maxToDisplay()) {
                    this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().com$twitter$logging$ThrottledHandler$$doPublish(record);
                }
                bl = true;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean removeIfExpired(Time now) {
            void var2_2;
            boolean didExpire;
            this.expired = didExpire = now.$minus(this.startTime).$greater$eq((Object)this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().duration());
            if (didExpire && this.count.get() > this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().maxToDisplay()) {
                this.publishSwallowed();
            }
            return (boolean)var2_2;
        }

        private void publishSwallowed() {
            LogRecord throttledRecord = new LogRecord(this.level, new StringOps(Predef$.MODULE$.augmentString("(swallowed %d repeating messages)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.count.get() - this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().maxToDisplay()))})));
            throttledRecord.setLoggerName(this.name);
            this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().com$twitter$logging$ThrottledHandler$$doPublish(throttledRecord);
        }

        public /* synthetic */ ThrottledHandler com$twitter$logging$ThrottledHandler$Throttle$$$outer() {
            return this.$outer;
        }

        public Throttle(ThrottledHandler $outer, Time startTime, String name, Level level) {
            this.startTime = startTime;
            this.name = name;
            this.level = level;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.expired = false;
            this.count = new AtomicInteger(0);
        }
    }
}

