/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.FileHandler$;
import com.twitter.logging.Formatter;
import com.twitter.logging.Formatter$;
import com.twitter.logging.Handler;
import com.twitter.logging.Level;
import com.twitter.logging.Policy;
import com.twitter.logging.Policy$Daily$;
import com.twitter.logging.Policy$Hourly$;
import com.twitter.logging.Policy$Never$;
import com.twitter.logging.Policy$SigHup$;
import com.twitter.util.HandleSignal$;
import com.twitter.util.StorageUnit;
import com.twitter.util.Time$;
import com.twitter.util.TwitterDateFormat$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.LogRecord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rs!B\u0001\u0003\u0011\u0003I\u0011a\u0003$jY\u0016D\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u000f1|wmZ5oO*\u0011QAB\u0001\bi^LG\u000f^3s\u0015\u00059\u0011aA2p[\u000e\u0001\u0001C\u0001\u0006\f\u001b\u0005\u0011a!\u0002\u0007\u0003\u0011\u0003i!a\u0003$jY\u0016D\u0015M\u001c3mKJ\u001c\"a\u0003\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011\u0015)2\u0002\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0002C\u0004\u0019\u0017\t\u0007I\u0011A\r\u0002\tU#f\tO\u000b\u00025A\u00111DI\u0007\u00029)\u0011QDH\u0001\bG\"\f'o]3u\u0015\ty\u0002%A\u0002oS>T\u0011!I\u0001\u0005U\u00064\u0018-\u0003\u0002$9\t91\t[1sg\u0016$\bBB\u0013\fA\u0003%!$A\u0003V)\u001aC\u0004\u0005C\u0003(\u0017\u0011\u0005\u0001&A\u0003baBd\u0017\u0010F\u0007*\u0003{\fyP!\u0001\u0003\u0004\t\u0015!q\u0001\t\u0004\u001f)b\u0013BA\u0016\u0011\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002\u000b[\u0019!AB\u0001\u0001/'\tis\u0006\u0005\u0002\u000ba%\u0011\u0011G\u0001\u0002\b\u0011\u0006tG\r\\3s\u0011!\u0019TF!A!\u0002\u0013!\u0014\u0001\u00029bi\"\u0004\"!\u000e\u001f\u000f\u0005YR\u0004CA\u001c\u0011\u001b\u0005A$BA\u001d\t\u0003\u0019a$o\\8u}%\u00111\bE\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<!!A\u0001)\fB\u0001B\u0003%\u0011)\u0001\u0006s_2d\u0007k\u001c7jGf\u0004\"A\u0003\"\n\u0005\r\u0013!A\u0002)pY&\u001c\u0017\u0010\u0003\u0005F[\t\u0015\r\u0011\"\u0001G\u0003\u0019\t\u0007\u000f]3oIV\tq\t\u0005\u0002\u0010\u0011&\u0011\u0011\n\u0005\u0002\b\u0005>|G.Z1o\u0011!YUF!A!\u0002\u00139\u0015aB1qa\u0016tG\r\t\u0005\t\u001b6\u0012\t\u0011)A\u0005\u001d\u0006Y!o\u001c;bi\u0016\u001cu.\u001e8u!\tyq*\u0003\u0002Q!\t\u0019\u0011J\u001c;\t\u0013Ik#\u0011!Q\u0001\nM3\u0016!\u00034pe6\fG\u000f^3s!\tQA+\u0003\u0002V\u0005\tIai\u001c:nCR$XM]\u0005\u0003%BB\u0011\u0002W\u0017\u0003\u0002\u0003\u0006I!W0\u0002\u000b1,g/\u001a7\u0011\u0007=QF,\u0003\u0002\\!\t1q\n\u001d;j_:\u0004\"AC/\n\u0005y\u0013!!\u0002'fm\u0016d\u0017B\u0001-1\u0011\u0015)R\u0006\"\u0001b)\u001da#m\u00193fM\u001eDQa\r1A\u0002QBQ\u0001\u00111A\u0002\u0005CQ!\u00121A\u0002\u001dCQ!\u00141A\u00029CQA\u00151A\u0002MCQ\u0001\u00171A\u0002eC!\"[\u0017\u0011\u0002\u0003\r\t\u0015!\u0003k\u0003\rAH%\r\t\u0005\u001f-lW.\u0003\u0002m!\t1A+\u001e9mKJ\u0002\"A\\9\u000e\u0003=T!\u0001\u001d\u0011\u0002\t1\fgnZ\u0005\u0003{=Dqa]\u0017C\u0002\u0013\u0005A/\u0001\u0005gS2,g.Y7f+\u0005i\u0007B\u0002<.A\u0003%Q.A\u0005gS2,g.Y7fA!9\u00010\fb\u0001\n\u0003!\u0018\u0001\u00028b[\u0016DaA_\u0017!\u0002\u0013i\u0017!\u00028b[\u0016\u0004\u0003B\u0003?.!\u0003\u0005\u0019\u0011)A\u0005U\u0006\u0019\u0001\u0010\n\u001a\t\u000fyl#\u0019!C\u0001i\u0006qa-\u001b7f]\u0006lW\r\u0015:fM&D\bbBA\u0001[\u0001\u0006I!\\\u0001\u0010M&dWM\\1nKB\u0013XMZ5yA!A\u0011QA\u0017C\u0002\u0013\u0005A/\u0001\bgS2,g.Y7f'V4g-\u001b=\t\u000f\u0005%Q\u0006)A\u0005[\u0006ya-\u001b7f]\u0006lWmU;gM&D\b\u0005C\u0005\u0002\u000e5\u0002\r\u0011\"\u0003\u0002\u0010\u000511\u000f\u001e:fC6,\"!!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006!\u0003\tIw.\u0003\u0003\u0002\u001c\u0005U!\u0001D(viB,Ho\u0015;sK\u0006l\u0007\"CA\u0010[\u0001\u0007I\u0011BA\u0011\u0003)\u0019HO]3b[~#S-\u001d\u000b\u0005\u0003G\tI\u0003E\u0002\u0010\u0003KI1!a\n\u0011\u0005\u0011)f.\u001b;\t\u0013%\fi\"!AA\u0002\u0005E\u0001\u0002CA\u0017[\u0001\u0006K!!\u0005\u0002\u000fM$(/Z1nA!I\u0011\u0011G\u0017A\u0002\u0013%\u00111G\u0001\t_B,g\u000eV5nKV\u0011\u0011Q\u0007\t\u0004\u001f\u0005]\u0012bAA\u001d!\t!Aj\u001c8h\u0011%\ti$\fa\u0001\n\u0013\ty$\u0001\u0007pa\u0016tG+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005\u0005\u0003\"C5\u0002<\u0005\u0005\t\u0019AA\u001b\u0011!\t)%\fQ!\n\u0005U\u0012!C8qK:$\u0016.\\3!Q\u0011\t\u0019%!\u0013\u0011\u0007=\tY%C\u0002\u0002NA\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003#j\u0003\u0019!C\u0005\u0003'\nAB\\3yiJ{G\u000e\u001c+j[\u0016,\"!!\u0016\u0011\t=Q\u0016Q\u0007\u0005\n\u00033j\u0003\u0019!C\u0005\u00037\n\u0001C\\3yiJ{G\u000e\u001c+j[\u0016|F%Z9\u0015\t\u0005\r\u0012Q\f\u0005\nS\u0006]\u0013\u0011!a\u0001\u0003+B\u0001\"!\u0019.A\u0003&\u0011QK\u0001\u000e]\u0016DHOU8mYRKW.\u001a\u0011\t\u0013\u0005\u0015T\u00061A\u0005\n\u0005M\u0012A\u00052zi\u0016\u001cxK]5ui\u0016tGk\u001c$jY\u0016D\u0011\"!\u001b.\u0001\u0004%I!a\u001b\u0002-\tLH/Z:Xe&$H/\u001a8U_\u001aKG.Z0%KF$B!a\t\u0002n!I\u0011.a\u001a\u0002\u0002\u0003\u0007\u0011Q\u0007\u0005\t\u0003cj\u0003\u0015)\u0003\u00026\u0005\u0019\"-\u001f;fg^\u0013\u0018\u000e\u001e;f]R{g)\u001b7fA!I\u0011QO\u0017C\u0002\u0013%\u0011qO\u0001\f[\u0006Dh)\u001b7f'&TX-\u0006\u0002\u0002zA!qBWA>!\u0011\ti(a!\u000e\u0005\u0005}$bAAA\t\u0005!Q\u000f^5m\u0013\u0011\t))a \u0003\u0017M#xN]1hKVs\u0017\u000e\u001e\u0005\t\u0003\u0013k\u0003\u0015!\u0003\u0002z\u0005aQ.\u0019=GS2,7+\u001b>fA!A\u0011QR\u0017C\u0002\u0013%a)A\bfq\u0006l\u0017N\\3S_2dG+[7f\u0011\u001d\t\t*\fQ\u0001\n\u001d\u000b\u0001#\u001a=b[&tWMU8mYRKW.\u001a\u0011\t\u000f\u0005UU\u0006\"\u0001\u0002\u0018\u0006)a\r\\;tQR\u0011\u00111\u0005\u0005\b\u00037kC\u0011AAL\u0003\u0015\u0019Gn\\:f\u0011\u001d\ty*\fC\u0005\u0003C\u000b!b\u001c9f]N#(/Z1n)\t\t\t\u0002C\u0004\u0002&6\"I!a&\u0002\u000f=\u0004XM\u001c'pO\"9\u0011\u0011V\u0017\u0005\u0002\u0005-\u0016A\u0003;j[\u0016\u001cVO\u001a4jqR\u0019Q.!,\t\u0011\u0005=\u0016q\u0015a\u0001\u0003c\u000bA\u0001Z1uKB!\u00111WA\\\u001b\t\t)LC\u0002\u0002\u0002\u0002JA!!/\u00026\n!A)\u0019;f\u0011\u001d\ti,\fC\u0001\u0003\u007f\u000b1cY8naV$XMT3yiJ{G\u000e\u001c+j[\u0016$B!!\u0016\u0002B\"A\u00111YA^\u0001\u0004\t)$A\u0002o_^Dq!a2.\t\u0013\t9*\u0001\bsK6|g/Z(mI\u001aKG.Z:\t\u000f\u0005-W\u0006\"\u0001\u0002\u0018\u0006!!o\u001c7m\u0011\u001d\ty-\fC\u0001\u0003#\fq\u0001];cY&\u001c\b\u000e\u0006\u0003\u0002$\u0005M\u0007\u0002CAk\u0003\u001b\u0004\r!a6\u0002\rI,7m\u001c:e!\u0011\tI.!8\u000e\u0005\u0005m'bA\u0002\u00026&!\u0011q\\An\u0005%aun\u001a*fG>\u0014H\rC\u0004\u0002d6\"I!!:\u0002\u001f!\fg\u000e\u001a7f)\"\u0014xn^1cY\u0016$B!a\t\u0002h\"A\u0011\u0011^Aq\u0001\u0004\tY/A\u0001f!\u0011\ti/a>\u000f\t\u0005=\u00181\u001f\b\u0004o\u0005E\u0018\"A\t\n\u0007\u0005U\b#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00181 \u0002\n)\"\u0014xn^1cY\u0016T1!!>\u0011\u0011\u0015\u0019h\u00051\u00015\u0011\u001d\u0001e\u0005%AA\u0002\u0005Cq!\u0012\u0014\u0011\u0002\u0003\u0007q\tC\u0004NMA\u0005\t\u0019\u0001(\t\u000fI3\u0003\u0013!a\u0001'\"9\u0001L\nI\u0001\u0002\u0004I\u0006\"\u0003B\u0006\u0017E\u0005I\u0011\u0001B\u0007\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\bU\r\t%\u0011C\u0016\u0003\u0005'\u0001BA!\u0006\u0003 5\u0011!q\u0003\u0006\u0005\u00053\u0011Y\"A\u0005v]\u000eDWmY6fI*\u0019!Q\u0004\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\"\t]!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!QE\u0006\u0012\u0002\u0013\u0005!qE\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0006\u0016\u0004\u000f\nE\u0001\"\u0003B\u0017\u0017E\u0005I\u0011\u0001B\u0018\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"TC\u0001B\u0019U\rq%\u0011\u0003\u0005\n\u0005kY\u0011\u0013!C\u0001\u0005o\tq\"\u00199qYf$C-\u001a4bk2$H%N\u000b\u0003\u0005sQ3a\u0015B\t\u0011%\u0011idCI\u0001\n\u0003\u0011y$A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011\tEK\u0002Z\u0005#\u0001")
public class FileHandler
extends Handler {
    private final Policy rollPolicy;
    private final boolean append;
    private final int rotateCount;
    private final /* synthetic */ Tuple2 x$1;
    private final String filename;
    private final String name;
    private final /* synthetic */ Tuple2 x$2;
    private final String filenamePrefix;
    private final String filenameSuffix;
    private OutputStream stream;
    private volatile long openTime;
    private Option<Object> nextRollTime;
    private long bytesWrittenToFile;
    private final Option<StorageUnit> maxFileSize;
    private final boolean examineRollTime;

    public static Option<Level> apply$default$6() {
        return FileHandler$.MODULE$.apply$default$6();
    }

    public static Formatter apply$default$5() {
        return FileHandler$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return FileHandler$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return FileHandler$.MODULE$.apply$default$3();
    }

    public static Policy apply$default$2() {
        return FileHandler$.MODULE$.apply$default$2();
    }

    public static Function0<FileHandler> apply(String string2, Policy policy, boolean bl, int n, Formatter formatter, Option<Level> option) {
        return FileHandler$.MODULE$.apply(string2, policy, bl, n, formatter, option);
    }

    public static Charset UTF8() {
        return FileHandler$.MODULE$.UTF8();
    }

    public boolean append() {
        return this.append;
    }

    public String filename() {
        return this.filename;
    }

    public String name() {
        return this.name;
    }

    public String filenamePrefix() {
        return this.filenamePrefix;
    }

    public String filenameSuffix() {
        return this.filenameSuffix;
    }

    private OutputStream stream() {
        return this.stream;
    }

    private void stream_$eq(OutputStream x$1) {
        this.stream = x$1;
    }

    private long openTime() {
        return this.openTime;
    }

    private void openTime_$eq(long x$1) {
        this.openTime = x$1;
    }

    private Option<Object> nextRollTime() {
        return this.nextRollTime;
    }

    private void nextRollTime_$eq(Option<Object> x$1) {
        this.nextRollTime = x$1;
    }

    private long bytesWrittenToFile() {
        return this.bytesWrittenToFile;
    }

    private void bytesWrittenToFile_$eq(long x$1) {
        this.bytesWrittenToFile = x$1;
    }

    private Option<StorageUnit> maxFileSize() {
        return this.maxFileSize;
    }

    private boolean examineRollTime() {
        return this.examineRollTime;
    }

    @Override
    public synchronized void flush() {
        this.stream().flush();
    }

    @Override
    public synchronized void close() {
        this.flush();
        try {
            this.stream().close();
        }
        catch (Throwable e) {
            this.handleThrowable(e);
        }
    }

    private OutputStream openStream() {
        File file = new File(this.filename());
        File dir = file.getParentFile();
        Object object = dir != null && !dir.exists() ? BoxesRunTime.boxToBoolean((boolean)dir.mkdirs()) : BoxedUnit.UNIT;
        this.bytesWrittenToFile_$eq(file.exists() ? file.length() : 0L);
        return new FileOutputStream(this.filename(), this.append());
    }

    private synchronized void openLog() {
        this.stream_$eq(this.openStream());
        this.openTime_$eq(Time$.MODULE$.now().inMilliseconds());
        this.nextRollTime_$eq(this.computeNextRollTime(this.openTime()));
    }

    public String timeSuffix(Date date) {
        SimpleDateFormat simpleDateFormat;
        Policy policy = this.rollPolicy;
        if (Policy$Never$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyy");
        } else if (Policy$SigHup$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyy");
        } else if (Policy$Hourly$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd-HH");
        } else if (Policy$Daily$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd");
        } else if (policy instanceof Policy.Weekly) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd");
        } else if (policy instanceof Policy.MaxSize) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd-HHmmss");
        } else {
            throw new MatchError((Object)policy);
        }
        SimpleDateFormat dateFormat = simpleDateFormat;
        dateFormat.setCalendar(super.formatter().calendar());
        return dateFormat.format(date);
    }

    public Option<Object> computeNextRollTime(long now) {
        None$ none$;
        LazyRef next$lzy = new LazyRef();
        Policy policy = this.rollPolicy;
        boolean bl = policy instanceof Policy.MaxSize ? true : (Policy$Never$.MODULE$.equals(policy) ? true : Policy$SigHup$.MODULE$.equals(policy));
        if (bl) {
            none$ = None$.MODULE$;
        } else if (Policy$Hourly$.MODULE$.equals(policy)) {
            this.next$1(now, next$lzy).add(11, 1);
            none$ = new Some((Object)this.next$1(now, next$lzy));
        } else if (Policy$Daily$.MODULE$.equals(policy)) {
            this.next$1(now, next$lzy).set(11, 0);
            this.next$1(now, next$lzy).add(5, 1);
            none$ = new Some((Object)this.next$1(now, next$lzy));
        } else if (policy instanceof Policy.Weekly) {
            Policy.Weekly weekly = (Policy.Weekly)policy;
            int weekday = weekly.dayOfWeek();
            this.next$1(now, next$lzy).set(11, 0);
            do {
                this.next$1(now, next$lzy).add(5, 1);
            } while (this.next$1(now, next$lzy).get(7) != weekday);
            none$ = new Some((Object)this.next$1(now, next$lzy));
        } else {
            throw new MatchError((Object)policy);
        }
        None$ rv = none$;
        return rv.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getTimeInMillis()));
    }

    private void removeOldFiles() {
        block0: {
            if (this.rotateCount < 0) break block0;
            String prefixName = new File(this.filenamePrefix()).getName();
            File[] rotatedFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(this.filename()).getParentFile().listFiles(new FilenameFilter(this, prefixName){
                private final /* synthetic */ FileHandler $outer;
                private final String prefixName$1;

                public boolean accept(File f, String fname) {
                    String string2 = fname;
                    String string3 = this.$outer.name();
                    return (string2 == null ? string3 != null : !string2.equals(string3)) && fname.startsWith(this.prefixName$1) && fname.endsWith(this.$outer.filenameSuffix());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.prefixName$1 = prefixName$1;
                }
            }))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), (Ordering)Ordering.String$.MODULE$);
            int toDeleteCount = package$.MODULE$.max(0, rotatedFiles.length - this.rotateCount);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rotatedFiles)).take(toDeleteCount))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.delete()));
        }
    }

    public synchronized void roll() {
        this.stream().close();
        String newFilename = new StringBuilder(1).append(this.filenamePrefix()).append("-").append(this.timeSuffix(new Date(this.openTime()))).append(this.filenameSuffix()).toString();
        new File(this.filename()).renameTo(new File(newFilename));
        this.openLog();
        this.removeOldFiles();
    }

    @Override
    public void publish(LogRecord record) {
        try {
            String formattedLine = this.getFormatter().format(record);
            byte[] formattedBytes = formattedLine.getBytes(FileHandler$.MODULE$.UTF8());
            int lineSizeBytes = formattedBytes.length;
            if (this.examineRollTime()) {
                FileHandler fileHandler = this;
                synchronized (fileHandler) {
                    this.nextRollTime().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)time2 -> {
                        block0: {
                            if (Time$.MODULE$.now().inMilliseconds() <= time2) break block0;
                            this.roll();
                        }
                    });
                }
            }
            this.maxFileSize().foreach((Function1 & Serializable & scala.Serializable)size -> {
                FileHandler.$anonfun$publish$2(this, lineSizeBytes, size);
                return BoxedUnit.UNIT;
            });
            FileHandler fileHandler = this;
            synchronized (fileHandler) {
                this.stream().write(formattedBytes);
                this.stream().flush();
                this.bytesWrittenToFile_$eq(this.bytesWrittenToFile() + (long)lineSizeBytes);
            }
        }
        catch (Throwable e) {
            this.handleThrowable(e);
        }
    }

    private void handleThrowable(Throwable e) {
        System.err.println(Formatter$.MODULE$.formatStackTrace(e, 30).mkString("\n"));
    }

    public static final /* synthetic */ void $anonfun$new$1(FileHandler $this, String signal) {
        OutputStream oldStream = $this.stream();
        FileHandler fileHandler = $this;
        synchronized (fileHandler) {
            $this.stream_$eq($this.openStream());
        }
        try {
            oldStream.close();
        }
        catch (Throwable e) {
            $this.handleThrowable(e);
        }
    }

    private final /* synthetic */ Calendar next$lzycompute$1(long now$1, LazyRef next$lzy$1) {
        Calendar calendar;
        LazyRef lazyRef = next$lzy$1;
        synchronized (lazyRef) {
            Calendar calendar2;
            if (next$lzy$1.initialized()) {
                calendar2 = (Calendar)next$lzy$1.value();
            } else {
                Calendar n = (Calendar)super.formatter().calendar().clone();
                n.setTimeInMillis(now$1);
                n.set(14, 0);
                n.set(13, 0);
                n.set(12, 0);
                calendar2 = (Calendar)next$lzy$1.initialize((Object)n);
            }
            calendar = calendar2;
        }
        return calendar;
    }

    private final Calendar next$1(long now$1, LazyRef next$lzy$1) {
        return next$lzy$1.initialized() ? (Calendar)next$lzy$1.value() : this.next$lzycompute$1(now$1, next$lzy$1);
    }

    public static final /* synthetic */ void $anonfun$publish$2(FileHandler $this, int lineSizeBytes$1, StorageUnit size) {
        FileHandler fileHandler = $this;
        synchronized (fileHandler) {
            if ($this.bytesWrittenToFile() + (long)lineSizeBytes$1 > size.bytes()) {
                $this.roll();
            }
        }
    }

    public FileHandler(String path, Policy rollPolicy, boolean append, int rotateCount, Formatter formatter, Option<Level> level) {
        block4: {
            None$ none$;
            Tuple2 tuple2;
            this.rollPolicy = rollPolicy;
            this.append = append;
            this.rotateCount = rotateCount;
            super(formatter, level);
            File f = new File(path);
            Tuple2 tuple22 = new Tuple2((Object)f.getAbsolutePath(), (Object)f.getName());
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String filename = (String)tuple22._1();
            String name = (String)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)filename, (Object)name);
            this.x$1 = tuple23;
            this.filename = (String)this.x$1._1();
            this.name = (String)this.x$1._2();
            int n = this.filename().lastIndexOf(46);
            Tuple2 tuple24 = tuple2 = n > 0 ? new Tuple2((Object)this.filename().substring(0, n), (Object)this.filename().substring(n)) : new Tuple2((Object)this.filename(), (Object)"");
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String filenamePrefix = (String)tuple2._1();
            String filenameSuffix = (String)tuple2._2();
            Tuple2 tuple25 = new Tuple2((Object)filenamePrefix, (Object)filenameSuffix);
            this.x$2 = tuple25;
            this.filenamePrefix = (String)this.x$2._1();
            this.filenameSuffix = (String)this.x$2._2();
            this.stream = null;
            this.openTime = 0L;
            this.nextRollTime = None$.MODULE$;
            this.bytesWrittenToFile = 0L;
            Policy policy = rollPolicy;
            if (policy instanceof Policy.MaxSize) {
                Policy.MaxSize maxSize = (Policy.MaxSize)policy;
                StorageUnit size = maxSize.size();
                none$ = new Some((Object)size);
            } else {
                none$ = None$.MODULE$;
            }
            this.maxFileSize = none$;
            this.openLog();
            this.examineRollTime = this.nextRollTime().isDefined();
            Policy policy2 = rollPolicy;
            Policy$SigHup$ policy$SigHup$ = Policy$SigHup$.MODULE$;
            if (policy2 != null ? !policy2.equals(policy$SigHup$) : policy$SigHup$ != null) break block4;
            HandleSignal$.MODULE$.apply("HUP", (Function1 & Serializable & scala.Serializable)signal -> {
                FileHandler.$anonfun$new$1(this, signal);
                return BoxedUnit.UNIT;
            });
        }
    }
}

