/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats;

import com.twitter.finagle.stats.CumulativeGauge;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.StatsReceiverWithCumulativeGauges;
import com.twitter.finagle.stats.StatsReceiverWithCumulativeGauges$;
import com.twitter.util.lint.Category;
import com.twitter.util.lint.Issue;
import com.twitter.util.lint.Rule;
import com.twitter.util.lint.Rule$;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class StatsReceiverWithCumulativeGauges$class {
    public static Rule largeGaugeLinterRule(StatsReceiverWithCumulativeGauges $this) {
        return Rule$.MODULE$.apply((Category)Category.Performance$.MODULE$, "Large CumulativeGauges", new StringBuilder().append((Object)"Identifies CumulativeGauges which are backed by very large numbers (100k+) of Gauges. Indicative of a leak or code registering the same gauge more ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"often than expected. (For ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()}))).toString(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsReceiverWithCumulativeGauges $outer;

            public final Seq<Issue> apply() {
                Map largeCgs = (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter((ConcurrentMap)this.$outer.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges()).asScala()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Tuple2<Seq<String>, Object>> apply(Tuple2<Seq<String>, CumulativeGauge> x0$1) {
                        Tuple2<Seq<String>, CumulativeGauge> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Seq ks = (Seq)tuple2._1();
                            CumulativeGauge cg = (CumulativeGauge)tuple2._2();
                            Iterable iterable = cg.totalSize() >= 100000 ? Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ks), (Object)BoxesRunTime.boxToInteger((int)cg.totalSize())))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                            return iterable;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom());
                return largeCgs.isEmpty() ? Nil$.MODULE$ : ((TraversableOnce)largeCgs.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Issue apply(Tuple2<Seq<String>, Object> x0$2) {
                        Tuple2<Seq<String>, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Seq ks = (Seq)tuple2._1();
                            int size = tuple2._2$mcI$sp();
                            Issue issue = new Issue(new StringBuilder().append((Object)ks.mkString("/")).append((Object)"=").append((Object)BoxesRunTime.boxToInteger((int)size)).toString());
                            return issue;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Gauge addGauge(StatsReceiverWithCumulativeGauges $this, Seq name, Function0 f) {
        CumulativeGauge cumulativeGauge = (CumulativeGauge)$this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges().get(name);
        if (cumulativeGauge == null) {
            CumulativeGauge insert = new CumulativeGauge($this, name){
                private final /* synthetic */ StatsReceiverWithCumulativeGauges $outer;
                private final Seq name$1;

                public synchronized void register() {
                    this.$outer.registerGauge((Seq<String>)this.name$1, (Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ StatsReceiverWithCumulativeGauges$.anon.1 $outer;

                        public final float apply() {
                            return this.apply$mcF$sp();
                        }

                        public float apply$mcF$sp() {
                            return this.$outer.getValue();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public synchronized void deregister() {
                    this.$outer.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges().remove(this.name$1);
                    this.$outer.deregisterGauge((Seq<String>)this.name$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.name$1 = name$1;
                }
            };
            CumulativeGauge prev = $this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges().putIfAbsent(name, insert);
            cumulativeGauge = prev == null ? insert : prev;
        }
        return cumulativeGauge.addGauge((Function0<Object>)f);
    }

    public static int numUnderlying(StatsReceiverWithCumulativeGauges $this, Seq name) {
        CumulativeGauge cumulativeGauge = (CumulativeGauge)$this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges().get(name);
        return cumulativeGauge == null ? 0 : cumulativeGauge.size();
    }

    public static void $init$(StatsReceiverWithCumulativeGauges $this) {
        $this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$_setter_$com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges_$eq(new ConcurrentHashMap());
    }
}

