/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats.exp;

import com.twitter.finagle.stats.HistogramFormatter$;
import com.twitter.finagle.stats.MetricUnit;
import com.twitter.finagle.stats.Unspecified$;
import com.twitter.finagle.stats.exp.Bounds;
import com.twitter.finagle.stats.exp.Expression;
import com.twitter.finagle.stats.exp.ExpressionSchema;
import com.twitter.finagle.stats.exp.HistogramComponent;
import com.twitter.finagle.stats.exp.HistogramComponent$Avg$;
import com.twitter.finagle.stats.exp.HistogramComponent$Count$;
import com.twitter.finagle.stats.exp.HistogramComponent$Max$;
import com.twitter.finagle.stats.exp.HistogramComponent$Min$;
import com.twitter.finagle.stats.exp.HistogramComponent$Sum$;
import com.twitter.finagle.stats.exp.HistogramExpression;
import com.twitter.finagle.stats.exp.Unbounded;
import com.twitter.finagle.stats.exp.Unbounded$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;

public final class ExpressionSchema$
implements Serializable {
    public static ExpressionSchema$ MODULE$;
    private final String Role;
    private final String ServiceName;
    private final String ProcessPath;

    static {
        new ExpressionSchema$();
    }

    public String Role() {
        return this.Role;
    }

    public String ServiceName() {
        return this.ServiceName;
    }

    public String ProcessPath() {
        return this.ProcessPath;
    }

    public ExpressionSchema apply(String name, Expression expr) {
        Map<String, String> map;
        Expression expression = expr;
        if (expression instanceof HistogramExpression) {
            HistogramExpression histogramExpression = (HistogramExpression)expression;
            map = this.histogramLabel(histogramExpression);
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        Map<String, String> preLabels = map;
        String x$1 = name;
        Map<String, String> x$2 = preLabels;
        Seq x$3 = (Seq)Nil$.MODULE$;
        Expression x$4 = expr;
        Unbounded x$5 = Unbounded$.MODULE$.get();
        String x$6 = "Unspecified";
        Unspecified$ x$7 = Unspecified$.MODULE$;
        String x$8 = "";
        return this.apply(x$1, x$2, x$4, (Seq<String>)x$3, x$5, x$6, x$7, x$8);
    }

    private Map<String, String> histogramLabel(HistogramExpression histoExpr) {
        String string;
        HistogramComponent histogramComponent = histoExpr.component();
        if (histogramComponent instanceof HistogramComponent.Percentile) {
            HistogramComponent.Percentile percentile = (HistogramComponent.Percentile)histogramComponent;
            double percentile2 = percentile.percentile();
            string = HistogramFormatter$.MODULE$.labelPercentile(percentile2);
        } else if (HistogramComponent$Min$.MODULE$.equals(histogramComponent)) {
            string = HistogramFormatter$.MODULE$.labelMin();
        } else if (HistogramComponent$Max$.MODULE$.equals(histogramComponent)) {
            string = HistogramFormatter$.MODULE$.labelMax();
        } else if (HistogramComponent$Avg$.MODULE$.equals(histogramComponent)) {
            string = HistogramFormatter$.MODULE$.labelAverage();
        } else if (HistogramComponent$Sum$.MODULE$.equals(histogramComponent)) {
            string = HistogramFormatter$.MODULE$.labelSum();
        } else if (HistogramComponent$Count$.MODULE$.equals(histogramComponent)) {
            string = HistogramFormatter$.MODULE$.labelCount();
        } else {
            throw new MatchError((Object)histogramComponent);
        }
        String value = string;
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bucket"), (Object)value)}));
    }

    public ExpressionSchema apply(String name, Map<String, String> labels, Expression expr, Seq<String> namespace, Bounds bounds, String description, MetricUnit unit, String exprQuery) {
        return new ExpressionSchema(name, labels, expr, namespace, bounds, description, unit, exprQuery);
    }

    public Option<Tuple8<String, Map<String, String>, Expression, Seq<String>, Bounds, String, MetricUnit, String>> unapply(ExpressionSchema x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.name(), x$0.labels(), (Object)x$0.expr(), x$0.namespace(), (Object)x$0.bounds(), (Object)x$0.description(), (Object)x$0.unit(), (Object)x$0.exprQuery()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ExpressionSchema$() {
        MODULE$ = this;
        this.Role = "role";
        this.ServiceName = "service_name";
        this.ProcessPath = "process_path";
    }
}

