/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.tunable;

import com.twitter.util.tunable.NullTunableMap$;
import com.twitter.util.tunable.Tunable;
import com.twitter.util.tunable.Tunable$;
import com.twitter.util.tunable.TunableMap;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.runtime.LambdaDeserialize;

public final class TunableMap$ {
    public static TunableMap$ MODULE$;

    static {
        new TunableMap$();
    }

    public TunableMap of(TunableMap ... tunableMaps) {
        return this.of((Seq<TunableMap>)Predef$.MODULE$.wrapRefArray((Object[])tunableMaps));
    }

    public Seq<TunableMap> components(TunableMap tunableMap2) {
        Seq seq;
        TunableMap tunableMap3 = tunableMap2;
        if (tunableMap3 instanceof TunableMap.Composite) {
            TunableMap tunableMap4 = tunableMap3;
            seq = (Seq)((TunableMap.Composite)((Object)tunableMap4)).components().flatMap((Function1 & Serializable & scala.Serializable)tunableMap -> this.components((TunableMap)tunableMap), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TunableMap[]{tunableMap2}));
        }
        return seq;
    }

    public TunableMap of(Seq<TunableMap> tunableMaps) {
        NullTunableMap$ start = NullTunableMap$.MODULE$;
        return (TunableMap)tunableMaps.foldLeft((Object)start, (Function2 & Serializable & scala.Serializable)(x0$4, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TunableMap acc = (TunableMap)tuple2._1();
            TunableMap tm = (TunableMap)tuple2._2();
            TunableMap tunableMap = acc.orElse(tm);
            return tunableMap;
        });
    }

    public TunableMap.Mutable newMutable(String source) {
        return this.newMutable((Option<String>)new Some((Object)source));
    }

    public TunableMap.Mutable newMutable() {
        return this.newMutable((Option<String>)None$.MODULE$);
    }

    private TunableMap.Mutable newMutable(Option<String> source) {
        return new TunableMap.Mutable(source){
            private final ConcurrentHashMap<String, TunableMap.TypeAndTunable<?>> tunables;
            private final Option source$1;

            public String toString() {
                String string;
                Option option = this.source$1;
                if (option instanceof Some) {
                    String src;
                    Some some = (Some)option;
                    string = src = (String)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TunableMap.Mutable@", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Integer.toHexString(this.hashCode())}));
                } else {
                    throw new MatchError((Object)option);
                }
                return string;
            }

            private <T> BiFunction<String, TunableMap.TypeAndTunable<?>, TunableMap.TypeAndTunable<?>> clearTunable(TunableMap.Key<T> key) {
                return new BiFunction<String, TunableMap.TypeAndTunable<?>, TunableMap.TypeAndTunable<?>>(null){

                    public <V> BiFunction<String, TunableMap.TypeAndTunable<?>, V> andThen(Function<? super TunableMap.TypeAndTunable<?>, ? extends V> x$1) {
                        return BiFunction.super.andThen(x$1);
                    }

                    public TunableMap.TypeAndTunable<?> apply(String id, TunableMap.TypeAndTunable<?> curr) {
                        block0: {
                            if (curr == null) break block0;
                            curr.tunable().clear();
                        }
                        return curr;
                    }
                };
            }

            private <T> BiFunction<String, TunableMap.TypeAndTunable<?>, TunableMap.TypeAndTunable<?>> getOrAdd(TunableMap.Key<T> key) {
                return new BiFunction<String, TunableMap.TypeAndTunable<?>, TunableMap.TypeAndTunable<?>>(null, key){
                    private final TunableMap.Key key$1;

                    public <V> BiFunction<String, TunableMap.TypeAndTunable<?>, V> andThen(Function<? super TunableMap.TypeAndTunable<?>, ? extends V> x$1) {
                        return BiFunction.super.andThen(x$1);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public TunableMap.TypeAndTunable<?> apply(String id, TunableMap.TypeAndTunable<?> curr) {
                        TunableMap.TypeAndTunable<?> typeAndTunable;
                        if (curr != null) {
                            if (!this.key$1.clazz().isAssignableFrom(curr.tunableType())) throw new ClassCastException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to retrieve a Tunable of type ", ", but TunableMap contained a "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1.clazz()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tunable of type ", " for id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{curr.tunableType(), this.key$1.id()})));
                            typeAndTunable = curr;
                            return typeAndTunable;
                        } else {
                            typeAndTunable = new TunableMap.TypeAndTunable<?>(this.key$1.clazz(), Tunable$.MODULE$.emptyMutable(this.key$1.id()));
                        }
                        return typeAndTunable;
                    }
                    {
                        this.key$1 = key$1;
                    }
                };
            }

            private <T> BiFunction<String, TunableMap.TypeAndTunable<?>, TunableMap.TypeAndTunable<?>> updateOrAdd(TunableMap.Key<T> key, T value) {
                return new BiFunction<String, TunableMap.TypeAndTunable<?>, TunableMap.TypeAndTunable<?>>(null, key, value){
                    private final TunableMap.Key key$2;
                    private final Object value$1;

                    public <V> BiFunction<String, TunableMap.TypeAndTunable<?>, V> andThen(Function<? super TunableMap.TypeAndTunable<?>, ? extends V> x$1) {
                        return BiFunction.super.andThen(x$1);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public TunableMap.TypeAndTunable<?> apply(String id, TunableMap.TypeAndTunable<?> curr) {
                        TunableMap.TypeAndTunable<Object> typeAndTunable;
                        if (curr != null) {
                            Class<?> clazz = curr.tunableType();
                            Class<T> clazz2 = this.key$2.clazz();
                            if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) throw new ClassCastException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to update a Tunable of type ", ", but TunableMap contained a "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$2.clazz()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tunable of type ", " for id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{curr.tunableType(), this.key$2.id()})));
                            curr.tunable().set(this.value$1);
                            typeAndTunable = curr;
                            return typeAndTunable;
                        } else {
                            typeAndTunable = new TunableMap.TypeAndTunable<Object>(this.key$2.clazz(), Tunable$.MODULE$.mutable(id, this.value$1));
                        }
                        return typeAndTunable;
                    }
                    {
                        this.key$2 = key$2;
                        this.value$1 = value$1;
                    }
                };
            }

            public <T> TunableMap.Key<T> put(String id, Class<T> clazz, T value) {
                TunableMap.Key<T> key = new TunableMap.Key<T>(id, clazz);
                this.tunables.compute(id, this.updateOrAdd(key, value));
                return key;
            }

            public <T> void clear(TunableMap.Key<T> key) {
                this.tunables.computeIfPresent(key.id(), this.clearTunable(key));
            }

            public <T> Tunable<T> apply(TunableMap.Key<T> key) {
                return this.tunables.compute(key.id(), this.getOrAdd(key)).tunable();
            }

            public Iterator<TunableMap.Entry<?>> entries() {
                Iterator entryOpts = ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.tunables).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)x0$7 -> {
                    TunableMap.TypeAndTunable typeAndTunable;
                    String id;
                    block3: {
                        Tuple2 tuple2;
                        block2: {
                            tuple2 = x0$7;
                            if (tuple2 == null) break block2;
                            id = (String)tuple2._1();
                            typeAndTunable = (TunableMap.TypeAndTunable)tuple2._2();
                            if (typeAndTunable instanceof TunableMap.TypeAndTunable) break block3;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    TunableMap.TypeAndTunable typeAndTunable2 = typeAndTunable;
                    Class<T> tunableType = typeAndTunable2.tunableType();
                    Tunable.Mutable<T> tunable = typeAndTunable2.tunable();
                    Option option = tunable.apply().map((Function1 & Serializable & scala.Serializable)value -> new TunableMap.Entry<Object>(new TunableMap.Key<T>(id, tunableType), value, this.toString()));
                    return option;
                });
                return TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)entryOpts, (Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)).flatten();
            }
            {
                this.source$1 = source$1;
                this.tunables = new ConcurrentHashMap<K, V>();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$entries$3(com.twitter.util.tunable.TunableMap$$anon$2 scala.Tuple2 ), $anonfun$entries$5(scala.Option ), $anonfun$entries$4(com.twitter.util.tunable.TunableMap$$anon$2 java.lang.String java.lang.Class java.lang.Object )}, serializedLambda);
            }
        };
    }

    private TunableMap$() {
        MODULE$ = this;
    }
}

