/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.validation.internal.validators.size;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.Size;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005A4Qa\u0002\u0005\u0001\u001dYAQ\u0001\u0013\u0001\u0005\u0002%C\u0011\u0002\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B'\t\u0013Q\u0003\u0001\u0019!A!B\u0013i\u0005\"\u0002,\u0001\t\u0003:\u0006\"B/\u0001\t\u0003r\u0006\"\u00028\u0001\t\u0013y'\u0001G*ju\u00164\u0016\r\\5eCR|'OR8s\u0013R,'/\u00192mK*\u0011\u0011BC\u0001\u0005g&TXM\u0003\u0002\f\u0019\u0005Qa/\u00197jI\u0006$xN]:\u000b\u00055q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005=\u0001\u0012A\u0003<bY&$\u0017\r^5p]*\u0011\u0011CE\u0001\u0005kRLGN\u0003\u0002\u0014)\u00059Ao^5ui\u0016\u0014(\"A\u000b\u0002\u0007\r|WnE\u0002\u0001/}\u0001\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\t1\fgn\u001a\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0004PE*,7\r\u001e\t\u0005A\u00112C&D\u0001\"\u0015\ty!EC\u0001$\u0003\u001dQ\u0017m[1si\u0006L!!J\u0011\u0003'\r{gn\u001d;sC&tGOV1mS\u0012\fGo\u001c:\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%\n\u0013aC2p]N$(/Y5oiNL!a\u000b\u0015\u0003\tMK'0\u001a\u0019\u0003[y\u00022AL\u001d=\u001d\tycG\u0004\u00021i5\t\u0011G\u0003\u00023g\u00051AH]8piz\u001a\u0001!C\u00016\u0003\u0015\u00198-\u00197b\u0013\t9\u0004(A\u0004qC\u000e\\\u0017mZ3\u000b\u0003UJ!AO\u001e\u0003\u0011%#XM]1cY\u0016T!a\u000e\u001d\u0011\u0005urD\u0002\u0001\u0003\n\u007f\u0001\t\t\u0011!A\u0003\u0002\u0001\u00131a\u0018\u00132#\t\tU\t\u0005\u0002C\u00076\t\u0001(\u0003\u0002Eq\t9aj\u001c;iS:<\u0007C\u0001\"G\u0013\t9\u0005HA\u0002B]f\fa\u0001P5oSRtD#\u0001&\u0011\u0005-\u0003Q\"\u0001\u0005\u0002\u00075Lg\u000e\u0005\u0002C\u001d&\u0011q\n\u000f\u0002\u0004\u0013:$\bF\u0001\u0002R!\t\u0011%+\u0003\u0002Tq\tAao\u001c7bi&dW-A\u0002nCbD#aA)\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0002Y7B\u0011!)W\u0005\u00035b\u0012A!\u00168ji\")A\f\u0002a\u0001M\u0005!2m\u001c8tiJ\f\u0017N\u001c;B]:|G/\u0019;j_:\fq![:WC2LG\rF\u0002`E&\u0004\"A\u00111\n\u0005\u0005D$a\u0002\"p_2,\u0017M\u001c\u0005\u0006G\u0016\u0001\r\u0001Z\u0001\u0004_\nT\u0007GA3h!\rq\u0013H\u001a\t\u0003{\u001d$\u0011\u0002\u001b2\u0002\u0002\u0003\u0005)\u0011\u0001!\u0003\u0007}##\u0007C\u0003k\u000b\u0001\u00071.\u0001\u000ed_:\u001cHO]1j]R4\u0016\r\\5eCR|'oQ8oi\u0016DH\u000f\u0005\u0002!Y&\u0011Q.\t\u0002\u001b\u0007>t7\u000f\u001e:bS:$h+\u00197jI\u0006$xN]\"p]R,\u0007\u0010^\u0001\u0013m\u0006d\u0017\u000eZ1uKB\u000b'/Y7fi\u0016\u00148\u000fF\u0001Y\u0001")
public class SizeValidatorForIterable
implements ConstraintValidator<Size, Iterable<?>> {
    private volatile int min;
    private volatile int max;

    public void initialize(Size constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
        this.validateParameters();
    }

    public boolean isValid(Iterable<?> obj, ConstraintValidatorContext constraintValidatorContext) {
        return obj == null ? true : obj.size() >= this.min && obj.size() <= this.max;
    }

    private void validateParameters() {
        if (this.min < 0) {
            throw new IllegalArgumentException("The min parameter cannot be negative.");
        }
        if (this.max < 0) {
            throw new IllegalArgumentException("The max parameter cannot be negative.");
        }
        if (this.max < this.min) {
            throw new IllegalArgumentException("The length cannot be negative.");
        }
    }
}

