/*
 * Decompiled with CFR 0.152.
 */
package com.twofortyfouram.assertion;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.twofortyfouram.assertion.Assertions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class BundleAssertions {
    public static void assertHasKey(@NonNull Bundle bundle, @Nullable String requiredKey) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        if (!bundle.containsKey(requiredKey)) {
            String message = BundleAssertions.formatMessage("Required extra %s is missing", requiredKey);
            throw new AssertionError((Object)message);
        }
    }

    @RequiresApi(value=21)
    public static void assertHasKey(@NonNull PersistableBundle bundle, @Nullable String requiredKey) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        if (!bundle.containsKey(requiredKey)) {
            String message = BundleAssertions.formatMessage("Required extra %s is missing", requiredKey);
            throw new AssertionError((Object)message);
        }
    }

    public static void assertHasBoolean(@NonNull Bundle bundle, @Nullable String requiredKey) throws AssertionError {
        BundleAssertions.assertHasKey(bundle, requiredKey);
        if (bundle.getBoolean(requiredKey, true) != bundle.getBoolean(requiredKey, false)) {
            String message = BundleAssertions.formatMessage("Extra %s appears to be the wrong type.  It must be a boolean", requiredKey);
            throw new AssertionError((Object)message);
        }
    }

    public static void assertHasByteArray(@NonNull Bundle bundle, @Nullable String requiredKey) throws AssertionError {
        BundleAssertions.assertHasKey(bundle, requiredKey);
        if (null == bundle.getByteArray(requiredKey)) {
            String message = BundleAssertions.formatMessage("Extra %s appears to be the wrong type or null.  It must be a byte[]", requiredKey);
            throw new AssertionError((Object)message);
        }
    }

    public static void assertHasStringArray(@NonNull Bundle bundle, @Nullable String requiredKey) throws AssertionError {
        BundleAssertions.assertHasKey(bundle, requiredKey);
        if (null == bundle.getStringArray(requiredKey)) {
            String message = BundleAssertions.formatMessage("Extra %s appears to be the wrong type or null.  It must be a String[]", requiredKey);
            throw new AssertionError((Object)message);
        }
    }

    public static void assertHasInt(@NonNull Bundle bundle, @Nullable String requiredKey) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        BundleAssertions.assertHasKey(bundle, requiredKey);
        if (bundle.getInt(requiredKey, Integer.MIN_VALUE) != bundle.getInt(requiredKey, Integer.MAX_VALUE)) {
            String message = BundleAssertions.formatMessage("Extra %s appears to be the wrong type.  It must be an int", requiredKey);
            throw new AssertionError((Object)message);
        }
    }

    public static void assertHasInt(@NonNull Bundle bundle, @Nullable String requiredKey, int lowerBound, int upperBound) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException("upperBound is not >= lowerBound");
        }
        BundleAssertions.assertHasInt(bundle, requiredKey);
        int value = bundle.getInt(requiredKey);
        Assertions.assertInRangeInclusive(value, lowerBound, upperBound, requiredKey);
    }

    public static void assertHasLong(@NonNull Bundle bundle, @Nullable String requiredKey) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        BundleAssertions.assertHasKey(bundle, requiredKey);
        if (bundle.getLong(requiredKey, Long.MIN_VALUE) != bundle.getLong(requiredKey, Long.MAX_VALUE)) {
            String message = BundleAssertions.formatMessage("Extra %s appears to be the wrong type.  It must be a long", requiredKey);
            throw new AssertionError((Object)message);
        }
    }

    public static void assertHasLong(@NonNull Bundle bundle, @Nullable String requiredKey, long lowerBound, long upperBound) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException("upperBound is not >= lowerBound");
        }
        BundleAssertions.assertHasLong(bundle, requiredKey);
        long value = bundle.getLong(requiredKey);
        Assertions.assertInRangeInclusive(value, lowerBound, upperBound, requiredKey);
    }

    @SuppressLint(value={"NewApi"})
    public static void assertHasParcelable(@NonNull Bundle bundle, @Nullable String requiredKey, @NonNull Class<? extends Parcelable> expectedClass) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        Assertions.assertNotNull(expectedClass, "expectedClass");
        BundleAssertions.assertHasKey(bundle, requiredKey);
        Parcelable p = bundle.getParcelable(requiredKey);
        if (null == p) {
            throw new AssertionError((Object)BundleAssertions.formatMessage("Extra %s is not Parcelable", requiredKey));
        }
        if (p.getClass() != expectedClass) {
            throw new AssertionError((Object)BundleAssertions.formatMessage("Extra %s is not an instance of %s", requiredKey, expectedClass.getName()));
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void assertHasString(@NonNull Bundle bundle, @Nullable String requiredKey) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        BundleAssertions.assertHasKey(bundle, requiredKey);
        if (Build.VERSION.SDK_INT >= 12 && null != bundle.get(requiredKey) && "foo".equals(bundle.getString(requiredKey, "foo")) && "bar".equals(bundle.getString(requiredKey, "bar"))) {
            String message = BundleAssertions.formatMessage("Extra %s is the wrong type", requiredKey);
            throw new AssertionError((Object)message);
        }
    }

    public static void assertHasString(@NonNull Bundle bundle, @Nullable String requiredKey, String ... allowedValues) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        BundleAssertions.assertHasString(bundle, requiredKey);
        if (null != allowedValues) {
            boolean isOk = false;
            String value = bundle.getString(requiredKey);
            for (String allowedValue : allowedValues) {
                if (null == value) {
                    if (null != allowedValue) continue;
                    isOk = true;
                    break;
                }
                if (!value.equals(allowedValue)) continue;
                isOk = true;
                break;
            }
            if (!isOk) {
                String message = BundleAssertions.formatMessage("Extra %s=%s is not in the set %s", requiredKey, value, Arrays.toString(allowedValues));
                throw new AssertionError((Object)message);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void assertHasString(@NonNull Bundle bundle, @Nullable String requiredKey, boolean isNullAllowed, boolean isEmptyStringAllowed) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        BundleAssertions.assertHasString(bundle, requiredKey);
        String value = bundle.getString(requiredKey);
        if (!isNullAllowed && null == value) {
            throw new AssertionError((Object)BundleAssertions.formatMessage("%s cannot map to null", requiredKey));
        }
        if (!isEmptyStringAllowed && null != value && 0 == value.length()) {
            throw new AssertionError((Object)BundleAssertions.formatMessage("%s cannot map to empty string", requiredKey));
        }
    }

    public static void assertKeyCount(@NonNull Bundle bundle, int expectedCount) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        Assertions.assertInRangeInclusive(expectedCount, 0, Integer.MAX_VALUE, "expectedCount");
        if (expectedCount != bundle.keySet().size()) {
            String message = BundleAssertions.formatMessage("bundle must contain %d keys, but currently contains %d keys: %s", expectedCount, bundle.keySet().size(), bundle.keySet().toString());
            throw new AssertionError((Object)message);
        }
    }

    @RequiresApi(value=21)
    public static void assertKeyCount(@NonNull PersistableBundle bundle, int expectedCount) throws AssertionError {
        Assertions.assertNotNull(bundle, "bundle");
        Assertions.assertInRangeInclusive(expectedCount, 0, Integer.MAX_VALUE, "expectedCount");
        if (expectedCount != bundle.keySet().size()) {
            String message = BundleAssertions.formatMessage("bundle must contain %d keys, but currently contains %d keys: %s", expectedCount, bundle.keySet().size(), bundle.keySet().toString());
            throw new AssertionError((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertSerializable(@NonNull Bundle bundle) {
        Assertions.assertNotNull(bundle, "bundle");
        ObjectOutputStream objectOut = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            try {
                objectOut = new ObjectOutputStream(byteOut);
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
            for (String key : bundle.keySet()) {
                Object value = bundle.get(key);
                if (value instanceof Bundle) {
                    BundleAssertions.assertSerializable((Bundle)value);
                    continue;
                }
                if (value instanceof Serializable) {
                    try {
                        ClassLoader.getSystemClassLoader().loadClass(value.getClass().getName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new AssertionError((Object)BundleAssertions.formatMessage("Object associated with key %s is not available to the Android ClassLoader", key));
                    }
                    try {
                        objectOut.writeObject(bundle.get(key));
                        continue;
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)BundleAssertions.formatMessage("Object associated with key %s couldn't be serialized", key));
                    }
                }
                if (null != value) {
                    throw new AssertionError((Object)BundleAssertions.formatMessage("Key \"%s\"'s value %s isn't Serializable.  Only primitives or objects implementing Serializable can be stored.  Parcelable is not stable for long-term storage.", key, bundle.get(key)));
                }
            }
        }
        finally {
            if (null != objectOut) {
                try {
                    objectOut.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Internal failure");
                }
            }
        }
    }

    @NonNull
    private static String formatMessage(@NonNull String msg, Object ... args) {
        return String.format(Locale.US, msg, args);
    }

    private BundleAssertions() {
        throw new UnsupportedOperationException("This class is non-instantiable");
    }
}

