/*
 * Decompiled with CFR 0.152.
 */
package com.twofortyfouram.assertion;

import android.database.Cursor;
import android.support.annotation.NonNull;
import com.twofortyfouram.assertion.Assertions;
import java.util.Locale;
import net.jcip.annotations.Immutable;

@Immutable
public final class CursorAssertions {
    public static void assertCursorPositionValid(@NonNull Cursor cursor) {
        Assertions.assertNotNull(cursor, "cursor");
        if (cursor.isBeforeFirst() || cursor.isAfterLast()) {
            throw new AssertionError((Object)String.format(Locale.US, "Cursor is at position %d", cursor.getPosition()));
        }
    }

    public static void assertCursorOpen(@NonNull Cursor cursor) {
        Assertions.assertNotNull(cursor, "cursor");
        if (cursor.isClosed()) {
            throw new AssertionError((Object)"Cursor is closed");
        }
    }

    private CursorAssertions() {
        throw new UnsupportedOperationException("This class is non-instantiable");
    }
}

