/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.clone;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.clone.ArrayTable;
import org.apache.calcite.adapter.clone.ColumnLoader;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.MaterializedViewTable;

public class CloneSchema
extends AbstractSchema {
    private final SchemaPlus sourceSchema;

    public CloneSchema(SchemaPlus sourceSchema) {
        this.sourceSchema = sourceSchema;
    }

    @Override
    protected Map<String, Table> getTableMap() {
        LinkedHashMap<String, Table> map = new LinkedHashMap<String, Table>();
        for (String name : this.sourceSchema.getTableNames()) {
            Table table = this.sourceSchema.getTable(name);
            if (!(table instanceof QueryableTable)) continue;
            QueryableTable sourceTable = (QueryableTable)table;
            map.put(name, this.createCloneTable(MaterializedViewTable.MATERIALIZATION_CONNECTION, sourceTable, name));
        }
        return map;
    }

    private Table createCloneTable(QueryProvider queryProvider, QueryableTable sourceTable, String name) {
        Queryable queryable = sourceTable.asQueryable(queryProvider, this.sourceSchema, name);
        JavaTypeFactory typeFactory = ((CalciteConnection)queryProvider).getTypeFactory();
        return CloneSchema.createCloneTable(typeFactory, Schemas.proto(sourceTable), (List<RelCollation>)ImmutableList.of(), null, queryable);
    }

    @Deprecated
    public static <T> Table createCloneTable(JavaTypeFactory typeFactory, RelProtoDataType protoRowType, List<ColumnMetaData.Rep> repList, Enumerable<T> source) {
        return CloneSchema.createCloneTable(typeFactory, protoRowType, (List<RelCollation>)ImmutableList.of(), repList, source);
    }

    public static <T> Table createCloneTable(JavaTypeFactory typeFactory, RelProtoDataType protoRowType, List<RelCollation> collations, List<ColumnMetaData.Rep> repList, Enumerable<T> source) {
        Type elementType = source instanceof QueryableTable ? ((QueryableTable)((Object)source)).getElementType() : (((RelDataType)protoRowType.apply(typeFactory)).getFieldCount() == 1 ? (repList != null ? repList.get((int)0).clazz : Object.class) : Object[].class);
        return new ArrayTable(elementType, protoRowType, (Supplier<ArrayTable.Content>)Suppliers.memoize(() -> {
            ColumnLoader loader = new ColumnLoader(typeFactory, source, protoRowType, repList);
            List<RelCollation> collation2 = collations.isEmpty() && loader.sortField >= 0 ? RelCollations.createSingleton(loader.sortField) : collations;
            return new ArrayTable.Content(loader.representationValues, loader.size(), collation2);
        }));
    }

    public static class Factory
    implements SchemaFactory {
        @Override
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            SchemaPlus schema = parentSchema.add(name, JdbcSchema.create(parentSchema, name + "$source", operand));
            return new CloneSchema(schema);
        }
    }
}

