/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ConstantUntypedNull;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SemiJoinType;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;

public class EnumUtils {
    static final boolean BRIDGE_METHODS = true;
    static final List<ParameterExpression> NO_PARAMS = ImmutableList.of();
    static final List<Expression> NO_EXPRS = ImmutableList.of();
    public static final List<String> LEFT_RIGHT = ImmutableList.of((Object)"left", (Object)"right");

    private EnumUtils() {
    }

    public static MethodDeclaration overridingMethodDecl(Method method, Iterable<ParameterExpression> parameters, BlockStatement body) {
        return Expressions.methodDecl(method.getModifiers() & 0xFFFFFBFF, method.getReturnType(), method.getName(), parameters, body);
    }

    static Type javaClass(JavaTypeFactory typeFactory, RelDataType type) {
        Type clazz = typeFactory.getJavaClass(type);
        return clazz instanceof Class ? clazz : Object[].class;
    }

    static Class javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
        Type clazz;
        if (type.isStruct() && type.getFieldCount() == 1) {
            type = type.getFieldList().get(0).getType();
        }
        return (clazz = typeFactory.getJavaClass(type)) instanceof Class ? (Class)clazz : Object[].class;
    }

    static List<Type> fieldTypes(final JavaTypeFactory typeFactory, final List<? extends RelDataType> inputTypes) {
        return new AbstractList<Type>(){

            @Override
            public Type get(int index) {
                return EnumUtils.javaClass(typeFactory, (RelDataType)inputTypes.get(index));
            }

            @Override
            public int size() {
                return inputTypes.size();
            }
        };
    }

    static List<RelDataType> fieldRowTypes(RelDataType inputRowType, final List<? extends RexNode> extraInputs, final List<Integer> argList) {
        final List<RelDataTypeField> inputFields = inputRowType.getFieldList();
        return new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                int arg = (Integer)argList.get(index);
                return arg < inputFields.size() ? ((RelDataTypeField)inputFields.get(arg)).getType() : ((RexNode)extraInputs.get(arg - inputFields.size())).getType();
            }

            @Override
            public int size() {
                return argList.size();
            }
        };
    }

    static Expression joinSelector(SemiJoinType semiJoinType, PhysType physType, List<PhysType> inputPhysTypes) {
        JoinRelType joinRelType = semiJoinType.returnsJustFirstInput() ? JoinRelType.INNER : semiJoinType.toJoinType();
        return EnumUtils.joinSelector(joinRelType, physType, inputPhysTypes);
    }

    static Expression joinSelector(JoinRelType joinType, PhysType physType, List<PhysType> inputPhysTypes) {
        ArrayList<ParameterExpression> parameters = new ArrayList<ParameterExpression>();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int outputFieldCount = physType.getRowType().getFieldCount();
        for (Ord<PhysType> ord : Ord.zip(inputPhysTypes)) {
            PhysType inputPhysType = ((PhysType)ord.e).makeNullable(joinType.generatesNullsOn(ord.i));
            ParameterExpression parameter = Expressions.parameter(Primitive.box(inputPhysType.getJavaRowType()), LEFT_RIGHT.get(ord.i));
            parameters.add(parameter);
            if (expressions.size() == outputFieldCount) break;
            int fieldCount = inputPhysType.getRowType().getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                Expression expression = inputPhysType.fieldReference(parameter, i, physType.getJavaFieldType(expressions.size()));
                if (joinType.generatesNullsOn(ord.i)) {
                    expression = Expressions.condition(Expressions.equal(parameter, Expressions.constant(null)), Expressions.constant(null), expression);
                }
                expressions.add(expression);
            }
        }
        return Expressions.lambda(Function2.class, physType.record(expressions), parameters);
    }

    static Expression fromInternal(Expression e, Class<?> targetType) {
        if (e == ConstantUntypedNull.INSTANCE) {
            return e;
        }
        if (!(e.getType() instanceof Class)) {
            return e;
        }
        if (targetType.isAssignableFrom((Class)e.getType())) {
            return e;
        }
        if (targetType == Date.class) {
            return Expressions.call(BuiltInMethod.INTERNAL_TO_DATE.method, e);
        }
        if (targetType == Time.class) {
            return Expressions.call(BuiltInMethod.INTERNAL_TO_TIME.method, e);
        }
        if (targetType == Timestamp.class) {
            return Expressions.call(BuiltInMethod.INTERNAL_TO_TIMESTAMP.method, e);
        }
        if (Primitive.is(e.type) && Primitive.isBox(targetType)) {
            return Expressions.convert_(e, Primitive.ofBox(targetType).primitiveClass);
        }
        return e;
    }

    static List<Expression> fromInternal(Class<?>[] targetTypes, List<Expression> expressions) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (int i = 0; i < expressions.size(); ++i) {
            list.add(EnumUtils.fromInternal(expressions.get(i), targetTypes[i]));
        }
        return list;
    }

    static Type fromInternal(Type type) {
        if (type == Date.class || type == Time.class) {
            return Integer.TYPE;
        }
        if (type == Timestamp.class) {
            return Long.TYPE;
        }
        return type;
    }

    static Type toInternal(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case DATE: 
            case TIME: {
                return type.isNullable() ? Integer.class : Integer.TYPE;
            }
            case TIMESTAMP: {
                return type.isNullable() ? Long.class : Long.TYPE;
            }
        }
        return null;
    }

    static List<Type> internalTypes(List<? extends RexNode> operandList) {
        return Util.transform(operandList, node -> EnumUtils.toInternal(node.getType()));
    }

    static Expression enforce(Type storageType, Expression e) {
        if (storageType != null && e.type != storageType) {
            if (e.type == Date.class) {
                if (storageType == Integer.TYPE) {
                    return Expressions.call(BuiltInMethod.DATE_TO_INT.method, e);
                }
                if (storageType == Integer.class) {
                    return Expressions.call(BuiltInMethod.DATE_TO_INT_OPTIONAL.method, e);
                }
            } else if (e.type == Time.class) {
                if (storageType == Integer.TYPE) {
                    return Expressions.call(BuiltInMethod.TIME_TO_INT.method, e);
                }
                if (storageType == Integer.class) {
                    return Expressions.call(BuiltInMethod.TIME_TO_INT_OPTIONAL.method, e);
                }
            } else if (e.type == Timestamp.class) {
                if (storageType == Long.TYPE) {
                    return Expressions.call(BuiltInMethod.TIMESTAMP_TO_LONG.method, e);
                }
                if (storageType == Long.class) {
                    return Expressions.call(BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL.method, e);
                }
            }
        }
        return e;
    }
}

