/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.advise;

import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.ImplementableFunction;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.advise.SqlAdvisorHint2;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.util.BuiltInMethod;

public class SqlAdvisorGetHintsFunction2
implements TableFunction,
ImplementableFunction {
    private static final Expression ADVISOR = Expressions.convert_(Expressions.call((Expression)DataContext.ROOT, BuiltInMethod.DATA_CONTEXT_GET.method, Expressions.constant(DataContext.Variable.SQL_ADVISOR.camelName)), SqlAdvisor.class);
    private static final Method GET_COMPLETION_HINTS = Types.lookupMethod(SqlAdvisorGetHintsFunction2.class, "getCompletionHints", SqlAdvisor.class, String.class, Integer.TYPE);
    private static final CallImplementor IMPLEMENTOR = RexImpTable.createImplementor((translator, call, operands) -> Expressions.call(GET_COMPLETION_HINTS, Iterables.concat(Collections.singleton(ADVISOR), (Iterable)operands)), NullPolicy.ANY, false);
    private static final List<FunctionParameter> PARAMETERS = ReflectiveFunctionBase.builder().add(String.class, "sql").add(Integer.TYPE, "pos").build();

    @Override
    public CallImplementor getImplementor() {
        return IMPLEMENTOR;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<Object> arguments) {
        return typeFactory.createJavaType(SqlAdvisorHint2.class);
    }

    @Override
    public Type getElementType(List<Object> arguments) {
        return SqlAdvisorHint2.class;
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return PARAMETERS;
    }

    public static Enumerable<SqlAdvisorHint2> getCompletionHints(SqlAdvisor advisor, String sql, int pos) {
        String[] replaced = new String[]{null};
        List<SqlMoniker> hints = advisor.getCompletionHints(sql, pos, replaced);
        ArrayList<SqlAdvisorHint2> res = new ArrayList<SqlAdvisorHint2>(hints.size() + 1);
        res.add(new SqlAdvisorHint2(replaced[0], null, "MATCH", null));
        String word = replaced[0];
        for (SqlMoniker hint : hints) {
            res.add(new SqlAdvisorHint2(hint, advisor.getReplacement(hint, word)));
        }
        return Linq4j.asEnumerable(res).asQueryable();
    }
}

