/*
 * Decompiled with CFR 0.152.
 */
package com.uber.autodispose.android.lifecycle;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import com.uber.autodispose.OutsideScopeException;
import com.uber.autodispose.android.lifecycle.LifecycleEventsObservable;
import com.uber.autodispose.lifecycle.CorrespondingEventsFunction;
import com.uber.autodispose.lifecycle.LifecycleEndedException;
import com.uber.autodispose.lifecycle.LifecycleScopeProvider;
import com.uber.autodispose.lifecycle.LifecycleScopes;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;

public final class AndroidLifecycleScopeProvider
implements LifecycleScopeProvider<Lifecycle.Event> {
    private static final CorrespondingEventsFunction<Lifecycle.Event> DEFAULT_CORRESPONDING_EVENTS = new CorrespondingEventsFunction<Lifecycle.Event>(){

        public Lifecycle.Event apply(Lifecycle.Event lastEvent) throws OutsideScopeException {
            switch (lastEvent) {
                case ON_CREATE: {
                    return Lifecycle.Event.ON_DESTROY;
                }
                case ON_START: {
                    return Lifecycle.Event.ON_STOP;
                }
                case ON_RESUME: {
                    return Lifecycle.Event.ON_PAUSE;
                }
                case ON_PAUSE: {
                    return Lifecycle.Event.ON_STOP;
                }
            }
            throw new LifecycleEndedException("Lifecycle has ended! Last event was " + lastEvent);
        }
    };
    private final CorrespondingEventsFunction<Lifecycle.Event> boundaryResolver;
    private final LifecycleEventsObservable lifecycleObservable;

    public static AndroidLifecycleScopeProvider from(LifecycleOwner owner) {
        return AndroidLifecycleScopeProvider.from(owner.getLifecycle());
    }

    public static AndroidLifecycleScopeProvider from(LifecycleOwner owner, Lifecycle.Event untilEvent) {
        return AndroidLifecycleScopeProvider.from(owner.getLifecycle(), untilEvent);
    }

    public static AndroidLifecycleScopeProvider from(Lifecycle lifecycle) {
        return AndroidLifecycleScopeProvider.from(lifecycle, DEFAULT_CORRESPONDING_EVENTS);
    }

    public static AndroidLifecycleScopeProvider from(Lifecycle lifecycle, Lifecycle.Event untilEvent) {
        return AndroidLifecycleScopeProvider.from(lifecycle, (CorrespondingEventsFunction<Lifecycle.Event>)new UntilEventFunction(untilEvent));
    }

    public static AndroidLifecycleScopeProvider from(LifecycleOwner owner, CorrespondingEventsFunction<Lifecycle.Event> boundaryResolver) {
        return AndroidLifecycleScopeProvider.from(owner.getLifecycle(), boundaryResolver);
    }

    public static AndroidLifecycleScopeProvider from(Lifecycle lifecycle, CorrespondingEventsFunction<Lifecycle.Event> boundaryResolver) {
        return new AndroidLifecycleScopeProvider(lifecycle, boundaryResolver);
    }

    private AndroidLifecycleScopeProvider(Lifecycle lifecycle, CorrespondingEventsFunction<Lifecycle.Event> boundaryResolver) {
        this.lifecycleObservable = new LifecycleEventsObservable(lifecycle);
        this.boundaryResolver = boundaryResolver;
    }

    public Observable<Lifecycle.Event> lifecycle() {
        return this.lifecycleObservable;
    }

    public CorrespondingEventsFunction<Lifecycle.Event> correspondingEvents() {
        return this.boundaryResolver;
    }

    public Lifecycle.Event peekLifecycle() {
        this.lifecycleObservable.backfillEvents();
        return this.lifecycleObservable.getValue();
    }

    public CompletableSource requestScope() {
        return LifecycleScopes.resolveScopeFromLifecycle((LifecycleScopeProvider)this);
    }

    private static class UntilEventFunction
    implements CorrespondingEventsFunction<Lifecycle.Event> {
        private final Lifecycle.Event untilEvent;

        UntilEventFunction(Lifecycle.Event untilEvent) {
            this.untilEvent = untilEvent;
        }

        public Lifecycle.Event apply(Lifecycle.Event event) throws OutsideScopeException {
            return this.untilEvent;
        }
    }
}

