/*
 * Decompiled with CFR 0.152.
 */
package com.uber.autodispose.android.internal;

import android.support.annotation.RestrictTo;
import com.uber.autodispose.android.internal.AutoDisposeAndroidUtil;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class MainThreadDisposable
implements Disposable {
    private final AtomicBoolean unsubscribed = new AtomicBoolean();

    public final boolean isDisposed() {
        return this.unsubscribed.get();
    }

    public final void dispose() {
        if (this.unsubscribed.compareAndSet(false, true)) {
            if (AutoDisposeAndroidUtil.isMainThread()) {
                this.onDispose();
            } else {
                AndroidSchedulers.mainThread().scheduleDirect(new Runnable(){

                    @Override
                    public void run() {
                        MainThreadDisposable.this.onDispose();
                    }
                });
            }
        }
    }

    protected abstract void onDispose();
}

