/*
 * Decompiled with CFR 0.152.
 */
package com.uber.autodispose.lint;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.uber.autodispose.lint.AutoDisposeDetector;
import java.io.File;
import java.io.StringReader;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0016J\u0016\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00180\u0016H\u0016J\u001a\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0019H\u0002J\u001a\u0010!\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0018\u0010$\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/uber/autodispose/lint/AutoDisposeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "appliedScopes", "", "", "lenient", "", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "Lcom/android/tools/lint/detector/api/JavaContext;", "evaluateMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "getApplicableMethodNames", "", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "isCapturedTypeAllowed", "returnType", "Lcom/intellij/psi/PsiType;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "isExpressionValueUnused", "element", "isInScope", "psiClass", "Lcom/intellij/psi/PsiClass;", "isReactiveType", "Companion", "autodispose-lint"})
public final class AutoDisposeDetector
extends Detector
implements SourceCodeScanner {
    private Set<String> appliedScopes;
    private boolean lenient;
    @NotNull
    public static final String LINT_DESCRIPTION = "Missing Disposable handling: Apply AutoDispose or cache the Disposable instance manually and enable lenient mode.";
    @NotNull
    private static final Issue ISSUE;
    private static final String OBSERVABLE = "io.reactivex.Observable";
    private static final String FLOWABLE = "io.reactivex.Flowable";
    private static final String PARALLEL_FLOWABLE = "io.reactivex.parallel.ParallelFlowable";
    private static final String SINGLE = "io.reactivex.Single";
    private static final String MAYBE = "io.reactivex.Maybe";
    private static final String COMPLETABLE = "io.reactivex.Completable";
    private static final List<String> DEFAULT_SCOPES;
    private static final Set<String> REACTIVE_TYPES;
    @NotNull
    public static final String PROPERTY_FILE = "gradle.properties";
    public static final Companion Companion;

    public void beforeCheckRootProject(@NotNull Context context) {
        Object v2;
        Object object;
        Properties props;
        Set scopes;
        boolean overrideScopes;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            overrideScopes = false;
            scopes = new LinkedHashSet();
            props = new Properties();
            List list = context.getMainProject().getPropertyFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"context.mainProject.propertyFiles");
            object = list;
            Iterable iterable = object;
            for (Object t : iterable) {
                File it = (File)t;
                boolean bl = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                if (!Intrinsics.areEqual((Object)file.getName(), (Object)PROPERTY_FILE)) continue;
                v2 = t;
                break block6;
            }
            v2 = null;
        }
        File file = v2;
        if (file != null) {
            String string;
            Object $receiver = object = file;
            boolean bl = false;
            StringReader content = new StringReader(((Object)context.getClient().readFile((File)$receiver)).toString());
            props.load(content);
            String string2 = props.getProperty("autodispose.typesWithScope");
            if (string2 != null) {
                String scopeProperty = string = string2;
                boolean bl2 = false;
                List customScopes2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)scopeProperty, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)), (Function1)beforeCheckRootProject.2.1.customScopes.1.INSTANCE), (Function1)beforeCheckRootProject.2.1.customScopes.2.INSTANCE));
                scopes.addAll(customScopes2);
            }
            String string3 = props.getProperty("autodispose.lenient");
            if (string3 != null) {
                boolean bl3;
                string = string3;
                boolean it = bl3 = Boolean.parseBoolean(string);
                boolean bl4 = false;
                this.lenient = it;
            }
            String string4 = props.getProperty("autodispose.overrideScopes");
            if (string4 != null) {
                boolean bl5;
                String string5 = string4;
                boolean it = bl5 = Boolean.parseBoolean(string5);
                boolean bl6 = false;
                overrideScopes = it;
            }
        }
        if (!overrideScopes) {
            scopes.addAll((Collection)DEFAULT_SCOPES);
        }
        this.appliedScopes = scopes;
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{"subscribe", "subscribeWith"});
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ AutoDisposeDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                PsiElement method = node.resolve();
                if (method instanceof PsiMethod && node.getUastParent() != null && node.getUastParent() instanceof UCallExpression) {
                    UElement uElement = node.getUastParent();
                    if (uElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                    }
                    AutoDisposeDetector.access$evaluateMethodCall(this.this$0, (UCallExpression)uElement, (PsiMethod)method, this.$context);
                }
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                block0: {
                    PsiMethod psiMethod;
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    PsiMethod psiMethod2 = node.resolve();
                    if (psiMethod2 == null) break block0;
                    PsiMethod it = psiMethod = psiMethod2;
                    boolean bl = false;
                    AutoDisposeDetector.access$evaluateMethodCall(this.this$0, node, it, this.$context);
                }
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{UCallExpression.class, UCallableReferenceExpression.class});
    }

    private final boolean isInScope(JavaEvaluator evaluator, PsiClass psiClass) {
        PsiClass psiClass2 = psiClass;
        if (psiClass2 != null) {
            boolean bl;
            block5: {
                Iterable $receiver$iv;
                PsiClass psiClass3;
                PsiClass callingClass = psiClass3 = psiClass2;
                boolean bl2 = false;
                Set<String> set = this.appliedScopes;
                if (set == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"appliedScopes");
                }
                if (($receiver$iv = (Iterable)set) instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!evaluator.inheritsFrom(callingClass, it, false)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private final boolean isReactiveType(JavaEvaluator evaluator, PsiMethod method) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = REACTIVE_TYPES;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!evaluator.isMemberInClass((PsiMember)method, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isCapturedTypeAllowed(PsiType returnType, JavaEvaluator evaluator) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)returnType);
        if (psiClass != null) {
            PsiClass psiClass2;
            PsiClass it = psiClass2 = psiClass;
            boolean bl = false;
            PsiClass psiClass3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass3, (String)"it");
            return evaluator.inheritsFrom(psiClass3, "io.reactivex.disposables.Disposable", false);
        }
        return false;
    }

    private final void evaluateMethodCall(UCallExpression node, PsiMethod method, JavaContext context) {
        if (!this.getApplicableMethodNames().contains(method.getName())) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (this.isReactiveType(evaluator, method) && this.isInScope(evaluator, (PsiClass)UastUtils.getContainingUClass((UElement)((UElement)node)))) {
            if (!this.lenient) {
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)LINT_DESCRIPTION, null, (int)16, null);
            } else {
                boolean isUnusedReturnValue = this.isExpressionValueUnused((UElement)node);
                if (isUnusedReturnValue || !this.isCapturedTypeAllowed(node.getReturnType(), evaluator)) {
                    JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)LINT_DESCRIPTION, null, (int)16, null);
                }
            }
        }
    }

    private final boolean isExpressionValueUnused(UElement element) {
        UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)false);
        if (uExpression == null) {
            return true;
        }
        UExpression prev = uExpression;
        UElement uElement = prev.getUastParent();
        if (uElement == null) {
            return true;
        }
        UElement curr = uElement;
        while (curr instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)curr).getSelector() == prev) {
            prev = (UExpression)curr;
            if (curr.getUastParent() != null) continue;
            return true;
        }
        if (curr instanceof UBlockExpression) {
            if (curr.getUastParent() instanceof ULambdaExpression) {
                return false;
            }
            UElement block = curr;
            UExpression expression = prev;
            int index = ((UBlockExpression)block).getExpressions().indexOf(expression);
            if (index == -1) {
                return true;
            }
            if (index < ((UBlockExpression)block).getExpressions().size() - 1) {
                return true;
            }
            UElement uElement2 = curr.getUastParent();
            if (uElement2 == null) {
                return true;
            }
            UElement parent = uElement2;
            if (parent instanceof UMethod || parent instanceof UClassInitializer) {
                return true;
            }
            return this.isExpressionValueUnused(parent);
        }
        return curr instanceof UMethod && ((UMethod)curr).isConstructor();
    }

    static {
        Companion = new Companion(null);
        ISSUE = Issue.Companion.create("AutoDispose", LINT_DESCRIPTION, "You're subscribing to an observable but not handling its subscription. This can result in memory leaks. You can avoid memory leaks by appending `.as(autoDisposable(this))` before you subscribe or cache the Disposable instance manually and enable lenient mode. More: https://github.com/uber/AutoDispose/wiki/Lint-Check", Category.CORRECTNESS, 10, Severity.ERROR, new Implementation(AutoDisposeDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES), new EnumSet[]{EnumSet.of((Enum)Scope.JAVA_FILE), EnumSet.of((Enum)Scope.TEST_SOURCES)}));
        DEFAULT_SCOPES = CollectionsKt.listOf((Object[])new String[]{"androidx.lifecycle.LifecycleOwner", "com.uber.autodispose.ScopeProvider", "android.app.Activity", "android.app.Fragment"});
        REACTIVE_TYPES = SetsKt.setOf((Object[])new String[]{OBSERVABLE, FLOWABLE, PARALLEL_FLOWABLE, SINGLE, MAYBE, COMPLETABLE});
    }

    public static final /* synthetic */ void access$evaluateMethodCall(AutoDisposeDetector $this, UCallExpression node, PsiMethod method, JavaContext context) {
        $this.evaluateMethodCall(node, method, context);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/uber/autodispose/lint/AutoDisposeDetector$Companion;", "", "()V", "COMPLETABLE", "", "DEFAULT_SCOPES", "", "FLOWABLE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "LINT_DESCRIPTION", "MAYBE", "OBSERVABLE", "PARALLEL_FLOWABLE", "PROPERTY_FILE", "REACTIVE_TYPES", "", "SINGLE", "autodispose-lint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

