

```
public interface LifecycleScopeProvider<E> extends ScopeProvider {
Observable<E> lifecycle();

Function<E, E> correspondingEvents();

E peekLifecycle();

// Inherited from ScopeProvider
CompletableSource requestScope();
}
```

### All Types

| Name | Summary |
|---|---|
| [autodispose2.lifecycle.CorrespondingEventsFunction](../autodispose2.lifecycle/-corresponding-events-function/index.md) | A corresponding events function that acts as a normal ``[`Function`](#) but ensures a single event type in the generic and tightens the possible exception thrown to ``[`OutsideScopeException`](#). |
| [autodispose2.lifecycle.LifecycleEndedException](../autodispose2.lifecycle/-lifecycle-ended-exception/index.md) | Signifies an error occurred due to execution starting after the lifecycle has ended. |
| [autodispose2.lifecycle.LifecycleNotStartedException](../autodispose2.lifecycle/-lifecycle-not-started-exception/index.md) | Signifies an error occurred due to execution starting before the lifecycle has started. |
| [autodispose2.lifecycle.LifecycleScopeProvider](../autodispose2.lifecycle/-lifecycle-scope-provider/index.md) | A convenience interface that, when implemented, helps provide information to create implementations that resolve the next corresponding lifecycle event and construct a ``[`Completable`](#) representation of it from the ``[`#lifecycle()`](../autodispose2.lifecycle/-lifecycle-scope-provider/lifecycle.md) stream.  |
| [autodispose2.lifecycle.LifecycleScopes](../autodispose2.lifecycle/-lifecycle-scopes/index.md) | Utilities for dealing with ``[`LifecycleScopeProvider`](../autodispose2.lifecycle/-lifecycle-scope-provider/index.md)s. This includes factories for resolving ``[`Completable`](#) representations of scopes, corresponding events, etc. |
| [autodispose2.lifecycle.TestLifecycleScopeProvider](../autodispose2.lifecycle/-test-lifecycle-scope-provider/index.md) | Test utility to create ``[`LifecycleScopeProvider`](../autodispose2.lifecycle/-lifecycle-scope-provider/index.md) instances for tests.  |
