[autodispose-lifecycle](../../index.md) / [autodispose2.lifecycle](../index.md) / [LifecycleScopes](./index.md)

# LifecycleScopes

`class LifecycleScopes`

Utilities for dealing with ``[`LifecycleScopeProvider`](../-lifecycle-scope-provider/index.md)s. This includes factories for resolving ``[`Completable`](#) representations of scopes, corresponding events, etc.

### Functions

| Name | Summary |
|---|---|
| [resolveScopeFromLifecycle](resolve-scope-from-lifecycle.md) | `static fun <E : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!> resolveScopeFromLifecycle(provider: `[`LifecycleScopeProvider`](../-lifecycle-scope-provider/index.md)`<`[`E`](resolve-scope-from-lifecycle.md#E)`>!): CompletableSource!`<br>Overload for resolving lifecycle providers that defaults to checking start and end boundaries of lifecycles. That is, they will ensure that the lifecycle has both started and not ended. `static fun <E : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!> resolveScopeFromLifecycle(provider: `[`LifecycleScopeProvider`](../-lifecycle-scope-provider/index.md)`<`[`E`](resolve-scope-from-lifecycle.md#E)`>!, checkEndBoundary: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): CompletableSource!`<br>Overload for resolving lifecycle providers allows configuration of checking "end" boundaries of lifecycles. That is, they will ensure that the lifecycle has both started and not ended, and otherwise will throw one of ``[`LifecycleNotStartedException`](../-lifecycle-not-started-exception/index.md) (if ``[` `](../-lifecycle-scope-provider/peek-lifecycle.md) returns `null`) or if the lifecycle is ended. To configure the runtime behavior of these exceptions, see ``[`AutoDisposePlugins`](#). `static fun <E : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!> resolveScopeFromLifecycle(lifecycle: Observable<`[`E`](resolve-scope-from-lifecycle.md#E)`>!, endEvent: `[`E`](resolve-scope-from-lifecycle.md#E)`): CompletableSource!`<br>`static fun <E : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!> resolveScopeFromLifecycle(lifecycle: Observable<`[`E`](resolve-scope-from-lifecycle.md#E)`>!, endEvent: `[`E`](resolve-scope-from-lifecycle.md#E)`, comparator: `[`Comparator`](https://docs.oracle.com/javase/6/docs/api/java/util/Comparator.html)`<`[`E`](resolve-scope-from-lifecycle.md#E)`>!): CompletableSource!` |
