

AutoDispose is an RxJava 2 tool for automatically binding the execution of RxJava 2 streams to a
provided scope via disposal/cancellation.

### All Types

| Name | Summary |
|---|---|
| [autodispose2.AutoDispose](../autodispose2/-auto-dispose/index.md) | Factories for autodispose converters that can be used with RxJava types' corresponding `as(...)` methods to transform them into auto-disposing streams.  |
| [autodispose2.AutoDisposeContext](../autodispose2/-auto-dispose-context/index.md) | A context intended for use as `AutoDisposeContext.() -> Unit` function body parameters where zero-arg [autoDispose](../autodispose2/-auto-dispose-context/auto-dispose.md) functions can be called. This should be backed by an underlying [Completable](#) or [ScopeProvider](../autodispose2/-scope-provider/index.md). |
| [autodispose2.AutoDisposeConverter](../autodispose2/-auto-dispose-converter.md) | A custom converter that implements all the RxJava types converters, for use with the `as()` operator. |
| [autodispose2.AutoDisposePlugins](../autodispose2/-auto-dispose-plugins/index.md) | Utility class to inject handlers to certain standard autodispose-lifecycle operations. |
| [autodispose2.observers.AutoDisposingCompletableObserver](../autodispose2.observers/-auto-disposing-completable-observer/index.md) | A ``[`Disposable`](#) ``[`CompletableObserver`](#) that can automatically dispose itself. Interface here for type safety but enforcement is left to the implementation. |
| [autodispose2.observers.AutoDisposingMaybeObserver](../autodispose2.observers/-auto-disposing-maybe-observer/index.md) | A ``[`Disposable`](#) ``[`MaybeObserver`](#) that can automatically dispose itself. Interface here for type safety but enforcement is left to the implementation. |
| [autodispose2.observers.AutoDisposingObserver](../autodispose2.observers/-auto-disposing-observer/index.md) | A ``[`Disposable`](#) ``[`Observer`](#) that can automatically dispose itself. Interface here for type safety but enforcement is left to the implementation. |
| [autodispose2.observers.AutoDisposingSingleObserver](../autodispose2.observers/-auto-disposing-single-observer/index.md) | A ``[`Disposable`](#) ``[`SingleObserver`](#) that can automatically dispose itself. Interface here for type safety but enforcement is left to the implementation. |
| [autodispose2.observers.AutoDisposingSubscriber](../autodispose2.observers/-auto-disposing-subscriber/index.md) | A ``[`Disposable`](#) ``[`Subscriber`](#) that can automatically dispose itself. Interface here for type safety but enforcement is left to the implementation. |
| [io.reactivex.rxjava3.core.Completable](../autodispose2/io.reactivex.rxjava3.core.-completable/index.md) (extensions in package autodispose2) |  |
| [autodispose2.CompletableSubscribeProxy](../autodispose2/-completable-subscribe-proxy/index.md) | Subscribe proxy that matches ``[`Completable`](#)'s subscribe overloads. |
| [autodispose2.internal.DoNotMock](../autodispose2.internal/-do-not-mock/index.md) | This annotation indicates that a given type should not be mocked. This is a copy of what was in Error-Prone's annotations artifact before it was removed, but left for documentation purposes.  |
| [io.reactivex.rxjava3.core.Flowable](../autodispose2/io.reactivex.rxjava3.core.-flowable/index.md) (extensions in package autodispose2) |  |
| [autodispose2.FlowableSubscribeProxy](../autodispose2/-flowable-subscribe-proxy/index.md) | Subscribe proxy that matches ``[`Flowable`](#)'s subscribe overloads. |
| [io.reactivex.rxjava3.core.Maybe](../autodispose2/io.reactivex.rxjava3.core.-maybe/index.md) (extensions in package autodispose2) |  |
| [autodispose2.MaybeSubscribeProxy](../autodispose2/-maybe-subscribe-proxy/index.md) | Subscribe proxy that matches ``[`Maybe`](#)'s subscribe overloads. |
| [io.reactivex.rxjava3.core.Observable](../autodispose2/io.reactivex.rxjava3.core.-observable/index.md) (extensions in package autodispose2) |  |
| [autodispose2.ObservableSubscribeProxy](../autodispose2/-observable-subscribe-proxy/index.md) | Subscribe proxy that matches ``[`Observable`](#)'s subscribe overloads. |
| [autodispose2.OutsideScopeException](../autodispose2/-outside-scope-exception/index.md) | Signifies an error occurred due to execution starting outside the lifecycle. |
| [io.reactivex.rxjava3.parallel.ParallelFlowable](../autodispose2/io.reactivex.rxjava3.parallel.-parallel-flowable/index.md) (extensions in package autodispose2) |  |
| [autodispose2.ParallelFlowableSubscribeProxy](../autodispose2/-parallel-flowable-subscribe-proxy/index.md) | Subscribe proxy that matches ``[`ParallelFlowable`](#)'s subscribe overloads. |
| [autodispose2.ScopeProvider](../autodispose2/-scope-provider/index.md) | Provides a ``[`CompletableSource`](#) representation of a scope. The emission of this is the signal |
| [autodispose2.Scopes](../autodispose2/-scopes/index.md) | Utilities for dealing with AutoDispose scopes. |
| [io.reactivex.rxjava3.core.Single](../autodispose2/io.reactivex.rxjava3.core.-single/index.md) (extensions in package autodispose2) |  |
| [autodispose2.SingleSubscribeProxy](../autodispose2/-single-subscribe-proxy/index.md) | Subscribe proxy that matches ``[`Single`](#)'s subscribe overloads. |
| [autodispose2.TestScopeProvider](../autodispose2/-test-scope-provider/index.md) | ScopeProvider implementation for testing. You can either back it with your own instance, or just stub it in place and use its public emit APIs. |
