[autodispose](../../index.md) / [autodispose2](../index.md) / [AutoDispose](./index.md)

# AutoDispose

`class AutoDispose`

Factories for autodispose converters that can be used with RxJava types' corresponding `as(...)` methods to transform them into auto-disposing streams.

There are several static `autoDisposable(...)` entry points, with the most basic being a simple ``[`#autoDisposable(CompletableSource)`](auto-disposable.md). The provided ``[`CompletableSource`](#) is ultimately what every scope resolves to under the hood, and AutoDispose has some built-in understanding for predefined types. The scope is considered ended upon onComplete emission of this ``[`Completable`](#).

This is structured in such a way to be friendly to autocompletion in IDEs, where the no-parameter generic method will autocomplete with the appropriate generic parameters in Java &lt;7, or implicitly in &gt;=8.

**See Also**
[Flowable#to(io.reactivex.rxjava3.core.FlowableConverter)](#)[Observable#to(io.reactivex.rxjava3.core.ObservableConverter)](#)[Maybe#to(io.reactivex.rxjava3.core.MaybeConverter)](#)[Single#to(io.reactivex.rxjava3.core.SingleConverter)](#)[Completable#to(io.reactivex.rxjava3.core.CompletableConverter)](#)

### Functions

| Name | Summary |
|---|---|
| [autoDisposable](auto-disposable.md) | `static fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!> autoDisposable(provider: `[`ScopeProvider`](../-scope-provider/index.md)`!): `[`AutoDisposeConverter`](../-auto-dispose-converter.md)`<`[`T`](auto-disposable.md#T)`>!`<br>Entry point for auto-disposing streams from a ``[`ScopeProvider`](../-scope-provider/index.md). `static fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!> autoDisposable(scope: CompletableSource!): `[`AutoDisposeConverter`](../-auto-dispose-converter.md)`<`[`T`](auto-disposable.md#T)`>!`<br>Entry point for auto-disposing streams from a ``[`CompletableSource`](#).  |
