[autodispose](../index.md) / [autodispose2](./index.md)

## Package autodispose2

Core implementation.

### Types

| Name | Summary |
|---|---|
| [AutoDispose](-auto-dispose/index.md) | `class AutoDispose`<br>Factories for autodispose converters that can be used with RxJava types' corresponding `as(...)` methods to transform them into auto-disposing streams.  |
| [AutoDisposeContext](-auto-dispose-context/index.md) | `interface AutoDisposeContext`<br>A context intended for use as `AutoDisposeContext.() -> Unit` function body parameters where zero-arg [autoDispose](-auto-dispose-context/auto-dispose.md) functions can be called. This should be backed by an underlying [Completable](#) or [ScopeProvider](-scope-provider/index.md). |
| [AutoDisposeConverter](-auto-dispose-converter.md) | `interface AutoDisposeConverter<T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!> : FlowableConverter<`[`T`](-auto-dispose-converter.md#T)`, `[`FlowableSubscribeProxy`](-flowable-subscribe-proxy/index.md)`<`[`T`](-auto-dispose-converter.md#T)`>!>, ParallelFlowableConverter<`[`T`](-auto-dispose-converter.md#T)`, `[`ParallelFlowableSubscribeProxy`](-parallel-flowable-subscribe-proxy/index.md)`<`[`T`](-auto-dispose-converter.md#T)`>!>, ObservableConverter<`[`T`](-auto-dispose-converter.md#T)`, `[`ObservableSubscribeProxy`](-observable-subscribe-proxy/index.md)`<`[`T`](-auto-dispose-converter.md#T)`>!>, MaybeConverter<`[`T`](-auto-dispose-converter.md#T)`, `[`MaybeSubscribeProxy`](-maybe-subscribe-proxy/index.md)`<`[`T`](-auto-dispose-converter.md#T)`>!>, SingleConverter<`[`T`](-auto-dispose-converter.md#T)`, `[`SingleSubscribeProxy`](-single-subscribe-proxy/index.md)`<`[`T`](-auto-dispose-converter.md#T)`>!>, CompletableConverter<`[`CompletableSubscribeProxy`](-completable-subscribe-proxy/index.md)`!>`<br>A custom converter that implements all the RxJava types converters, for use with the `as()` operator. |
| [AutoDisposePlugins](-auto-dispose-plugins/index.md) | `class AutoDisposePlugins`<br>Utility class to inject handlers to certain standard autodispose-lifecycle operations. |
| [CompletableSubscribeProxy](-completable-subscribe-proxy/index.md) | `interface CompletableSubscribeProxy`<br>Subscribe proxy that matches ``[`Completable`](#)'s subscribe overloads. |
| [FlowableSubscribeProxy](-flowable-subscribe-proxy/index.md) | `interface FlowableSubscribeProxy<T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!>`<br>Subscribe proxy that matches ``[`Flowable`](#)'s subscribe overloads. |
| [MaybeSubscribeProxy](-maybe-subscribe-proxy/index.md) | `interface MaybeSubscribeProxy<T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!>`<br>Subscribe proxy that matches ``[`Maybe`](#)'s subscribe overloads. |
| [ObservableSubscribeProxy](-observable-subscribe-proxy/index.md) | `interface ObservableSubscribeProxy<T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!>`<br>Subscribe proxy that matches ``[`Observable`](#)'s subscribe overloads. |
| [ParallelFlowableSubscribeProxy](-parallel-flowable-subscribe-proxy/index.md) | `interface ParallelFlowableSubscribeProxy<T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!>`<br>Subscribe proxy that matches ``[`ParallelFlowable`](#)'s subscribe overloads. |
| [ScopeProvider](-scope-provider/index.md) | `interface ScopeProvider`<br>Provides a ``[`CompletableSource`](#) representation of a scope. The emission of this is the signal |
| [Scopes](-scopes/index.md) | `class Scopes`<br>Utilities for dealing with AutoDispose scopes. |
| [SingleSubscribeProxy](-single-subscribe-proxy/index.md) | `interface SingleSubscribeProxy<T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`!>`<br>Subscribe proxy that matches ``[`Single`](#)'s subscribe overloads. |
| [TestScopeProvider](-test-scope-provider/index.md) | `class TestScopeProvider : `[`ScopeProvider`](-scope-provider/index.md)<br>ScopeProvider implementation for testing. You can either back it with your own instance, or just stub it in place and use its public emit APIs. |

### Exceptions

| Name | Summary |
|---|---|
| [OutsideScopeException](-outside-scope-exception/index.md) | `open class OutsideScopeException : `[`RuntimeException`](https://docs.oracle.com/javase/6/docs/api/java/lang/RuntimeException.html)<br>Signifies an error occurred due to execution starting outside the lifecycle. |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [io.reactivex.rxjava3.core.Completable](io.reactivex.rxjava3.core.-completable/index.md) |  |
| [io.reactivex.rxjava3.core.Flowable](io.reactivex.rxjava3.core.-flowable/index.md) |  |
| [io.reactivex.rxjava3.core.Maybe](io.reactivex.rxjava3.core.-maybe/index.md) |  |
| [io.reactivex.rxjava3.core.Observable](io.reactivex.rxjava3.core.-observable/index.md) |  |
| [io.reactivex.rxjava3.core.Single](io.reactivex.rxjava3.core.-single/index.md) |  |
| [io.reactivex.rxjava3.parallel.ParallelFlowable](io.reactivex.rxjava3.parallel.-parallel-flowable/index.md) |  |

### Functions

| Name | Summary |
|---|---|
| [withScope](with-scope.md) | `fun withScope(scope: `[`ScopeProvider`](-scope-provider/index.md)`, body: `[`AutoDisposeContext`](-auto-dispose-context/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Executes a [body](with-scope.md#autodispose2$withScope(autodispose2.ScopeProvider, kotlin.Function1((autodispose2.AutoDisposeContext, kotlin.Unit)))/body) with an [AutoDisposeContext](-auto-dispose-context/index.md) backed by the given [scope](with-scope.md#autodispose2$withScope(autodispose2.ScopeProvider, kotlin.Function1((autodispose2.AutoDisposeContext, kotlin.Unit)))/scope).`fun withScope(completableScope: Completable, body: `[`AutoDisposeContext`](-auto-dispose-context/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Executes a [body](with-scope.md#autodispose2$withScope(io.reactivex.rxjava3.core.Completable, kotlin.Function1((autodispose2.AutoDisposeContext, kotlin.Unit)))/body) with an [AutoDisposeContext](-auto-dispose-context/index.md) backed by the given [completableScope](with-scope.md#autodispose2$withScope(io.reactivex.rxjava3.core.Completable, kotlin.Function1((autodispose2.AutoDisposeContext, kotlin.Unit)))/completableScope). |
