/*
 * Decompiled with CFR 0.152.
 */
package autodispose2.lint;

import autodispose2.lint.AutoDisposeDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import java.io.File;
import java.io.StringReader;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0002()B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J:\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\b0\u0014H\u0002J:\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\b0\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J:\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u000e2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\b0\u0014H\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0016J\u0016\u0010\u001f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020!0 0\u001eH\u0016J\u001a\u0010\"\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020!H\u0002J\u0018\u0010'\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lautodispose2/lint/AutoDisposeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "appliedScopes", "", "", "lenient", "", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "callExpressionChecker", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "isInScope", "Lkotlin/Function2;", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "callableReferenceChecker", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "containingClassScopeChecker", "evaluator", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "evaluateMethodCall", "getApplicableMethodNames", "", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "isCapturedTypeAllowed", "returnType", "Lcom/intellij/psi/PsiType;", "isExpressionValueUnused", "element", "isReactiveType", "Companion", "SubscribeCallVisitor", "autodispose-lint"})
public final class AutoDisposeDetector
extends Detector
implements SourceCodeScanner {
    private Set<String> appliedScopes;
    private boolean lenient;
    @NotNull
    public static final String LINT_DESCRIPTION = "Missing Disposable handling: Apply AutoDispose or cache the Disposable instance manually and enable lenient mode.";
    @NotNull
    private static final Issue ISSUE;
    private static final String OBSERVABLE = "io.reactivex.rxjava3.core.Observable";
    private static final String FLOWABLE = "io.reactivex.rxjava3.core.Flowable";
    private static final String PARALLEL_FLOWABLE = "io.reactivex.rxjava3.core.parallel.ParallelFlowable";
    private static final String SINGLE = "io.reactivex.rxjava3.core.Single";
    private static final String MAYBE = "io.reactivex.rxjava3.core.Maybe";
    private static final String COMPLETABLE = "io.reactivex.rxjava3.core.Completable";
    private static final String KOTLIN_EXTENSIONS = "autodispose2.KotlinExtensions";
    private static final List<String> DEFAULT_SCOPES;
    private static final Set<String> REACTIVE_TYPES;
    @NotNull
    public static final String PROPERTY_FILE = "gradle.properties";
    public static final Companion Companion;

    public void beforeCheckRootProject(@NotNull Context context) {
        Object v2;
        boolean bl;
        Object object;
        Properties props;
        Set scopes;
        boolean overrideScopes;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            overrideScopes = false;
            boolean bl2 = false;
            scopes = new LinkedHashSet();
            props = new Properties();
            List list = context.getMainProject().getPropertyFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"context.mainProject.propertyFiles");
            object = list;
            bl = false;
            Iterable iterable = object;
            boolean bl3 = false;
            for (Object t : iterable) {
                File it = (File)t;
                boolean bl4 = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                if (!Intrinsics.areEqual((Object)file.getName(), (Object)PROPERTY_FILE)) continue;
                v2 = t;
                break block6;
            }
            v2 = null;
        }
        File file = v2;
        if (file != null) {
            boolean bl5;
            boolean bl6;
            String string;
            object = file;
            bl = false;
            boolean bl7 = false;
            Object $this$apply = object;
            boolean bl8 = false;
            StringReader content = new StringReader(((Object)context.getClient().readFile((File)$this$apply)).toString());
            props.load(content);
            String string2 = props.getProperty("autodispose.typesWithScope");
            if (string2 != null) {
                string = string2;
                bl6 = false;
                bl5 = false;
                String scopeProperty = string;
                boolean bl9 = false;
                List customScopes2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)scopeProperty, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)), (Function1)beforeCheckRootProject.2.1.customScopes.1.INSTANCE), (Function1)beforeCheckRootProject.2.1.customScopes.2.INSTANCE));
                scopes.addAll(customScopes2);
            }
            String string3 = props.getProperty("autodispose.lenient");
            if (string3 != null) {
                string = string3;
                bl6 = false;
                boolean bl10 = Boolean.parseBoolean(string);
                bl6 = false;
                bl5 = false;
                boolean it = bl10;
                boolean bl11 = false;
                this.lenient = it;
            }
            String string4 = props.getProperty("autodispose.overrideScopes");
            if (string4 != null) {
                String string5 = string4;
                bl6 = false;
                boolean bl12 = Boolean.parseBoolean(string5);
                bl6 = false;
                bl5 = false;
                boolean it = bl12;
                boolean bl13 = false;
                overrideScopes = it;
            }
        }
        if (!overrideScopes) {
            scopes.addAll((Collection)DEFAULT_SCOPES);
        }
        this.appliedScopes = scopes;
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{"subscribe", "subscribeWith"});
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ AutoDisposeDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    PsiElement psiElement = node.resolve();
                    if (psiElement == null) break block1;
                    PsiElement psiElement2 = psiElement;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiElement method = psiElement2;
                    boolean bl3 = false;
                    if (method instanceof PsiMethod) {
                        AutoDisposeDetector.access$callableReferenceChecker(this.this$0, this.$context, node, (PsiMethod)method, (Function2)new Function2<JavaEvaluator, UCallExpression, Boolean>(this.this$0){

                            public final boolean invoke(@NotNull JavaEvaluator p1, @NotNull UCallExpression p2) {
                                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                                return AutoDisposeDetector.access$containingClassScopeChecker((AutoDisposeDetector)((Object)this.receiver), p1, p2);
                            }

                            public final KDeclarationContainer getOwner() {
                                return Reflection.getOrCreateKotlinClass(AutoDisposeDetector.class);
                            }

                            public final String getName() {
                                return "containingClassScopeChecker";
                            }

                            public final String getSignature() {
                                return "containingClassScopeChecker(Lcom/android/tools/lint/client/api/JavaEvaluator;Lorg/jetbrains/uast/UCallExpression;)Z";
                            }
                        });
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                PsiMethod psiMethod = node.resolve();
                if (psiMethod == null) return;
                PsiMethod psiMethod2 = psiMethod;
                boolean bl = false;
                boolean bl2 = false;
                PsiMethod method = psiMethod2;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)method.getName(), (Object)"withScope")) {
                    UExpression last;
                    List args;
                    PsiClass psiClass = method.getContainingClass();
                    if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"autodispose2.KotlinExtensions") && (args = node.getValueArguments()).size() == 2 && (last = (UExpression)args.get(1)) instanceof ULambdaExpression) {
                        UExpression body = ((ULambdaExpression)last).getBody();
                        SubscribeCallVisitor visitor2 = new SubscribeCallVisitor(this.$context, (Function3<? super JavaContext, ? super UCallExpression, ? super PsiMethod, Unit>)((Function3)new Function3<JavaContext, UCallExpression, PsiMethod, Unit>(this, node){
                            final /* synthetic */ createUastHandler.1 this$0;
                            final /* synthetic */ UCallExpression $node$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$node$inlined = uCallExpression;
                                super(3);
                            }

                            public final void invoke(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod calledMethod) {
                                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                                Intrinsics.checkParameterIsNotNull((Object)calledMethod, (String)"calledMethod");
                                AutoDisposeDetector.access$callExpressionChecker(this.this$0.this$0, context, node, calledMethod, createUastHandler.visitCallExpression.1.visitor.1.INSTANCE);
                            }
                        }), (Function3<? super JavaContext, ? super UCallableReferenceExpression, ? super PsiMethod, Unit>)((Function3)new Function3<JavaContext, UCallableReferenceExpression, PsiMethod, Unit>(this, node){
                            final /* synthetic */ createUastHandler.1 this$0;
                            final /* synthetic */ UCallExpression $node$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$node$inlined = uCallExpression;
                                super(3);
                            }

                            public final void invoke(@NotNull JavaContext context, @NotNull UCallableReferenceExpression node, @NotNull PsiMethod calledMethod) {
                                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                                Intrinsics.checkParameterIsNotNull((Object)calledMethod, (String)"calledMethod");
                                AutoDisposeDetector.access$callableReferenceChecker(this.this$0.this$0, context, node, calledMethod, createUastHandler.visitCallExpression.1.visitor.1.INSTANCE);
                            }
                        }));
                        body.accept((UastVisitor)visitor2);
                        return;
                    }
                }
                AutoDisposeDetector.access$callExpressionChecker(this.this$0, this.$context, node, method, (Function2)new Function2<JavaEvaluator, UCallExpression, Boolean>(this.this$0){

                    public final boolean invoke(@NotNull JavaEvaluator p1, @NotNull UCallExpression p2) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                        return AutoDisposeDetector.access$containingClassScopeChecker((AutoDisposeDetector)((Object)this.receiver), p1, p2);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(AutoDisposeDetector.class);
                    }

                    public final String getName() {
                        return "containingClassScopeChecker";
                    }

                    public final String getSignature() {
                        return "containingClassScopeChecker(Lcom/android/tools/lint/client/api/JavaEvaluator;Lorg/jetbrains/uast/UCallExpression;)Z";
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    private final void callExpressionChecker(JavaContext context, UCallExpression node, PsiMethod method, Function2<? super JavaEvaluator, ? super UCallExpression, Boolean> isInScope) {
        this.evaluateMethodCall(node, method, context, isInScope);
    }

    private final void callableReferenceChecker(JavaContext context, UCallableReferenceExpression node, PsiMethod method, Function2<? super JavaEvaluator, ? super UCallExpression, Boolean> isInScope) {
        if (node.getUastParent() != null && node.getUastParent() instanceof UCallExpression) {
            UElement uElement = node.getUastParent();
            if (uElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            }
            this.evaluateMethodCall((UCallExpression)uElement, method, context, isInScope);
        }
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{UCallExpression.class, UCallableReferenceExpression.class});
    }

    private final boolean containingClassScopeChecker(JavaEvaluator evaluator, UCallExpression node) {
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
        if (uClass != null) {
            boolean bl;
            block5: {
                UClass uClass2 = uClass;
                boolean bl2 = false;
                boolean bl3 = false;
                UClass callingClass = uClass2;
                boolean bl4 = false;
                Set<String> set = this.appliedScopes;
                if (set == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"appliedScopes");
                }
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl5 = false;
                        if (!evaluator.inheritsFrom((PsiClass)callingClass, it, false)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private final boolean isReactiveType(JavaEvaluator evaluator, PsiMethod method) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = REACTIVE_TYPES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!evaluator.isMemberInClass((PsiMember)method, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isCapturedTypeAllowed(PsiType returnType, JavaEvaluator evaluator) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)returnType);
        if (psiClass != null) {
            PsiClass psiClass2 = psiClass;
            boolean bl = false;
            boolean bl2 = false;
            PsiClass it = psiClass2;
            boolean bl3 = false;
            return evaluator.inheritsFrom(it, "io.reactivex.rxjava3.disposables.Disposable", false);
        }
        return false;
    }

    private final void evaluateMethodCall(UCallExpression node, PsiMethod method, JavaContext context, Function2<? super JavaEvaluator, ? super UCallExpression, Boolean> isInScope) {
        if (!this.getApplicableMethodNames().contains(method.getName())) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (this.isReactiveType(evaluator, method) && ((Boolean)isInScope.invoke((Object)evaluator, (Object)node)).booleanValue()) {
            if (!this.lenient) {
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)LINT_DESCRIPTION, null, (int)16, null);
            } else {
                boolean isUnusedReturnValue = this.isExpressionValueUnused((UElement)node);
                if (isUnusedReturnValue || !this.isCapturedTypeAllowed(node.getReturnType(), evaluator)) {
                    JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)LINT_DESCRIPTION, null, (int)16, null);
                }
            }
        }
    }

    private final boolean isExpressionValueUnused(UElement element) {
        UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)false);
        if (uExpression == null) {
            return true;
        }
        UExpression prev = uExpression;
        UElement uElement = prev.getUastParent();
        if (uElement == null) {
            return true;
        }
        UElement curr = uElement;
        while (curr instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)curr).getSelector() == prev) {
            prev = (UExpression)curr;
            if (curr.getUastParent() != null) continue;
            return true;
        }
        if (curr instanceof UBlockExpression) {
            if (curr.getUastParent() instanceof ULambdaExpression) {
                return false;
            }
            UElement block = curr;
            UExpression expression = prev;
            int index = ((UBlockExpression)block).getExpressions().indexOf(expression);
            if (index == -1) {
                return true;
            }
            if (index < ((UBlockExpression)block).getExpressions().size() - 1) {
                return true;
            }
            UElement uElement2 = curr.getUastParent();
            if (uElement2 == null) {
                return true;
            }
            UElement parent = uElement2;
            if (parent instanceof UMethod || parent instanceof UClassInitializer) {
                return true;
            }
            return this.isExpressionValueUnused(parent);
        }
        return curr instanceof UMethod && ((UMethod)curr).isConstructor();
    }

    static {
        Companion = new Companion(null);
        ISSUE = Issue.Companion.create("AutoDispose", LINT_DESCRIPTION, "You're subscribing to an observable but not handling its subscription. This can result in memory leaks. You can avoid memory leaks by appending `.as(autoDisposable(this))` before you subscribe or cache the Disposable instance manually and enable lenient mode. More: https://github.com/uber/AutoDispose/wiki/Lint-Check", Category.CORRECTNESS, 10, Severity.ERROR, new Implementation(AutoDisposeDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES), new EnumSet[]{EnumSet.of((Enum)Scope.JAVA_FILE), EnumSet.of((Enum)Scope.TEST_SOURCES)}));
        DEFAULT_SCOPES = CollectionsKt.listOf((Object[])new String[]{"androidx.lifecycle.LifecycleOwner", "autodispose2.ScopeProvider", "android.app.Activity", "android.app.Fragment"});
        REACTIVE_TYPES = SetsKt.setOf((Object[])new String[]{OBSERVABLE, FLOWABLE, PARALLEL_FLOWABLE, SINGLE, MAYBE, COMPLETABLE});
    }

    public static final /* synthetic */ void access$callableReferenceChecker(AutoDisposeDetector $this, JavaContext context, UCallableReferenceExpression node, PsiMethod method, Function2 isInScope) {
        $this.callableReferenceChecker(context, node, method, (Function2<? super JavaEvaluator, ? super UCallExpression, Boolean>)isInScope);
    }

    public static final /* synthetic */ boolean access$containingClassScopeChecker(AutoDisposeDetector $this, JavaEvaluator evaluator, UCallExpression node) {
        return $this.containingClassScopeChecker(evaluator, node);
    }

    public static final /* synthetic */ void access$callExpressionChecker(AutoDisposeDetector $this, JavaContext context, UCallExpression node, PsiMethod method, Function2 isInScope) {
        $this.callExpressionChecker(context, node, method, (Function2<? super JavaEvaluator, ? super UCallExpression, Boolean>)isInScope);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u0012\u001e\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0006H\u0016R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lautodispose2/lint/AutoDisposeDetector$SubscribeCallVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "callExpressionChecker", "Lkotlin/Function3;", "Lorg/jetbrains/uast/UCallExpression;", "Lcom/intellij/psi/PsiMethod;", "", "callableReferenceChecker", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "(Lcom/android/tools/lint/detector/api/JavaContext;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;)V", "afterVisitCallableReferenceExpression", "node", "visitCallExpression", "", "autodispose-lint"})
    private static final class SubscribeCallVisitor
    extends AbstractUastVisitor {
        private final JavaContext context;
        private final Function3<JavaContext, UCallExpression, PsiMethod, Unit> callExpressionChecker;
        private final Function3<JavaContext, UCallableReferenceExpression, PsiMethod, Unit> callableReferenceChecker;

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                PsiMethod psiMethod = node.resolve();
                if (psiMethod == null) break block0;
                PsiMethod psiMethod2 = psiMethod;
                boolean bl = false;
                boolean bl2 = false;
                PsiMethod it = psiMethod2;
                boolean bl3 = false;
                this.callExpressionChecker.invoke((Object)this.context, (Object)node, (Object)it);
            }
            return super.visitCallExpression(node);
        }

        public void afterVisitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            PsiElement psiElement = node.resolve();
            if (psiElement != null) {
                PsiElement psiElement2 = psiElement;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement it = psiElement2;
                boolean bl3 = false;
                if (it instanceof PsiMethod) {
                    this.callableReferenceChecker.invoke((Object)this.context, (Object)node, (Object)it);
                }
            }
            super.afterVisitCallableReferenceExpression(node);
        }

        public SubscribeCallVisitor(@NotNull JavaContext context, @NotNull Function3<? super JavaContext, ? super UCallExpression, ? super PsiMethod, Unit> callExpressionChecker, @NotNull Function3<? super JavaContext, ? super UCallableReferenceExpression, ? super PsiMethod, Unit> callableReferenceChecker) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(callExpressionChecker, (String)"callExpressionChecker");
            Intrinsics.checkParameterIsNotNull(callableReferenceChecker, (String)"callableReferenceChecker");
            this.context = context;
            this.callExpressionChecker = callExpressionChecker;
            this.callableReferenceChecker = callableReferenceChecker;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lautodispose2/lint/AutoDisposeDetector$Companion;", "", "()V", "COMPLETABLE", "", "DEFAULT_SCOPES", "", "FLOWABLE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "KOTLIN_EXTENSIONS", "LINT_DESCRIPTION", "MAYBE", "OBSERVABLE", "PARALLEL_FLOWABLE", "PROPERTY_FILE", "REACTIVE_TYPES", "", "SINGLE", "autodispose-lint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

