/*
 * Decompiled with CFR 0.152.
 */
package autodispose2.android.internal;

import androidx.annotation.RestrictTo;
import autodispose2.android.internal.AutoDisposeAndroidUtil;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class MainThreadDisposable
implements Disposable {
    private final AtomicBoolean unsubscribed = new AtomicBoolean();

    public final boolean isDisposed() {
        return this.unsubscribed.get();
    }

    public final void dispose() {
        if (this.unsubscribed.compareAndSet(false, true)) {
            if (AutoDisposeAndroidUtil.isMainThread()) {
                this.onDispose();
            } else {
                AndroidSchedulers.mainThread().scheduleDirect(this::onDispose);
            }
        }
    }

    protected abstract void onDispose();
}

