/*
 * Decompiled with CFR 0.152.
 */
package autodispose2.android;

import androidx.annotation.Nullable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BooleanSupplier;

public final class AutoDisposeAndroidPlugins {
    @Nullable
    private static volatile BooleanSupplier onCheckMainThread;
    static volatile boolean lockdown;

    private AutoDisposeAndroidPlugins() {
    }

    public static void lockdown() {
        lockdown = true;
    }

    public static boolean isLockdown() {
        return lockdown;
    }

    public static void setOnCheckMainThread(@Nullable BooleanSupplier mainThreadChecker) {
        if (lockdown) {
            throw new IllegalStateException("Plugins can't be changed anymore");
        }
        onCheckMainThread = mainThreadChecker;
    }

    public static boolean onCheckMainThread(BooleanSupplier defaultChecker) {
        if (defaultChecker == null) {
            throw new NullPointerException("defaultChecker == null");
        }
        BooleanSupplier current = onCheckMainThread;
        try {
            if (current == null) {
                return defaultChecker.getAsBoolean();
            }
            return current.getAsBoolean();
        }
        catch (Throwable ex) {
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    public static void reset() {
        AutoDisposeAndroidPlugins.setOnCheckMainThread(null);
    }
}

